#ifndef __STREAM_H__
#define __STREAM_H__

#include "Commdef.h"

#define _STREAM

class SStream
{
public:
	SStream();
	virtual ~SStream();

private:
	SStream &operator =(const SStream &st);

protected:
	int m_nVersionInfo;

public:
	virtual void Close() = 0;
	int GetVersionInfo();
};

class SInputStream : virtual public SStream
{
public:
	virtual UINT Read(LPVOID lpBuf, UINT nSize, BOOL bThrowEndOfFileException = TRUE) = 0;
	virtual void ThrowBadFormatException() const = 0;

	void ReadString(int nSize, LPSTR lpsz);
	void ReadString(int nSize, LPWSTR lpsz);

	template <class T>
	SInputStream &operator >>(T &t)
	{
		t.ReadFromStream(*this);
		return *this;
	}

	SInputStream &operator >>(int &n);
	SInputStream &operator >>(short &n);
	SInputStream &operator >>(long &l);
	SInputStream &operator >>(UINT &n);
	SInputStream &operator >>(ULONG &ul);
	SInputStream &operator >>(BYTE &by);
	SInputStream &operator >>(float &f);
	SInputStream &operator >>(double &d);
	SInputStream &operator >>(long double &ld);
	SInputStream &operator >>(char &ch);
	SInputStream &operator >>(WCHAR &ch);

#ifdef _STRLIB
	BOOL ReadString(SString &str);
	void ReadString(int nSize, SString &str);
	SInputStream &operator >>(SString &str);
#endif // _STRLIB
};

class SOutputStream : virtual public SStream
{
public:
	virtual void Write(LPCVOID lpBuf, UINT nSize) = 0;
	virtual void Flush() = 0;

	void WriteString(LPCSTR lpsz);
	void WriteString(LPCWSTR lpsz);
	void WriteString(int nSize, LPCSTR lpsz);
	void WriteString(int nSize, LPCWSTR lpsz);

	template <class T>
	SOutputStream &operator <<(const T &t)
	{
		t.WriteToStream(*this);
		return *this;
	}

	SOutputStream &operator <<(int n);
	SOutputStream &operator <<(short n);
	SOutputStream &operator <<(long l);
	SOutputStream &operator <<(UINT n);
	SOutputStream &operator <<(ULONG ul);
	SOutputStream &operator <<(BYTE by);
	SOutputStream &operator <<(float f);
	SOutputStream &operator <<(double d);
	SOutputStream &operator <<(long double ld);
	SOutputStream &operator <<(char ch);
	SOutputStream &operator <<(WCHAR ch);
	SOutputStream &operator <<(LPCSTR lpsz);
	SOutputStream &operator <<(LPCWSTR lpsz);
};

class SBinaryStream : public SInputStream, public SOutputStream
{
};

class SInputTextStream : virtual public SStream
{
public:
	virtual BOOL ReadString(LPSTR lpsz, int nMax, BOOL *pbEndLine = NULL) = 0;
	virtual BOOL ReadString(LPWSTR lpsz, int nMax, BOOL *pbEndLine = NULL) = 0;
	virtual BOOL ReadChar(char *pch) = 0;
	virtual BOOL ReadChar(WCHAR *pch) = 0;

	template <class T>
	SInputTextStream &operator >>(T &t)
	{
		t.ReadFromStream(*this);
		return *this;
	}

	SInputTextStream &operator >>(int &n);
	SInputTextStream &operator >>(short &n);
	SInputTextStream &operator >>(long &l);
	SInputTextStream &operator >>(UINT &n);
	SInputTextStream &operator >>(ULONG &ul);
	SInputTextStream &operator >>(BYTE &by);
	SInputTextStream &operator >>(float &f);
	SInputTextStream &operator >>(double &d);
	SInputTextStream &operator >>(long double &ld);
	SInputTextStream &operator >>(char &ch);
	SInputTextStream &operator >>(WCHAR &ch);

#ifdef _STRLIB
	BOOL ReadString(SString &str);
	SInputTextStream &operator >>(SString &str);
#endif // _STRLIB
};

class SOutputTextStream : virtual public SStream
{
public:
	virtual void WriteString(LPCSTR lpsz) = 0;
	virtual void WriteString(LPCWSTR lpsz) = 0;
	virtual void WriteChar(char ch) = 0;
	virtual void WriteChar(WCHAR ch) = 0;
	virtual void Flush() = 0;

	template <class T>
	SOutputTextStream &operator <<(const T &t)
	{
		t.WriteToStream(*this);
		return *this;
	}

	SOutputTextStream &operator <<(int n);
	SOutputTextStream &operator <<(short n);
	SOutputTextStream &operator <<(long l);
	SOutputTextStream &operator <<(UINT n);
	SOutputTextStream &operator <<(ULONG ul);
	SOutputTextStream &operator <<(BYTE by);
	SOutputTextStream &operator <<(float f);
	SOutputTextStream &operator <<(double d);
	SOutputTextStream &operator <<(long double ld);
	SOutputTextStream &operator <<(char ch);
	SOutputTextStream &operator <<(WCHAR ch);
	SOutputTextStream &operator <<(LPCTSTR lpsz);
};

class STextStream : public SInputTextStream, public SOutputTextStream
{
};

inline SStream::SStream()
{
	m_nVersionInfo = 0;
}

inline int SStream::GetVersionInfo()
{
	return m_nVersionInfo;
}

inline SInputStream &SInputStream::operator >>(int &n)
{
	Read(&n, sizeof(n));
	return *this;
}

inline SInputStream &SInputStream::operator >>(short &n)
{
	Read(&n, sizeof(n));
	return *this;
}

inline SInputStream &SInputStream::operator >>(long &l)
{
	Read(&l, sizeof(l));
	return *this;
}

inline SInputStream &SInputStream::operator >>(UINT &n)
{
	Read(&n, sizeof(n));
	return *this;
}

inline SInputStream &SInputStream::operator >>(ULONG &ul)
{
	Read(&ul, sizeof(ul));
	return *this;
}

inline SInputStream &SInputStream::operator >>(BYTE &by)
{
	Read(&by, sizeof(by));
	return *this;
}

inline SInputStream &SInputStream::operator >>(float &f)
{
	Read(&f, sizeof(f));
	return *this;
}

inline SInputStream &SInputStream::operator >>(double &d)
{
	Read(&d, sizeof(d));
	return *this;
}

inline SInputStream &SInputStream::operator >>(long double &ld)
{
	Read(&ld, sizeof(ld));
	return *this;
}

inline SInputStream &SInputStream::operator >>(char &ch)
{
	Read(&ch, sizeof(ch));
	return *this;
}

inline SInputStream &SInputStream::operator >>(WCHAR &ch)
{
	Read(&ch, sizeof(ch));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(int n)
{
	Write(&n, sizeof(n));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(short n)
{
	Write(&n, sizeof(n));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(long l)
{
	Write(&l, sizeof(l));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(UINT n)
{
	Write(&n, sizeof(n));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(ULONG ul)
{
	Write(&ul, sizeof(ul));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(BYTE by)
{
	Write(&by, sizeof(by));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(float f)
{
	Write(&f, sizeof(f));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(double d)
{
	Write(&d, sizeof(d));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(long double ld)
{
	Write(&ld, sizeof(ld));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(char ch)
{
	Write(&ch, sizeof(ch));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(WCHAR ch)
{
	Write(&ch, sizeof(ch));
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(LPCSTR lpsz)
{
	WriteString(lpsz);
	return *this;
}

inline SOutputStream &SOutputStream::operator <<(LPCWSTR lpsz)
{
	WriteString(lpsz);
	return *this;
}

#endif // __STREAM_H__
