#ifndef __MAP_H__
#define __MAP_H__

#include "Terrain.h"

class SStoreMap;

class SMap
{
public:
	SMap()
		{ m_nWidth = m_nHeight = 0; m_ppBackMap = m_ppFrontMap = NULL; }
	virtual ~SMap();

	void Create(int nWidth, int nHeight, STerrainManager *pManager, const STerrainPattern *pPattern);
	void Delete();

// Attributes
public:
	int GetWidth() const
		{ return m_nWidth; }
	int GetHeight() const
		{ return m_nHeight; }
	const STerrain *GetTerrain(int x, int y) const;

// Operations
public:
	void MergeMap();

	void Load(LPCTSTR lpszFileName);
	void Save(LPCTSTR lpszFileName);
	void SaveForEngine(LPCTSTR lpszFileName);

	BOOL IsValidPoint(int x, int y) const
		{ return inrange(x, 0, m_nWidth) && inrange(y, 0, m_nHeight); }

// Implementation
private:
	class SUsedType
	{
	public:
		SUsedType(int nType, LPCTSTR lpszTypeName)
		{
			m_nType = nType;
			m_strTypeName = lpszTypeName;
		}

	// Attributes
	public:
		int GetTypeID() const
			{ return m_nType; }

	// Operations
		void WriteToStream(SOutputStream &out) const
			{ out.WriteString(m_strTypeName); }

		bool operator >(const SUsedType &ut) const
			{ return m_nType > ut.m_nType; }
		bool operator <(const SUsedType &ut) const
			{ return m_nType < ut.m_nType; }
		bool operator >=(const SUsedType &ut) const
			{ return m_nType >= ut.m_nType; }
		bool operator <=(const SUsedType &ut) const
			{ return m_nType <= ut.m_nType; }

		bool operator ==(int nType) const
			{ return m_nType == nType; }

	// implementation
	private:
		int m_nType;
		CString m_strTypeName;
	};

	int m_nWidth, m_nHeight;
	const STerrain **m_ppBackMap, **m_ppFrontMap;
	STerrainManager *m_pTerrainManager;

protected:
	STerrainManager *GetTerrainManager()
		{ ASSERT(m_pTerrainManager != NULL);
			return m_pTerrainManager; }

	void ClearFrontMap();

	void SetTerrain(int x, int y, const STerrain *pTerrain);
	void SetTerrainRange(int x, int y, int nWidth, int nHeight, const STerrainPattern *pPattern);
	void SetPattern(int x, int y, const STerrainPattern *pPattern);
	//void GetTerrainRange(int x, int y, SStoreMap *pMap) const;
	//void SetTerrainRange(const SStoreMap &map);
};

class SMapDrawer : public SMap
{
// Operations
public:
	BOOL DrawTerrain(int x, int y, const STerrainSet *pSet);

// Implementation
private:
	class SCornerFlag
	{
	public:
		SCornerFlag()
			{ m_bLeft = m_bRight = m_bTop = m_bBottom = FALSE; }

	// Attributes
	public:
		BOOL IsDrawLeft()
			{ return m_bLeft; }
		BOOL IsDrawRight()
			{ return m_bRight; }
		BOOL IsDrawTop()
			{ return m_bTop; }
		BOOL IsDrawBottom()
			{ return m_bBottom; }

		void SetLeftDrawFlag()
			{ m_bLeft = TRUE; }
		void SetRightDrawFlag()
			{ m_bRight = TRUE; }
		void SetTopDrawFlag()
			{ m_bTop = TRUE; }
		void SetBottomDrawFlag()
			{ m_bBottom = TRUE; }

	// Implementation
	private:
		BOOL m_bLeft, m_bRight, m_bTop, m_bBottom;
	};

	BOOL IsEqualType(int x, int y, int nType);

	BOOL AnalPatternHorz(int x, int y, const STerrainPattern **ppPattern);
	BOOL AnalPatternVert(int x, int y, const STerrainPattern **ppPattern);
	BOOL AnalPatternAll(int x, int y, const STerrainPattern **ppPattern);

	BOOL DrawNormalTop(int x, int y, int nWidth);
	BOOL DrawNormalBottom(int x, int y, int nWidth);
	BOOL DrawNormalLeft(int x, int y, int nHeight);
	BOOL DrawNormalRight(int x, int y, int nHeight);
	BOOL DrawNormalCorner(int x, int y);

	BOOL AnalCliff(int nCliff, int x, int y, BOOL bUp);
	const STerrainPattern *AnalCliffTop(int nCliff, int x, int y, BOOL bDrawLeftRight);
	const STerrainPattern *AnalCliffBottom(int nCliff, int x, int y, BOOL bDrawLeftRight);

	BOOL DrawSideHorz(int x, int y, int nWidth);
	BOOL DrawSideVert(int x, int y, int nHeight);
	BOOL DrawCorner(int x, int y);

	BOOL DrawCliffTop(int nCliff, int x, int y, int nWidth, BOOL bDrawLeftRight);
	BOOL DrawCliffBottom(int nCliff, int x, int y, int nWidth, BOOL bDrawLeftRight);

	BOOL DrawNormalTerrain(int x, int y, const STerrainSet *pSet);
	BOOL DrawCliffTerrain(int x, int y, const STerrainSet *pSet);
};

class SStoreMap
{
public:
	SStoreMap(int nWidth, int nHeight);
	virtual ~SStoreMap();

// Attributes
public:
	int GetX() const
		{ return m_x; }
	int GetY() const
		{ return m_y; }
	void SetX(int x)
		{ m_x = x; }
	void SetY(int y)
		{ m_y = y; }

	int GetWidth() const
		{ return m_nWidth; }
	int GetHeight() const
		{ return m_nHeight; }

	const STerrain *GetTerrain(int x, int y) const
		{ ASSERT(IsValidPoint(x, y));
			return m_ppMap[x + y * m_nWidth]; }
	void SetTerrain(int x, int y, const STerrain *pTerrain)
		{ ASSERT(IsValidPoint(x, y));
			m_ppMap[x + y * m_nWidth] = pTerrain; }

	BOOL IsValidPoint(int x, int y) const
		{ return inrange(x, 0, m_nWidth) && inrange(y, 0, m_nHeight); }

// Implementation
private:
	int m_x, m_y, m_nWidth, m_nHeight;
	const STerrain **m_ppMap;
};

#endif // __MAP_H__
