// MapEditDoc.h : interface of the CMapEditDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAPEDITDOC_H__10B3C516_4F54_429B_93C4_10AF3AB35972__INCLUDED_)
#define AFX_MAPEDITDOC_H__10B3C516_4F54_429B_93C4_10AF3AB35972__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Map.h"
#include "Wall.h"

class CTerrainFloatBar;
class CWallAttributesFloatBar;

class CMapEditDoc : public CDocument
{
protected: // create from serialization only
	CMapEditDoc();
	DECLARE_DYNCREATE(CMapEditDoc)

// Attributes
public:
	UINT GetMode()
		{ return m_nMode; }

	const STerrainManager *GetTerrainManager()
		{ return &m_mngTerrain; }

	int GetMapWidth()
		{ return m_map.GetWidth(); }
	int GetMapHeight()
		{ return m_map.GetHeight(); }
	const STerrain *GetTerrain(int x, int y)
		{ return m_map.GetTerrain(x, y); }

	int GetWallCount()
		{ return m_listWall.GetCount(); }
	SWallLine *GetFirstWall()
		{ return (SWallLine *) m_listWall.GetHead(); }
	SWallLine *GetLastWall()
		{ return (SWallLine *) m_listWall.GetTail(); }
	SWallLine *GetPrevWall(SWallLine *pLine);
	SWallLine *GetNextWall(SWallLine *pLine);

	SWallLine *GetSelWall()
		{ return m_pSelWallLine; }
	SWallPoint *GetSelWallPoint()
		{ return m_pSelWallPoint; }
	SWallAttributes *GetWallAttributes()
		{ return &m_wallattrib; }

// Operations
public:
	BOOL DrawTerrain(int x, int y);
	void MergeMap();

	BOOL AddWallPoint(int x, int y);
	BOOL FindWallPoint(CPoint point);
	BOOL FindWallLine(CPoint point);

	BOOL SelectWallPoint(CPoint point);
	void UnselectWallPoint()
		{ m_pSelWallLine = NULL; m_pSelWallPoint = NULL; }

	BOOL SetWallAttributes(CPoint point, BOOL bAllPoint);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapEditDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMapEditDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
	// Ÿ or  ׸ 
	UINT m_nMode;

	STerrainManager m_mngTerrain;
	SMapDrawer m_map;

	SList<SWallLine> m_listWall;
	SWallLine *m_pSelWallLine;
	SWallPoint *m_pSelWallPoint;
	SWallAttributes m_wallattrib;

	CTerrainFloatBar *GetTerrainFloatBar();
	CWallAttributesFloatBar *GetWallAttributesFloatBar();

// Generated message map functions
protected:
	//{{AFX_MSG(CMapEditDoc)
	afx_msg void OnUpdateToolTileMode(CCmdUI* pCmdUI);
	afx_msg void OnToolTileMode();
	afx_msg void OnUpdateToolWallMode(CCmdUI* pCmdUI);
	afx_msg void OnToolWallMode();
	afx_msg void OnUpdateToolDeleteWall(CCmdUI* pCmdUI);
	afx_msg void OnToolDeleteWall();
	afx_msg void OnUpdateToolDeleteWallPoint(CCmdUI* pCmdUI);
	afx_msg void OnToolDeleteWallPoint();
	afx_msg void OnFileSaveTile();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAPEDITDOC_H__10B3C516_4F54_429B_93C4_10AF3AB35972__INCLUDED_)
