// MapEditView.cpp : implementation of the CMapEditView class
//

#include "stdafx.h"
#include "MapEdit.h"

#include "MapEditDoc.h"
#include "MapEditView.h"

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapEditView

IMPLEMENT_DYNCREATE(CMapEditView, CScrollView)

BEGIN_MESSAGE_MAP(CMapEditView, CScrollView)
	//{{AFX_MSG_MAP(CMapEditView)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapEditView construction/destruction

CMapEditView::CMapEditView()
{
}

CMapEditView::~CMapEditView()
{
}

BOOL CMapEditView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMapEditView drawing

void CMapEditView::OnDraw(CDC* pDC)
{
	CMapEditDoc *pDoc = GetDocument();
	switch (pDoc->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		m_bmpBack.DrawBitmap(*pDC, GetScrollPos(SB_HORZ), GetScrollPos(SB_VERT));
		break;
	case ID_TOOL_WALL_MODE:
		m_bmpWall.DrawBitmap(*pDC, GetScrollPos(SB_HORZ), GetScrollPos(SB_VERT));
		break;
	default:
		ASSERT(FALSE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMapEditView diagnostics

#ifdef _DEBUG
void CMapEditView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CMapEditView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CMapEditDoc* CMapEditView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMapEditDoc)));
	return (CMapEditDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMapEditView message handlers

int CMapEditView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_hCrossCursor = AfxGetApp()->LoadStandardCursor(IDC_CROSS);
	m_hMoveCursor = AfxGetApp()->LoadStandardCursor(IDC_SIZEALL);
	m_hLineCursor = AfxGetApp()->LoadStandardCursor(MAKEINTRESOURCE(32649));
	return 0;
}

BOOL CMapEditView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void CMapEditView::OnSize(UINT nType, int cx, int cy) 
{
	CScrollView::OnSize(nType, cx, cy);

	if (m_bmpBack.GetHeader() != NULL)
		m_bmpBack.Delete();
	CRect rect;
	GetClientRect(&rect);
	m_bmpBack.Create(rect.Width(), rect.Height(), 24);
	UpdateBack();
	UpdateWall();
}

void CMapEditView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileLButtonDown(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallLButtonDown(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

void CMapEditView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileLButtonUp(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallLButtonUp(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

void CMapEditView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileLButtonDblClk(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallLButtonDblClk(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

void CMapEditView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileRButtonDown(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallRButtonDown(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

void CMapEditView::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileRButtonDown(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallRButtonDown(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

void CMapEditView::OnMouseMove(UINT nFlags, CPoint point) 
{
	switch (GetDocument()->GetMode())
	{
	case ID_TOOL_TILE_MODE:
		TileMouseMove(nFlags, point);
		break;
	case ID_TOOL_WALL_MODE:
		WallMouseMove(nFlags, point);
		break;
	default:
		ASSERT(FALSE);
	}
}

BOOL CMapEditView::DPtoTP(CPoint point, int *px, int *py)
{
	ASSERT(IsValidAddress(px));
	ASSERT(IsValidAddress(py));

	*px = point.x + GetScrollPos(SB_HORZ);
	*py = point.y + GetScrollPos(SB_VERT);
	if (*px < 0)
		return FALSE;
	if (*py < 0)
		return FALSE;
	*px /= STerrain::GetWidth();
	*py /= STerrain::GetHeight();

	CMapEditDoc *pDoc = GetDocument();
	if (*px >= pDoc->GetMapWidth() || *py >= pDoc->GetMapHeight())
		return FALSE;
	return TRUE;
}

BOOL CMapEditView::IsValidPoint(int x, int y)
{
	CMapEditDoc *pDoc = GetDocument();
	if (!inrange(x, 0, pDoc->GetMapWidth()) || !inrange(y, 0, pDoc->GetMapHeight()))
		return FALSE;
	return TRUE;
}

//void CMapEditView::SetTerrain(int x, int y, const STerrain *pTerrain, BOOL bUpdate /*= TRUE*/)
/*{
	CMapEditDoc *pDoc = GetDocument();
	if (IsValidPoint(x, y))
	{
		pDoc->SetTerrain(x, y, pTerrain);
		if (bUpdate)
		{
			UpdateBack();
			UpdateWall();
			Invalidate();
		}

		m_xLast = x;
		m_yLast = y;
		m_nLastStartPoint = m_nStartPoint;
		m_nLastEndPoint = m_nEndPoint;
	}
}*/

//void CMapEditView::SetSelectedTerrain(int x, int y, BOOL bUpdate /*= TRUE*/)
/*{
	CMapEditDoc *pDoc = GetDocument();
	const STerrainType *pType = pDoc->GetTerrainManager()->GetType(0);
	const STerrainPattern *pPattern = pType->GetPattern(pDoc->m_nSelTerrain);
	//SetTerrain(x, y, pPattern->GetRandomTerrain(), bUpdate);
}*/

/*int CMapEditView::GetPattern(int x, int y)
{
	STerrain::ID id;
	const STerrain *pTerrain = GetDocument()->GetTerrain(x, y);
	pTerrain->GetID(&id);
	return id.nPattern;
}*/

void CMapEditView::OnInitialUpdate() 
{
	CScrollView::OnInitialUpdate();

	CMapEditDoc *pDoc = GetDocument();
	SetScrollSizes(MM_TEXT, CSize(pDoc->GetMapWidth() * 96, pDoc->GetMapHeight() * 64));

	m_bLastDrawResult = FALSE;
	m_xLast = m_yLast = -1;

	UpdateBack();
	UpdateWall();
}

/*void CMapEditView::StartDrawingPattern(int x, int y)
{
	m_xDrawing = x / TR_WIDTH;
	m_yDrawing = y / TR_HEIGHT;

	m_nStartPoint = m_nEndPoint = PointToCorner(CPoint(x, y));
}*/

/*void CMapEditView::EndDrawingPattern()
{
	if (!IsValidPoint(m_xDrawing, m_yDrawing))
		return;
	if (m_nStartPoint != m_nEndPoint)
	{
		CMapEditDoc *pDoc = GetDocument();
		const STerrain *pTerrain = pDoc->FindPattern(pDoc->m_nSelTerrain, m_nStartPoint, m_nEndPoint);
		if (pTerrain == NULL)
			MessageBeep(MB_ICONWARNING);
	}
}*/

/*int CMapEditView::PointToCorner(CPoint point)
{
	point.x %= TR_WIDTH;
	point.y %= TR_HEIGHT;
	point.x /= TR_WIDTH / 3;
	point.y /= TR_HEIGHT / 3;
	switch (point.x)
	{
	case 0:
		switch (point.y)
		{
		case 0:
			return PP_LEFT_TOP;
		case 1:
			return PP_LEFT_MIDDLE;
		default:
			return PP_LEFT_BOTTOM;
		}
	case 1:
		switch (point.y)
		{
		case 0:
			return PP_MIDDLE_TOP;
		case 1:
			return PP_NONE;
		default:
			return PP_MIDDLE_BOTTOM;
		}
	default:
		switch (point.y)
		{
		case 0:
			return PP_RIGHT_TOP;
		case 1:
			return PP_RIGHT_MIDDLE;
		default:
			return PP_RIGHT_BOTTOM;
		}
	}
}*/

void CMapEditView::UpdateBack()
{
	m_bmpBack.Fill(GetSysColor(COLOR_WINDOW));

	CMapEditDoc* pDoc = GetDocument();
	for (int y = 0;y < pDoc->GetMapHeight();y++)
		for (int x = 0;x < pDoc->GetMapWidth();x++)
		{
			const STerrain *pTerrain = pDoc->GetTerrain(x, y);
			m_bmpBack.Blt(x * STerrain::GetWidth() - GetScrollPos(SB_HORZ),
				y * STerrain::GetHeight() - GetScrollPos(SB_VERT), *pTerrain);
		}

	CClientDC dc(this);
	CDC dcMem;
	dcMem.CreateCompatibleDC(&dc);
	dcMem.SelectObject(m_bmpBack);
	dcMem.SetViewportOrg(-GetScrollPos(SB_HORZ), -GetScrollPos(SB_VERT));

	for (int x = 0;x < pDoc->GetMapWidth();x++)
	{
		dcMem.MoveTo(x * STerrain::GetWidth(), 0);
		dcMem.LineTo(x * STerrain::GetWidth(), pDoc->GetMapHeight() * STerrain::GetHeight());
	}
	for (y = 0;y < pDoc->GetMapHeight();y++)
	{
		dcMem.MoveTo(0, y * STerrain::GetHeight());
		dcMem.LineTo(pDoc->GetMapWidth() * STerrain::GetWidth(), y * STerrain::GetHeight());
	}
}

void CMapEditView::UpdateWall()
{
	m_bmpWall = m_bmpBack;

	CClientDC dc(this);
	CDC dcMem;
	dcMem.CreateCompatibleDC(&dc);
	dcMem.SelectObject(m_bmpWall);
	dcMem.SetViewportOrg(-GetScrollPos(SB_HORZ), -GetScrollPos(SB_VERT));

	CBrush brNormal(RGB(255, 255, 255)), brSelected(RGB(0, 0, 255));
	CPen penWhite(PS_SOLID, 1, RGB(255, 255, 255));
	CPen penRed(PS_SOLID, 1, RGB(255, 0, 0));
	CPen penGreen(PS_SOLID, 1, RGB(0, 255, 0));
	CPen penBlue(PS_SOLID, 1, RGB(0, 0, 255));

	CMapEditDoc* pDoc = GetDocument();
	for (SWallLine *pLine = pDoc->GetFirstWall();pLine;pLine = pDoc->GetNextWall(pLine))
	{
		SWallPoint *pPoint = pLine->GetFirstPoint();
		for (pPoint = pLine->GetNextPoint(pPoint);pPoint;pPoint = pLine->GetNextPoint(pPoint))
		{
			SWallPoint *pStartPoint = pLine->GetPrevPoint(pPoint);
			SWallPoint *pEndPoint = pPoint;

			int nCount = 0;
			if (pPoint->m_bMove)
				nCount++;
			if (pPoint->m_bThrough)
				nCount++;
			if (pPoint->m_bView)
				nCount++;
			if (nCount == 0)
				DrawWallLine(&dcMem, CPoint(pStartPoint->GetX(), pStartPoint->GetY()),
					CPoint(pEndPoint->GetX(), pEndPoint->GetY()), 0, penWhite);
			else
			{
				double dDistance = (nCount - 1) * 3 / -2;
				if (pPoint->m_bMove)
				{
					DrawWallLine(&dcMem, CPoint(pStartPoint->GetX(), pStartPoint->GetY()),
						CPoint(pEndPoint->GetX(), pEndPoint->GetY()), dDistance, penRed);
					dDistance += 3;
				}
				if (pPoint->m_bThrough)
				{
					DrawWallLine(&dcMem, CPoint(pStartPoint->GetX(), pStartPoint->GetY()),
						CPoint(pEndPoint->GetX(), pEndPoint->GetY()), dDistance, penGreen);
					dDistance += 3;
				}
				if (pPoint->m_bView)
				{
					DrawWallLine(&dcMem, CPoint(pStartPoint->GetX(), pStartPoint->GetY()),
						CPoint(pEndPoint->GetX(), pEndPoint->GetY()), dDistance, penBlue);
					dDistance += 3;
				}
			}
		}

		for (pPoint = pLine->GetFirstPoint();pPoint;pPoint = pLine->GetNextPoint(pPoint))
		{
			CBrush *pOldBrush;
			if (pPoint == pDoc->GetSelWallPoint())
				pOldBrush = dcMem.SelectObject(&brSelected);
			else
				pOldBrush = dcMem.SelectObject(&brNormal);

			CRect rect;
			pPoint->GetRect(&rect);
			dcMem.Rectangle(&rect);

			dcMem.SelectObject(pOldBrush);
		}
	}
}

BOOL CMapEditView::OnScrollBy(CSize sizeScroll, BOOL bDoScroll) 
{
	BOOL bResult = CScrollView::OnScrollBy(sizeScroll, bDoScroll);
	UpdateBack();
	UpdateWall();
	return bResult;
}

/*void CMapEditView::Fill(int x, int y)
{
	if (!IsValidPoint(x, y))
		return;
	int nPattern = GetPattern(x, y);
	if (nPattern != GetDocument()->m_nSelTerrain)
		Fill(x, y, 0, 0, 0, nPattern);

	UpdateBack();
	UpdateWall();
	Invalidate();
}

int CMapEditView::Fill(int x, int y, int nLeft, int nRight, int nFlag, int nBackPattern)
{
	CMapEditDoc *pDoc = GetDocument();
	int nCurBack = GetPattern(x, y);
	if (nCurBack == pDoc->m_nSelTerrain || nCurBack != nBackPattern)
		return x;
	SetSelectedTerrain(x, y, FALSE);

	int nLeftScan = x - 1;
	while (nLeftScan >= 0)
	{
		nCurBack = GetPattern(nLeftScan, y);
		if (nCurBack == pDoc->m_nSelTerrain || nCurBack != nBackPattern)
			break;
		SetSelectedTerrain(nLeftScan--, y, FALSE);
	}
	nLeftScan++;

	int nRightScan = x + 1;
	while (nRightScan < pDoc->GetMapWidth())
	{
		nCurBack = GetPattern(nRightScan, y);
		if (nCurBack == pDoc->m_nSelTerrain || nCurBack != nBackPattern)
			break;
		SetSelectedTerrain(nRightScan++, y, FALSE);
	}
	nRightScan--;

	if (y > 0)
	{
		if (nFlag == 1)
		{
			for (x = nLeftScan;x <= nLeft;x++)
				x = Fill(x, y - 1, nLeftScan, nRightScan, 2, nBackPattern);
			for (x = nRight + 1;x <= nRightScan;x++)
				x = Fill(x, y - 1, nLeftScan, nRightScan, 2, nBackPattern);
		}
		else
			for (x = nLeftScan;x <= nRightScan;x++)
				x = Fill(x, y - 1, nLeftScan, nRightScan, 2, nBackPattern);
	}
	if (y < pDoc->GetMapHeight() - 1)
	{
		if (nFlag == 2)
		{
			for (x = nLeftScan;x <= nLeft;x++)
				x = Fill(x, y + 1, nLeftScan, nRightScan, 1, nBackPattern);
			for (x = nRight + 1;x <= nRightScan;x++)
				x = Fill(x, y + 1, nLeftScan, nRightScan, 1, nBackPattern);
		}
		else
			for (x = nLeftScan;x <= nRightScan;x++)
				x = Fill(x, y + 1, nLeftScan, nRightScan, 1, nBackPattern);
	}
	return nRightScan;
}*/

void CMapEditView::DrawWallLine(CDC *pDC, CPoint ptStart, CPoint ptEnd, double dDistance, CPen &pen)
{
	// 90 ȸŲ.
	int cx = ptEnd.y - ptStart.y;
	int cy = -(ptEnd.x - ptStart.x);

	// ϴ Ÿ Ѵ.
	double d = sqrt(cx * cx + cy * cy);
	cx = (int) (cx * dDistance / d);
	cy = (int) (cy * dDistance / d);

	CPen *pOldPen = pDC->SelectObject(&pen);
	pDC->MoveTo(ptStart.x + cx, ptStart.y + cy);
	pDC->LineTo(ptEnd.x + cx, ptEnd.y + cy);
	pDC->SelectObject(pOldPen);
}

void CMapEditView::TileLButtonDown(UINT nFlags, CPoint point)
{
	SetCapture();

	if (m_bLastDrawResult)
		GetDocument()->MergeMap();
	else
		MessageBeep(MB_ICONWARNING);
}

void CMapEditView::TileLButtonUp(UINT nFlags, CPoint point)
{
	if (GetCapture() == this)
		ReleaseCapture();
}

void CMapEditView::TileLButtonDblClk(UINT nFlags, CPoint point)
{
	/*int x = point.x + GetScrollPos(SB_HORZ);
	int y = point.y + GetScrollPos(SB_VERT);
	x /= TR_WIDTH;
	y /= TR_HEIGHT;
	Fill(x, y);*/
}

void CMapEditView::TileRButtonDown(UINT nFlags, CPoint point)
{
	/*CMapEditDoc *pDoc = GetDocument();
	const STerrain *pTerrain = pDoc->FindPattern(pDoc->m_nSelTerrain, m_nLastEndPoint, m_nLastStartPoint);
	if (pTerrain != NULL)
	{
		m_nStartPoint = m_nLastEndPoint;
		m_nEndPoint = m_nLastStartPoint;
		SetTerrain(m_xLast, m_yLast, pTerrain);
	}
	else
		MessageBeep(MB_ICONWARNING);*/
}

void CMapEditView::TileMouseMove(UINT nFlags, CPoint point)
{
	int x, y;
	if (DPtoTP(point, &x, &y) && (m_xLast != x || m_yLast != y))
	{
		CMapEditDoc *pDoc = GetDocument();
		m_bLastDrawResult = pDoc->DrawTerrain(x, y);
		if (m_bLastDrawResult && GetCapture() == this)
			pDoc->MergeMap();
		m_xLast = x;
		m_yLast = y;

		UpdateBack();
		Invalidate();
		UpdateWindow();
	}
}

void CMapEditView::WallLButtonDown(UINT nFlags, CPoint point)
{
	CMapEditDoc *pDoc = GetDocument();
	if (GetKeyState(VK_CONTROL) < 0)
	{
		if (!pDoc->SetWallAttributes(point, FALSE))
		{
			MessageBeep(MB_ICONWARNING);
			return;
		}
	}
	else
	{
		if (!pDoc->SelectWallPoint(point))
		{
			if (!pDoc->AddWallPoint(point.x, point.y))
			{
				MessageBeep(MB_ICONWARNING);
				return;
			}
			SetCursor(m_hMoveCursor);
		}
		SetCapture();
	}
	UpdateWall();
	Invalidate();
}

void CMapEditView::WallLButtonUp(UINT nFlags, CPoint point)
{
	if (GetCapture() == this)
		ReleaseCapture();
}

void CMapEditView::WallLButtonDblClk(UINT nFlags, CPoint point)
{
	if (GetKeyState(VK_CONTROL) < 0)
	{
		CMapEditDoc *pDoc = GetDocument();
		if (!pDoc->SetWallAttributes(point, TRUE))
		{
			MessageBeep(MB_ICONWARNING);
			return;
		}
		UpdateWall();
		Invalidate();
	}
	else
		WallLButtonDown(nFlags, point);
}

void CMapEditView::WallRButtonDown(UINT nFlags, CPoint point)
{
	GetDocument()->UnselectWallPoint();
	UpdateWall();
	Invalidate();
}

void CMapEditView::WallMouseMove(UINT nFlags, CPoint point)
{
	if (GetCapture() == this)
	{
		CMapEditDoc *pDoc = GetDocument();
		SWallPoint *pPoint = pDoc->GetSelWallPoint();
		ASSERT(pPoint != NULL);

		pPoint->SetPoint(point.x, point.y);
		UpdateWall();
		Invalidate();
	}
}

BOOL CMapEditView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	CMapEditDoc *pDoc = GetDocument();
	if (pDoc->GetMode() == ID_TOOL_WALL_MODE)
	{
		CPoint point;
		GetCursorPos(&point);
		ScreenToClient(&point);

		CMapEditDoc *pDoc = GetDocument();
		if (pDoc->FindWallPoint(point))
		{
			SetCursor(m_hMoveCursor);
			return TRUE;
		}
		if (pDoc->FindWallLine(point))
		{
			SetCursor(m_hLineCursor);
			return TRUE;
		}
		if (pDoc->GetSelWall())
		{
			SetCursor(m_hCrossCursor);
			return TRUE;
		}
	}
	return CScrollView::OnSetCursor(pWnd, nHitTest, message);
}

void CMapEditView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	UpdateBack();
	UpdateWall();
	Invalidate();
}
