// TerrainFloatBar.cpp : implementation file
//

#include "stdafx.h"
#include "MapEdit.h"
#include "TerrainFloatBar.h"

#include "MapEditDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_COMBO 1000

/////////////////////////////////////////////////////////////////////////////
// CTerrainFloatBar

CTerrainFloatBar::CTerrainFloatBar()
{
}

CTerrainFloatBar::~CTerrainFloatBar()
{
}


BEGIN_MESSAGE_MAP(CTerrainFloatBar, CMiniFrameWnd)
	//{{AFX_MSG_MAP(CTerrainFloatBar)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTerrainFloatBar message handlers

BOOL CTerrainFloatBar::Create(CPoint point, CWnd *pParentWnd, UINT nID)
{
	static CString strClassName;
	if (strClassName.IsEmpty())
		strClassName = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
			AfxGetApp()->LoadStandardCursor(IDC_ARROW),
			(HBRUSH) (COLOR_3DFACE + 1));

	CRect rect(point.x, point.y, 0, 0);
	if (!CreateEx(WS_EX_TOOLWINDOW, strClassName, _T("ͷ"), WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU | MFS_SYNCACTIVE, rect, pParentWnd, 0))
		return FALSE;

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		pSysMenu->RemoveMenu(SC_RESTORE, MF_BYCOMMAND);
		pSysMenu->RemoveMenu(SC_MINIMIZE, MF_BYCOMMAND);
		pSysMenu->RemoveMenu(SC_MAXIMIZE, MF_BYCOMMAND);
	}
	return TRUE;
}

int CTerrainFloatBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMiniFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_ctlCombo.Create(WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, CRect(0, 0, 0, 0), this, IDC_COMBO);

	m_font.CreatePointFont(90, _T(""));
	m_ctlCombo.SetFont(&m_font);

	CRect rect;
	m_ctlCombo.GetWindowRect(&rect);
	m_nComboHeight = rect.Height() + 1;
	return 0;
}

void CTerrainFloatBar::PostNcDestroy() 
{
}

void CTerrainFloatBar::OnPaint() 
{
	CPaintDC dc(this);

	for (int i = 0;i < m_arrTerrain.GetSize();i++)
		DrawButton(&dc, i);
}

void CTerrainFloatBar::OnLButtonDown(UINT nFlags, CPoint point) 
{
	for (int i = 0;i < m_arrTerrain.GetSize();i++)
	{
		CRect rect;
		GetRect(i, &rect);
		if (rect.PtInRect(point))
		{
			SelectTerrain(i);
			Invalidate(FALSE);
		}
	}
}

const STerrainSet *CTerrainFloatBar::GetSelType()
{
	DWORD dw = m_ctlCombo.GetItemData(m_ctlCombo.GetCurSel());
	if (dw == 0)
		return m_arrTerrain[m_nSelIndex]->GetPattern(0)->GetRandomSet(1, 1);

	const STerrainType *pType = m_arrTerrain[m_nSelIndex];
	int nWidth = dw >> 8;
	int nHeight = dw & 0xff;
	if (pType->GetClass() == STerrainType::NORMAL_SOLID)
		return pType->GetPattern(1)->GetRandomSet(nWidth, nHeight);
	else
		return pType->GetPattern(0)->GetRandomSet(nWidth, nHeight);
}

CMapEditDoc *CTerrainFloatBar::GetDocument()
{
	ASSERT(AfxGetMainWnd() != NULL);
	return (CMapEditDoc *) ((CFrameWnd *) AfxGetMainWnd())->GetActiveDocument();
}

void CTerrainFloatBar::GetRect(int nIndex, CRect *pRect)
{
	int x = nIndex % GetButtonsPerLine(), y = nIndex / GetButtonsPerLine();
	int nWidth = STerrain::GetWidth() / 2 + 8;
	int nHeight = STerrain::GetHeight() / 2 + 8;
	pRect->top = m_nComboHeight + y * GetButtonHeight();
	pRect->bottom = pRect->top + GetButtonHeight();
	pRect->left = x * GetButtonWidth();
	pRect->right = pRect->left + GetButtonWidth();
}

void CTerrainFloatBar::DrawButton(CDC *pDC, int nIndex)
{
	CRect rect;
	GetRect(nIndex, &rect);
	CMapEditDoc *pDoc = GetDocument();
	if (nIndex == m_nSelIndex)
		pDC->DrawEdge(&rect, EDGE_SUNKEN, BF_RECT);
	else
		pDC->DrawEdge(&rect, EDGE_RAISED, BF_RECT);

	const STerrain *pTerrain = m_arrTerrain[nIndex]->GetFirstTerrain();
	rect.DeflateRect(4, 4, 4, 4);
	pTerrain->StretchBitmap(*pDC, rect.left, rect.top, rect.Width(), rect.Height());
}

void CTerrainFloatBar::SelectTerrain(int nIndex)
{
	m_nSelIndex = nIndex;

	const STerrainType *pType = m_arrTerrain[m_nSelIndex];
	const STerrainSetKind *pSetKind = pType->GetSetKind();
	m_ctlCombo.ResetContent();
	if (pType->GetClass() == STerrainType::NORMAL_SOLID)
	{
		m_ctlCombo.AddString("⺻");
		m_ctlCombo.SetItemData(0, 0);
	}
	for (int i = 0;i < pSetKind->GetKindCount();i++)
	{
		int nWidth, nHeight;
		pSetKind->GetKind(i, &nWidth, &nHeight);

		CString str;
		str.Format(_T("%dx%d"), nWidth, nHeight);
		m_ctlCombo.AddString(str);
		m_ctlCombo.SetItemData(m_ctlCombo.GetCount() - 1, (nWidth << 8) | nHeight);
	}
	m_ctlCombo.SetCurSel(0);
}

void CTerrainFloatBar::Update(CMapEditDoc *pDoc)
{
	const STerrainManager *pManager = pDoc->GetTerrainManager();
	for (int nType = 0;nType < pManager->GetTypeCount();nType++)
	{
		const STerrainType *pType = pManager->GetType(nType);
		if (pType->IsSolidClass())
			m_arrTerrain.Add(pType);
	}

	int nHeight = m_arrTerrain.GetSize() / GetButtonsPerLine();
	if (m_arrTerrain.GetSize() % GetButtonsPerLine() > 0)
		nHeight++;
	CRect rect(0, 0, GetButtonWidth() * GetButtonsPerLine(), GetButtonHeight() * nHeight + m_nComboHeight);
	CalcWindowRect(&rect);
	SetWindowPos(NULL, 0, 0, rect.Width(), rect.Height(), SWP_NOZORDER | SWP_NOMOVE);

	rect.SetRect(0, 0, GetButtonWidth() * GetButtonsPerLine(), 128);
	m_ctlCombo.MoveWindow(&rect);

	SelectTerrain(0);
}
