#if !defined(AFX_TERRAINFLOATBAR_H__1B70C0CC_139E_4824_8059_3373CECAC256__INCLUDED_)
#define AFX_TERRAINFLOATBAR_H__1B70C0CC_139E_4824_8059_3373CECAC256__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TerrainFloatBar.h : header file
//

#include "Terrain.h"

class CMapEditDoc;

/////////////////////////////////////////////////////////////////////////////
// CTerrainFloatBar window

class CTerrainFloatBar : public CMiniFrameWnd
{
// Construction
public:
	CTerrainFloatBar();
	virtual BOOL Create(CPoint point, CWnd *pParentWnd, UINT nID);

// Attributes
public:
	const STerrainSet *GetSelType();

// Operations
public:
	void Update(CMapEditDoc *pDoc);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTerrainFloatBar)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTerrainFloatBar();

private:
	static int GetButtonWidth()
		{ return STerrain::GetWidth() / 2 + 8; }
	static int GetButtonHeight()
		{ return STerrain::GetHeight() / 2 + 8; }
	static int GetButtonsPerLine()
		{ return 2; }

	CMapEditDoc *GetDocument();

	SArray<const STerrainType *> m_arrTerrain;
	int m_nSelIndex;

	void GetRect(int nIndex, CRect *pRect);
	void DrawButton(CDC *pDC, int nIndex);

	void SelectTerrain(int nIndex);

	CComboBox m_ctlCombo;
	CFont m_font;
	int m_nComboHeight;

	// Generated message map functions
protected:
	//{{AFX_MSG(CTerrainFloatBar)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TERRAINFLOATBAR_H__1B70C0CC_139E_4824_8059_3373CECAC256__INCLUDED_)
