     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// costume_storage.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "animation_state.h"

///////////////////////////////////////////////////////////////////////////////
// cAnimation_State
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_State :: Save( cFile& file)
{
	assert( file.Status() == 0);

	file.Write( &m_AnimState, sizeof( ANIMATION_STATE));
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_State :: Load( cFile& file)
{
	assert( file.Status() == 0);

	file.Read( &m_AnimState, sizeof( ANIMATION_STATE));
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// cCostume_State
///////////////////////////////////////////////////////////////////////////////
cCostume_State :: cCostume_State()
{
	for( int i = 0; i < CT_NUM; i++)
	{
		m_pCostumes[ i] = NULL;
	}
}
///////////////////////////////////////////////////////////////////////////////
void cCostume_State :: SetCostume( int iType, cGraphic_Costume* pCostume) 
{
	m_pCostumes[ iType] = pCostume;
}
///////////////////////////////////////////////////////////////////////////////
cGraphic_Costume* cCostume_State :: GetCostume( int iType)
{
	return m_pCostumes[ iType];
}
///////////////////////////////////////////////////////////////////////////////
bool cCostume_State :: Save( cFile& file)
{
	assert( file.Status() == 0);

	cAnimation_State :: Save( file);
	file.Write( &m_CostumeState, sizeof( COSTUME_STATE));

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cCostume_State :: Load( cFile& file)
{
	assert( file.Status() == 0);

	cAnimation_State :: Load( file);
	file.Read( &m_CostumeState, sizeof( COSTUME_STATE));

	return true;
}
