     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// asm.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "asm.h"
#include "screen.h"

// extern cScreenPtr g_pScreen;
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memset16Bit ( U16ptr dst, U16 fill, int num)
{
    if (num <= 0) return;
    if (num&1) *dst++ = fill; // one too many for stosd
    if (num <2) return;

 _asm
 {
    mov    ax, fill   // store value
    mov   ecx, num    // how many copies
    shl   eax, 16     // shift it into high order
    mov   edi, dst    // to where
    add    ax, fill   // do two pixels at a time
    shr   ecx, 1      // divide by 2

    rep   stosd
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16Bit ( U16ptr dest, U16ptr source, int num, int h)
{
	if (num <= 0) return;

	int test1 = (int) dest;
	if (test1&2)// to handle a misalligned destination address
	{
		*dest++ = *source++;
		if (num < 2) return;
		num--;
		if (!(num&1))
		{
			_asm
			{
				mov   ecx, num    // how many copies
				mov   edi, dest   // to where
				shr   ecx, 1
				mov   esi, source // set source
				rep   movsd
			}				
		}
		else
		{
			_asm
			{
				mov   ecx, num    // how many copies
				mov   edi, dest   // to where
				shr   ecx, 1
				mov   esi, source // set source

				rep   movsd
			}
			*(dest+num-1) = *(source+num-1);
		}
		return;
	}

	if (num&1) *dest++ = *source++;	// 1 too many for movsd
    if (num < 2) return;

	_asm
	{
		mov   ecx, num    // how many copies
		mov   edi, dest   // to where
		shr   ecx, 1
		mov   esi, source // set source


		rep   movsd
	}
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitLightened ( U16ptr dest, U16ptr source, int num, int h) 
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source

dark:
    
	mov   edx, [edi]
	add   edi, 2
	
	mov   eax, [esi]
	add   esi, 2

	or    eax, 0x38e7  // 0011100011100111
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  dark
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitDarkened ( U16ptr dest, U16ptr source, int num, int h) 
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source

dark:
    
	mov   edx, [edi]
	add   edi, 2
	
	mov   eax, [esi]
	add   esi, 2

	and   eax, 0x38e7  // 0011100011100111
    dec	  ecx			
	mov   [edi-2], eax	
	jg	  dark
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitBlue( U16ptr dest, U16ptr source, int num, int h) 
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source

dark:
    
	mov   edx, [edi]
	add   edi, 2
	
	mov   eax, [esi]
	add   esi, 2

	or    eax, 0x1f     // mask off low bits 11111		
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  dark
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitGreen( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source

dark:
    
	mov   edx, [edi]
	add   edi, 2
	
	mov   eax, [esi]
	add   esi, 2

	or    eax, 0x200    // mask off low bits 0000001000000000		
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  dark
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitRed( U16ptr dest, U16ptr source, int num, int h) 
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source

dark:
    
	mov   edx, [edi]
	add   edi, 2
	
	mov   eax, [esi]
	add   esi, 2

	or    eax, 0x7800   // mask off low bits 1111100000000000		
    dec	  ecx			// counter stores flag

	mov   [edi-2], eax	// to account for increment earlier	/ flag not modified
	jg	  dark
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitSlopedShadow ( U16ptr dest, U16ptr source, int num, int h) 
{
    int w = g_pScreen->GetCanvas().size.iRealWidth / 2;
	if( num <= 0) return;
    if( h & 1) return;         // ׸ ũ⸦ ̱ 
    
    dest += (h * w) + h / 2;  //  񽺵 ´.
 
 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
	mov   eax, 0xf79e   // 0xf79e
	nop

repeat1:
    
	mov   edx, [edi]
	add   edi, 2
    
    and   edx, 0xf79e
    shr   edx, 1

	mov   [edi-2], ax
	and   [edi-2], dx

	dec   ecx	
	cmp   ecx, 0

	jg    repeat1
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16BitShadow ( U16ptr dest, U16ptr source, int num , int h)
{
	if( num <= 0) return;
 
 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
	mov   eax, 0xf79e
	nop

repeat1:
    
	mov   edx, [edi]
	add   edi, 2
    
    and   edx, 0xf79e
    shr   edx, 1

	mov   [edi-2], ax
	and   [edi-2], dx

	dec   ecx	
	cmp   ecx, 0

	jg    repeat1
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy15Bit50Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat1:
    
	mov   edx, [edi]
	add   edi, 2

	mov   eax, [esi]
	add   esi, 2	

	and   eax, 0x7BDE	// mask off low bits 111101111011110 // 31710
	and   edx, 0x7BDE	// mask off low bits 111101111011110 // 31710

	shr   eax, 1		// 50 % value
	dec   ecx			// counter stores flag

	shr   edx, 1
	mov   [edi-2], ax

	add   [edi-2], dx

	cmp   ecx, 0
	jg    repeat1
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16Bit50Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat1:
    
	mov   edx, [edi]
	add   edi, 2

	mov   eax, [esi]
	add   esi, 2	

	and   eax, 0xf79e	// mask off low bits 1111011110011110 // 63390
	and   edx, 0xf79e	// mask off low bits 1111011110011110 // 63390

	shr   eax, 1		// 50 % value
	dec   ecx			// counter stores flag

	shr   edx, 1
	mov   [edi-2], ax

	add   [edi-2], dx

	cmp   ecx, 0
	jg    repeat1
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy15Bit25Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat2:
    
	mov   ebx, [edi]	// this will be 25% of source lightening the background more
	mov   edx, [edi]	// this will be 50%
	
	and   ebx, 0x739C	// mask off low bits 111001110011100 //  29596
	mov   eax, [esi]	// this will be 25%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0x739C	// mask off low bits 111001110011100 //  29596

	mov	  [edi], bx		// result 25%
	and   edx, 0x7BDE	// mask off low bits 111101111011110 // 31710

	shr   eax, 2		// 25 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 1		// 50%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 25%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 50% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat2
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16Bit25Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat2:
    
	mov   ebx, [edi]	// this will be 25% of source lightening the background more
	mov   edx, [edi]	// this will be 50%
	
	and   ebx, 0xe71c	// mask off low bits 1110011100011100 // 59164
	mov   eax, [esi]	// this will be 25%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0xe71c	// mask off low bits 1110011100011100 // 59164

	mov	  [edi], bx		// result 25%
	and   edx, 0xf79e	// mask off low bits 1111011110011110 // 63390

	shr   eax, 2		// 25 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 1		// 50%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 25%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 50% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat2
 }
}
///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy15Bit75Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat3:
    
	mov   ebx, [esi]	// this will be 25% of source lightening the foreground more
	mov   edx, [edi]	// this will be 25%
	
	and   ebx, 0x739C	// mask off low bits 111001110011100 //  29596
	mov   eax, [esi]	// this will be 50%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0x7BDE	// mask off low bits 111101111011110 //  31710

	mov	  [edi], bx		// result 25%
	and   edx, 0x739C	// mask off low bits 111001110011100 // 29596

	shr   eax, 1		// 50 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 2		// 25%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 50%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 25% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat3
 }
}

///////////////////////////////////////////////////////////////////////////////
void __fastcall Memcpy16Bit75Percent ( U16ptr dest, U16ptr source, int num , int h)
{
	if (num <= 0) return;

 _asm
 {
	mov   ecx, num      // how many copies
	mov   edi, dest     // to where
    mov   esi, source   // set source
	nop

repeat3:
    
	mov   ebx, [esi]	// this will be 25% of source lightening the foreground more
	mov   edx, [edi]	// this will be 25%
	
	and   ebx, 0xe71c	// mask off low bits 1110011100011100 // 59164
	mov   eax, [esi]	// this will be 50%				
	
	shr	  ebx, 2		// now 25%
	and   eax, 0xf79e	// mask off low bits 1111011110011110 //  63390

	mov	  [edi], bx		// result 25%
	and   edx, 0xe71c	// mask off low bits 1110011100011100 // 59164

	shr   eax, 1		// 50 % value
	add   edi, 2		// offset pointer	
	
	shr   edx, 2		// 25%
	add   esi, 2			
	
	add   [edi-2], ax	// Result + 50%
	dec   ecx			// counter stores flag	

	add   [edi-2], dx	// Result + 25% 
	nop					// keeping the pipes lined up	

	cmp   ecx, 0
	jg    repeat3
 }
}


