     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// command.cpp
/////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "command.h"

extern mapValuable g_ValuableTable;
extern mapFunction g_FunctionTable;
/////////////////////////////////////////////////////////////////////////
int cCommand :: Run_Command()
{ 
	int s = m_vContainer.size(), size, iRetVal;
	m_pchStack    = new char[ 100]; //
    m_byStackSize = 0;

	for( int i = 0; i < s; i++)
	{   //  ɾ ó.....  TALK( TEST( 0),....) TEST( 0)κó
		cVariant var     = m_vContainer[ i];
		size             = var.GetSize();
		TOKEN_TYPES type = ( TOKEN_TYPES) var.GetTokenType();

		if( type == TT_COMMAND)
		{
			cCommand com  = variant_cast< cCommand > ( var);
			cVariant var1( com.Run_Command(), TT_NUMBER);
			SetNthElement( i, var1);
		}
		else if( type == TT_VALUABLE && m_Type != CT_VALUABLE_DEFINE)
		{
			string str = variant_cast< string >( var);
		}
		else
		{   // Լ Ķ ó    
			if( VT_string == var.GetVariantType())
			{
				string str = variant_cast < string > ( var);
				char* pch  = const_cast < char* > ( str.c_str());
				memcpy( m_pchStack + m_byStackSize, &pch, size);
				
			}
			else memcpy( m_pchStack + m_byStackSize, var.GetValue(), size);

			m_byStackSize += size;
		}
	} 

	iRetVal = Call_Function( m_pchStack, m_byStackSize, Get_Function());
	SAFE_DELETE_ARRAY( m_pchStack);

	return iRetVal;
} 
/////////////////////////////////////////////////////////////////////////
int cCommand :: Call_Function( const void* args, size_t sz, DWORD func)
{
	int rc;

	_asm
	{
		mov   ecx, sz
		mov   esi, args
		sub   esp, ecx
		mov   edi, esp
		shr   ecx, 2
		rep   movsd
        call  dword ptr [ func]
		mov   rc, eax
	}

	return ( rc);
}
/////////////////////////////////////////////////////////////////////////
void cCommand :: Push_back( cVariant Variant )
{	
    m_vContainer.push_back( Variant);
}
/////////////////////////////////////////////////////////////////////////
void cCommand :: Clear()
{
    int s = m_vContainer.size();
	for( int i = 0; i < s; i++)
	{
		cVariant var = m_vContainer[ i];
		BYTE token   = var.GetTokenType();
	
        if( token == TT_COMMAND)
		{
			cCommand com = variant_cast < cCommand > ( var);
			com.Clear();
		}

	    var.Clear();
	}
	
	m_vContainer.clear();
}
/////////////////////////////////////////////////////////////////////////
cVariant cCommand :: GetNthElement( int id)
{
	// return m_vContainer.at( id);
	return m_vContainer[ id];
}
/////////////////////////////////////////////////////////////////////////
cVariant cCommand :: GetLastElement()
{
	int s = m_vContainer.size() - 1; 
	return m_vContainer[ s];
}
/////////////////////////////////////////////////////////////////////////
bool cCommand :: Empty() const 
{ 
	return m_vContainer.empty();
}
/////////////////////////////////////////////////////////////////////////
size_t cCommand :: Size() const 
{
	return m_vContainer.size();
}
/////////////////////////////////////////////////////////////////////////
void cCommand :: SetNthElement( int i, cVariant Variant)
{
	m_vContainer[ i] = Variant;
}
/////////////////////////////////////////////////////////////////////////
bool cCommand :: Save( cFile& file)
{
	assert( file.Status() == 0);

    BYTE s = m_vContainer.size();
	file.Write( &m_Type, sizeof( BYTE));
	file.Write( &s, sizeof( BYTE));
	for( int i = 0; i < s; i++)
	{
		cVariant var = m_vContainer[ i];
		BYTE token   = var.GetTokenType();
		file.Write( &token, sizeof( BYTE));

        if( token == TT_COMMAND)
		{
			cCommand com = variant_cast < cCommand > ( var);
			if( !com.Save( file)) 
				return Fail( this, "COMMAND_ERR_SAVE");
		}
		else 
		{
			if( !var.Save( file))
			    return Fail( this, "COMMAND_ERR_SAVE");
		}
	}

	return true;
}
/////////////////////////////////////////////////////////////////////////
bool cCommand :: Load( cFile& file)
{
	assert( file.Status() == 0);
    BYTE s;

   	file.Read( &m_Type, sizeof( BYTE));
	file.Read( &s, sizeof( BYTE));
	for( int i = 0; i < s; i++)
	{
		BYTE token;
		file.Read( &token, sizeof( BYTE));

		if( token == TT_COMMAND)
		{
			cCommand cmd;
			if( !cmd.Load( file))
				return Fail( this, "COMMAND_ERR_LOAD");

			cVariant var( cmd, TT_COMMAND);
			Push_back( var);
		}
		else 
		{
			cVariant var;
			if( !var.Load( file))
			    return Fail( this, "COMMAND_ERR_LOAD");

			Push_back( var);
		}
	}

	return true;
}
////////////////////////////////////////////////////////////////////////////////////
// ValueableTable
////////////////////////////////////////////////////////////////////////////////////
void InsertValueable( string sValName, cVariant Variant)
{
     g_ValuableTable[ sValName] = Variant;
}
////////////////////////////////////////////////////////////////////////////////////
void EraseValueable(string sname) 
{
	g_ValuableTable.erase( sname);
}   
////////////////////////////////////////////////////////////////////////////////////
cVariant FindValueable( string sValName)
{
	mapValuable :: iterator iter = g_ValuableTable.find( sValName);
    return ( *iter).second;
}
////////////////////////////////////////////////////////////////////////////////////
// FunctionTable
////////////////////////////////////////////////////////////////////////////////////
void InsertFunction( string sValName, DWORD dwFunc)
{
     g_FunctionTable[ sValName] = dwFunc;
}
////////////////////////////////////////////////////////////////////////////////////
void EraseFunction( string sname) 
{
	 g_FunctionTable.erase( sname);
}   
////////////////////////////////////////////////////////////////////////////////////
DWORD FindFunction( string sValName)
{
	mapFunction :: iterator iter =  g_FunctionTable.find( sValName);
    return ( *iter).second;
}