     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef _COMMAND_H_
#define _COMMAND_H_

#ifndef _VARIANT_H_
#include "variant.h"
#endif

/////////////////////////////////////////////////////////////////////////
enum COMMAND_TYPES { CT_ERROR, CT_BEGIN, CT_END, CT_VALUABLE_DEFINE, CT_VALUABLE,
                     CT_ATTACK, CT_TALK, CT_GOTO, CT_FINISH, CT_GOSUB, CT_RETURN, CT_TEST};

/////////////////////////////////////////////////////////////////////////
enum TOKEN_TYPES   { TT_ERROR, TT_OPERATOR, TT_NUMBER, TT_COMMAND, TT_VALUABLE,
                     TT_QUOTE, TT_EOL, TT_EOC, TT_EOE, TT_EOF};

/////////////////////////////////////////////////////////////////////////
enum OPERATOR_TYPES { OT_ERROR, OT_PLUS, OT_MINUS, OT_DIVIDE, OT_MULTI,
					  OT_EQUAL, OT_LESS_THAN, OT_GREATER_THAN};

/////////////////////////////////////////////////////////////////////////
// cCommand
/////////////////////////////////////////////////////////////////////////
typedef class cCommand
{
public:
	cCommand() {}
	~cCommand() {}

	bool                Load( cFile& file);
	bool                Save( cFile& file);

    void                Push_back( cVariant Variant);
	void                Clear();
    bool                Empty() const;
    size_t              Size() const;

	cVariant            GetNthElement( int id);
	cVariant            GetLastElement();
	BYTE                GetType() const { return m_Type;}
	char*               GetStack() const { return m_pchStack;}
	int                 GetStackSize() const { return m_byStackSize;}

	void                SetType( COMMAND_TYPES Type) { m_Type = Type;}
	void                SetNthElement( int i, cVariant Variant);
	int                 Run_Command();

private:
    int                 Call_Function( const void* args, size_t sz, DWORD func);
	DWORD               Get_Function() { return 0;}
	
private:
    vector < cVariant > m_vContainer;
	BYTE                m_Type;
	char*               m_pchStack;
	BYTE                m_byStackSize;
	DWORD               m_dwFunctionPtr;

} cCommand, * cCommandPtr;
/////////////////////////////////////////////////////////////////////////
void     InsertValueable( string sValName, cVariant Variant);
void     EraseValueable(string sname); 
cVariant FindValueable( string sValName);

void     InsertFunction( string sValName, DWORD dwFunc);
void     EraseFunction( string sname); 
DWORD    FindFunction( string sValName);

#endif
/////////////////////////////////////////////////////////////////////////