     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// event.h
///////////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "event.h"
#include "command.h"
#include <imagehlp.h>

///////////////////////////////////////////////////////////////////////////////////
void cEvent :: Push_back ( cCommand com )
{	
    m_vCmdList.push_back ( com);
}
///////////////////////////////////////////////////////////////////////////////////
void cEvent :: Clear()
{
	int size = m_vCmdList.size();
	for( int i = 0; i < size; i++)
	{
		cCommand cmd = GetNthCommand( i);
        cmd.Clear();
	}   
	
    m_vCmdList.clear();
    m_mapValuable.clear();
}
///////////////////////////////////////////////////////////////////////////////////
cCommand cEvent :: GetNthCommand( int id)
{
	// return m_vCmdList.at( id);
	return m_vCmdList[ id];
}
///////////////////////////////////////////////////////////////////////////////////
bool cEvent :: EmptyCommand() const 
{ 
	return m_vCmdList.empty();
}
///////////////////////////////////////////////////////////////////////////////////
size_t cEvent :: SizeCommand() const 
{
	return m_vCmdList.size();
}
//////////////////////////////////////////////////////////////////////////////////
void cEvent :: EraseCommand( int id)
{
	int size = m_vCmdList.size();
	if( id >= size) return ;

	vector < cCommand > :: iterator iter = &m_vCmdList.at( id);
	m_vCmdList.erase( iter);
}
//////////////////////////////////////////////////////////////////////////////////
bool cEvent :: Run_Event()
{
	int size = m_vCmdList.size();

	for( int i = 0; i < size; i++)
		GetNthCommand( i).Run_Command();
        	
	return true;
}
////////////////////////////////////////////////////////////////////////////////
string cEvent :: GetEventName()
{
	cCommand cmd = GetNthCommand( 0);
	return variant_cast< string >( cmd.GetNthElement( 0));
}
/////////////////////////////////////////////////////////////////////////////////
bool cEvent :: Save( cFile& file)
{	
	assert( file.Status() == 0 );
	BYTE size = m_vCmdList.size();
    
	file.Write( &size, sizeof( BYTE));
	for( int i = 0; i < size; i++)
	{
		cCommand cmd;
		cmd = GetNthCommand( i);
        cmd.Save( file);
	}   
	
	return true;
}
/////////////////////////////////////////////////////////////////////////////////
bool cEvent :: Load( cFile& file)
{
	assert( file.Status() == 0 );
	BYTE size;
    
	file.Read( &size, sizeof( BYTE));
	for( int i = 0; i < size; i++)
	{
		cCommand cmd;
		cmd.Load( file);
        Push_back( cmd);
	}   

	return true;	
}

