     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Graphic.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "graphic.h"
#include "asm.h"

///////////////////////////////////////////////////////////////////////////////
cGraphic :: cGraphic()
{
	m_Canvas.size.iWidth = m_Canvas.size.iHeight = 0;
	m_wNumPixels         = 0;
	m_dwFlag             = 0;
	m_Canvas.pwAddress   = m_pwScratchPad = NULL;
	m_pfBlitFunction     = Memcpy16Bit;
//	m_pfDrawAtFunction   = DrawAt;
	m_CenterPt.x         = 0;
	m_CenterPt.y         = 0;
}
///////////////////////////////////////////////////////////////////////////////
cGraphic :: ~cGraphic()
{	
	Clear();
}
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: Clear()
{
	if( m_dwFlag & GRP_VIRTUAL) return;
	SAFE_DELETE_ARRAY( m_pwScratchPad);
	SAFE_DELETE_ARRAY( m_Canvas.pwAddress);
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: LoadGraphic( string sFilePath, DWORD dwFlag)
{   
	assert( g_pScreen);
	AddGraphicFlag( dwFlag);
	bool bLoad;

    if(( sFilePath.rfind( "bmp") != -1) || ( sFilePath.rfind( "BMP") != -1)) 
		bLoad = LoadBmp( sFilePath);
	else if((sFilePath.rfind( "tga") != -1) || ( sFilePath.rfind( "TGA") != -1)) 
		bLoad = LoadTga( sFilePath);
    
	if( bLoad && ( dwFlag & GRP_CENTERDRAW))
	{
		m_CenterPt.x = GetWidth() / 2;
		m_CenterPt.y = GetHeight() / 2;
	}
    
	return bLoad;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Save( cFile& file)
{
    assert( file.Status() == 0);

	if( file.Status() != 0) 
	{
		assert( !"Invalid file handle");
		return Fail( this, "GRAPHIC_ERR_SAVE_INVALID_FILE");
	}
	file.Write( &m_dwFlag, sizeof( DWORD));
	file.Write( &m_Canvas.size, sizeof( CANVAS_SIZE));
	file.Write( &m_CenterPt, sizeof( POINT));
	file.Write( &m_wNumPixels, sizeof( WORD));
	file.Write( m_Canvas.pwAddress, m_wNumPixels * sizeof( WORD));

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Load( cFile& file)
{
	assert( g_pScreen);
	assert( file.Status() == 0);

	if( file.Status() != 0) 
	{
		assert( !"Invalid file handle");
		return Fail( this, "GRAPHIC_ERR_LOAD_INVALID_FILE");
	}

    file.Read( &m_dwFlag, sizeof( DWORD));
    file.Read( &m_Canvas.size, sizeof( CANVAS_SIZE));
	file.Read( &m_CenterPt, sizeof( POINT));
	file.Read( &m_wNumPixels, sizeof( WORD));

	//  ޼ҵ尡  ȣǾ   ׸  ־.
	//   ݺǴ  ϱ  ε  ˻Ѵ
	assert( m_Canvas.size.iWidth > 0);
	assert( m_Canvas.size.iHeight > 0);
	assert( m_wNumPixels > 0);

	if( !m_Canvas.pwAddress) SAFE_DELETE_ARRAY( m_Canvas.pwAddress);
	m_Canvas.pwAddress = new WORD[ m_wNumPixels];
	file.Read( m_Canvas.pwAddress, m_wNumPixels * sizeof( WORD));

	COLOR_TYPE ColorType = g_pGraphicFormat->ColorType;
	if( !( m_dwFlag & ( DWORD) ColorType))
	{  //  ϵ ⼭ ȯɼ  ...
       if(      ColorType == _5x5x5_) ConvertTo_5x5x5( m_Canvas.pwAddress, m_wNumPixels);
	   else if( ColorType == _5x6x5_) ConvertTo_5x6x5( m_Canvas.pwAddress, m_wNumPixels);
	   else return Fail( this, "GRAPHIC_ERR_LOAD_SAVEDFILE");
	}
   
    return true;
}
///////////////////////////////////////////////////////////////////////////////
// 츰 24Ʈ bmpϷ ۾ϰ  ̴.
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: LoadBmp( string sbmpfile)
{
	BITMAPFILEHEADER bmpfh;
	BITMAPINFOHEADER bmpih;
	cFile file( sbmpfile, cFile :: FF_READ);

	if( file.Status() != 0) 
		return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	if( file.Read( &bmpfh, sizeof( bmpfh)))
		return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	if( bmpfh.bfType != 0x4d42)
		return Fail( this, "GRAPHIC_ERR_NOT_BMP");

	file.Read( &bmpih, sizeof( bmpih));
	m_Canvas.size.iWidth  = bmpih.biWidth;
	m_Canvas.size.iHeight = bmpih.biHeight;

	SAFE_DELETE_ARRAY( m_pwScratchPad);
   	m_pwScratchPad  = new WORD[ m_Canvas.size.iWidth * m_Canvas.size.iHeight];

	// m_pwScratchPad Ű ޸𸮿 ̹ εѴ.
	 if( bmpih.biBitCount == 8) 
		if( !Load8Bit( file, bmpih.biClrUsed)) 
			return Fail( this, "GRAPHIC_ERR_LOAD8BITS_BMP");

	if( bmpih.biBitCount == 24) 
		if( !Load24Bit( file)) 
			return Fail( this, "GRAPHIC_ERR_LOAD24BITS_BMP");
   
	if( m_dwFlag & GRP_COMPRESS) CompressGraphic( m_pwScratchPad);
	else
	{
		m_wNumPixels             = m_Canvas.size.iWidth * m_Canvas.size.iHeight;
		m_Canvas.size.iRealWidth = m_Canvas.size.iWidth;
		m_Canvas.pwAddress       = m_pwScratchPad;
	}

	if( !m_Canvas.pwAddress) return Fail( this, "GRAPHIC_ERR_LOADBMP");
	m_pwScratchPad  = NULL;

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: LoadTga( string stgaFilePath)
{
	TARGA_HEADER TgaHeader;
	cFile file( stgaFilePath, cFile :: FF_READ);

	if( file.Status() != 0) 
	return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	file.Read( &TgaHeader, sizeof( TgaHeader));
	if( TgaHeader.ImageType == 9 || TgaHeader.ImageType == 11)
		return Fail( this, "GRAHIC_ERR_NOT_SURFORT_COMPREESED_TGA");

	m_Canvas.size.iWidth  = TgaHeader.Width;
	m_Canvas.size.iHeight = TgaHeader.Height;

	SAFE_DELETE_ARRAY( m_pwScratchPad);
   	m_pwScratchPad  = new WORD[ m_Canvas.size.iWidth * m_Canvas.size.iHeight];

	if( TgaHeader.PixelDepth == 8) return Fail( this, "GRAPHIC_ERR_CANNOT_SURFORT_8BIT_TGA");
	if( TgaHeader.PixelDepth == 16) 
		if( !Load16Bit( file)) return Fail( this, "GRAPHIC_ERR_LOAD_16BIT_TGA");
	
	if( TgaHeader.PixelDepth == 24)
		if( !Load24Bit( file)) return Fail( this, "GRAPHIC_ERR_LOAD24BITS_TGA");

	if( m_dwFlag & GRP_COMPRESS) CompressGraphic( m_pwScratchPad);
	else
	{
		m_wNumPixels              = m_Canvas.size.iWidth * m_Canvas.size.iHeight;
		m_Canvas.pwAddress        = m_pwScratchPad;
		m_Canvas.size.iRealWidth  = m_Canvas.size.iWidth;
		
	}
	m_pwScratchPad        = NULL;
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// ׷ ī尡 3D Ӹ    Ưȿ Ʈ óؾѴ.
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: CompressGraphic( WORD* pwSrc)
{
	assert( pwSrc);

	m_wColorKey         = GetColorKey( pwSrc);
	m_Canvas.size.iRealWidth = m_Canvas.size.iWidth;
	m_Canvas.pwAddress  = LLECompression16Bit( pwSrc, m_Canvas.size.iWidth,
		                  m_Canvas.size.iHeight, &m_wNumPixels);
	SAFE_DELETE_ARRAY( pwSrc);
}
///////////////////////////////////////////////////////////////////////////////
// m_Canvas.pwAddress : 24Ʈ ̹ Ÿ 16Ʈ Ǿ Ǿ ޸ 
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Load24Bit( cFile& file)
{   
	assert( file.Status() == 0);

	if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	int h               = m_Canvas.size.iHeight; 
	int w               = m_Canvas.size.iWidth ;
    UINT  iLoadWidth    = sizeof( RGBVal) * w + ( w & 3 );
	RGBVal* pRgbVal     = new RGBVal[ w + 1];

	for (int i = h - 1 ; i >= 0 ; i--)
	{
		WORD* ptr = m_pwScratchPad + i * w;
		file.Read( pRgbVal, iLoadWidth);
		      
		// 24Bits ͸ 16Ʈ ؼ Ѵ. 
		ConvertTo16Bit ( ptr, pRgbVal , w);
	}
	SAFE_DELETE_ARRAY( pRgbVal);
	return true;
}
///////////////////////////////////////////////////////////////////////////////
//  Լ  Tga 16Ʈ  дµ ϰ̴.
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Load16Bit( cFile& file)
{	
    assert( file.Status() == 0);

    if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	for( int i = m_Canvas.size.iHeight - 1 ; i >= 0; i--)
	{
    	WORD* ptr = m_pwScratchPad + i * m_Canvas.size.iWidth;
		file.Read( ptr, m_Canvas.size.iWidth * sizeof( WORD));
	}
	// 16Ʈ Tga  _5x5x5_ Ÿ Ǿ ִ.
	if( g_pGraphicFormat->ColorType == _5x6x5_) 
		ConvertTo_5x6x5( m_pwScratchPad, m_Canvas.size.iWidth * m_Canvas.size.iHeight);

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool  cGraphic :: Load8Bit( cFile& file, int numcolor)
{   // m_Canvas.pwAddress : 8Ʈ ̹ Ÿ 16Ʈ Ǿ Ǿ ޸  
	assert( m_pwScratchPad);
	assert( file.Status() == 0 );

	if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_ERR_INVALID_FILE");

	if( numcolor == 0) numcolor = 256;

	int h = m_Canvas.size.iHeight;
	int w = m_Canvas.size.iWidth ;
    int LoadWidth = ( w & 3) ? ( w + ( 4 - ( w & 3))) : ( w);
  
	PALETTEENTRY* pPe = new PALETTEENTRY[ numcolor];
	RGBVal* pRgb      = new RGBVal[ LoadWidth];
	BYTE* pIndex      = new BYTE[ LoadWidth];
     
	// ȷƮ д´.
	file.Read( pPe, sizeof( PALETTEENTRY) * numcolor);

	// ؽ д´.	
	for( int i = h - 1; i >= 0 ; i--)
	{
		WORD* ptr = m_pwScratchPad + i * w;

		if ( file.Read( pIndex, LoadWidth)) 
			return Fail( this, "GRAPHIC_ERR_CANNOT_Read_PALINDEX");

		ConvertIndexToRGB ( pRgb, pIndex, pPe, w);
		ConvertTo16Bit ( ptr, pRgb, w);
	}

	SAFE_DELETE_ARRAY( pIndex);
	SAFE_DELETE_ARRAY( pRgb);
    SAFE_DELETE_ARRAY( pPe);

	return true;
}
///////////////////////////////////////////////////////////////////////////////
WORD cGraphic :: GetColorKey( WORD* ptr)
{
	assert( ptr);
	WORD ColorKey = 0;

	if( m_dwFlag & GRP_CLRKEY_FIND) ColorKey =  *ptr;
	else if( m_dwFlag & GRP_CLRKEY_WHITE)
		ColorKey = ( WORD) ( g_pGraphicFormat->dwRBitMask | g_pGraphicFormat->dwGBitMask | g_pGraphicFormat->dwBBitMask);
	else if( m_dwFlag & GRP_CLRKEY_BLACK)
	    ColorKey = ( WORD) 0;

	return ColorKey;
}
///////////////////////////////////////////////////////////////////////////////
inline void cGraphic :: ConvertTo16Bit ( WORD* pImage, RGBVal* pRgbData, int num )
{   // _5x5x5_ or _5x6x5_ ⺻ ǥ Ӽ̴.
	//  ⺻ǥ Ҷ  ˾Ƴ Ѵ.
    assert( pImage);
	assert( pRgbData);

	if( g_pGraphicFormat->ColorType == _0x0x0_) return;
	if( g_pGraphicFormat->ColorType == _5x5x5_)
	{
		AddGraphicFlag( GRP_CLRTYPE_5x5x5_);
	    while (num--)
		{
		   *pImage = pRgbData->Convert15();
		   pImage++, pRgbData++;
		}
	}
	else
	{
		AddGraphicFlag( GRP_CLRTYPE_5x6x5_);
		while (num--)
		{
		   *pImage = pRgbData->Convert16();
		   pImage++, pRgbData++;
		}
	}
}
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: ConvertTo_5x6x5( WORD* ptr , int num)
{
	assert( ptr);

	WORD  RMask = 31 << 10;
	WORD  GMask = 31 << 5;
	WORD  BMask = 31;

	while( num--)
	{
		WORD r = *ptr & RMask;
		WORD g = *ptr & GMask;
		WORD b = *ptr & BMask;

		*ptr++ = ( WORD) (( r << 1) + ( g << 1) + b);
	}
}
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: ConvertTo_5x5x5( WORD* ptr , int num)
{
	assert( ptr);

	WORD  RMask = 31 << 11;
	WORD  GMask = 31 << 6;
	WORD  BMask = 31;

	while( num--)
	{
		WORD r = *ptr & RMask;
		WORD g = *ptr & GMask;
		WORD b = *ptr & BMask;

		*ptr++ = ( WORD) (( r >> 1) + ( g >> 1) + b);
	}
}
///////////////////////////////////////////////////////////////////////////////
inline void  cGraphic :: ConvertIndexToRGB( RGBVal* rgb, BYTE* pIndex, LPVOID pPal, int len)
{
	if (len < 1) return;
    PALETTEENTRY* pe = (PALETTEENTRY*) pPal;
	while ( len--)
	{
		PALETTEENTRY* p = &pe[*pIndex];

		rgb->b = p->peRed;
		rgb->g = p->peGreen;
		rgb->r = p->peBlue;
		rgb++; pIndex++;
	}
}
///////////////////////////////////////////////////////////////////////////////
int cGraphic :: Clipping( CANVASPtr pDestCan, int x, int y)
{	
	assert( pDestCan);

	int left   = 0;
	int right  = pDestCan->size.iWidth;
	int top    = 0;
	int bottom = pDestCan->size.iHeight;
	int w      = m_Canvas.size.iWidth;
	int h      = m_Canvas.size.iHeight;

	//  Ŭ.. ׸ʿ䰡 .
    if( left   >  x + w)  return - 1; 
    if( right  <  x    )  return - 1;
	if( top    >  y + h)  return - 1;
	if( bottom <  y    )  return - 1;

	// Ŭ ʿ...
    if( ( left <= x) && ( right >= x + w) && ( top <= y ) && ( bottom >= y + h))
		return 1;

	// κ Ŭ .. Ϻκи ׷ Ѵ.
	return 0;

}
///////////////////////////////////////////////////////////////////////////////
//  ۿ ׸ ִ.
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Draw( int x, int y, DWORD dwFlag)
{
	assert( g_pScreen);

// if( g_pScreen == NULL) return false; // ӵ  ȭ 
	return DrawAt( &g_pScreen->GetCanvas(), x, y, dwFlag);
//	return m_pfDrawAtFunction( &g_pScreen->GetCanvas(), x, y, dwFlag);
}
///////////////////////////////////////////////////////////////////////////////
//  ޸𸮿 ׸ ִ.
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: DrawAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag)
{
	if( m_dwFlag & GRP_SPRITE)   return DrawSpriteAt( pDestCan, x, y, dwFlag);
	if( m_dwFlag & GRP_NORMAL)   return DrawNormalAt( pDestCan, x, y, dwFlag);
    if( m_dwFlag & GRP_VIRTUAL)  return DrawVirtualAt( pDestCan, x, y, dwFlag);

	return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: DrawNormalAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag)
{
	assert( pDestCan);
    assert( m_pfBlitFunction);
    	
//	if( !pDestCan) return false; // ӵ  ȭ 
	int isClipping = Clipping( pDestCan, x, y);
	if( isClipping == -1) return true; //  Ŭ.
	
	SetBlitFunction( dwFlag);
	if( isClipping ==  1) return Blit( pDestCan, x, y);
	else return BlitClipped( pDestCan, x, y);
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: DrawSpriteAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag)
{
	assert( pDestCan);
    assert( m_pfBlitFunction);
   
//	if( !pDestCan) return false;
	int isClipping = Clipping( pDestCan, x, y);
	if( isClipping == -1) return true; //  Ŭ. 

	x -= m_CenterPt.x;
	y -= m_CenterPt.y;
	SetBlitFunction( dwFlag);
	
	if( isClipping ==  1) return BlitCompressed( pDestCan, x, y);
	else return BlitCompressedClipped( pDestCan, x, y);
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: DrawVirtualAt( CANVASPtr pDestCan, int x, int y, DWORD dwFlag)
{
	assert( pDestCan);
    assert( m_pfBlitFunction);
    	
//	if( !pDestCan) return false; 

	SetBlitFunction( dwFlag);
	if( m_dwFlag & GRP_VIRTUAL_COMPRESS) return BlitCompressedVirtualGraphic( pDestCan, x, y); 
	else return Blit( pDestCan, x, y);
}
///////////////////////////////////////////////////////////////////////////////
//  ̹ Ÿ ϴ Լ 
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: Blit( CANVASPtr pDestCan, int x, int y)
{	
	assert( m_Canvas.pwAddress);
	assert( pDestCan); 
    assert( pDestCan->pwAddress);
	assert( m_pfBlitFunction);

#ifdef _DEBUG
	if( !m_Canvas.pwAddress) return false;
	if( !pDestCan) return false;
    if( !pDestCan->pwAddress) return false;
#endif

	WORD* pwDest = pDestCan->pwAddress +  y * pDestCan->size.iRealWidth  + x;
	WORD* pwSrc  = ( WORD* ) m_Canvas.pwAddress;
    int w        = m_Canvas.size.iWidth;
	int h        = m_Canvas.size.iHeight + 1;
	int rw       = pDestCan->size.iRealWidth;
	int srw      = m_Canvas.size.iRealWidth;

	while( --h > 0) // h-- --h .
	{   
		m_pfBlitFunction( pwDest, pwSrc, w, h); //  ڵ ȭ ڵ 
		pwDest += rw;
		pwSrc  += srw;
	}
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: BlitClipped( CANVASPtr pDestCan, int x, int y)
{		
	assert( m_Canvas.pwAddress);
	assert( pDestCan); 
    assert( pDestCan->pwAddress);
	assert( m_pfBlitFunction);

#ifdef _DEBUG
	if( !m_Canvas.pwAddress) return false;
	if( !pDestCan) return false;
    if( !pDestCan->pwAddress) return false;
#endif

	int right   = pDestCan->size.iWidth;
	int bottom  = pDestCan->size.iHeight;
	WORD* pwSrc = ( WORD* ) m_Canvas.pwAddress;
    int w       = m_Canvas.size.iWidth;
	int h       = m_Canvas.size.iHeight;
	int rw      = pDestCan->size.iRealWidth;
	int srw     = m_Canvas.size.iRealWidth;
	
    if ( x >= right -  w) w = right  - x;
	if ( y >= bottom - h) h = bottom - y;
	if ( x <  0         ) { pwSrc -= x;    ; w += x; x = 0;}
	if ( y <  0         ) { pwSrc -= y * w; h += y; y = 0;}

    WORD* pwDest = pDestCan->pwAddress + y * pDestCan->size.iRealWidth + x; ++h;
	while( --h > 0) // h-- --h .
	{   
		m_pfBlitFunction( pwDest, pwSrc, w, h); //  ڵ ȭ  
		pwDest += rw;
		pwSrc  += srw;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
// Ϲ Ʈ Ѹ Լ
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: BlitCompressed( CANVASPtr pDestCan, int x, int y)
{		
	assert( m_Canvas.pwAddress);
	assert( pDestCan); 
    assert( pDestCan->pwAddress);
	assert( m_pfBlitFunction);

#ifdef _DEBUG
	if( !m_Canvas.pwAddress) return false;
	if( !pDestCan) return false;
    if( !pDestCan->pwAddress) return false;
#endif

	WORD* pDest     = pDestCan->pwAddress + y * pDestCan->size.iRealWidth + x;
	WORD* pImage    = ( WORD* ) m_Canvas.pwAddress;
	WORD* pDestTemp;
	int w   = m_Canvas.size.iWidth, h = m_Canvas.size.iHeight + 1;
	int rw  = pDestCan->size.iRealWidth;
	int srw = m_Canvas.size.iRealWidth;
	int runs, len;

	while ( --h > 0)				
	{
		pDestTemp = pDest;
		runs      = *pImage++; //  Ʈ ¸ ˾Ƴ.	
		if ( runs == 1)        //   ȼ Ϲ ÷ Ǿ ִ.
		{
			m_pfBlitFunction ( pDestTemp, pImage, w, h); 
			pImage += srw;

		}		
		else // runs == 0 ϶ ޸𸮸 ǳ ڴ.
		{	
			while ( --runs > 0)
			{ 
				pDestTemp += *pImage++; // ÷Ű شϴ ȼ ǳʶڴ.
				len        = *pImage++;
				m_pfBlitFunction( pDestTemp, pImage, len, h);			
				pDestTemp += len;		
				pImage    += len;	
			}
		}
		pDest += rw; 
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic :: BlitCompressedVirtualGraphic( CANVASPtr pDestCan, int x, int y)
{		
	assert( m_Canvas.pwAddress);
	assert( pDestCan); 
    assert( pDestCan->pwAddress);
	assert( m_pfBlitFunction);

#ifdef _DEBUG // ӵ  ȭ 
	if( !m_Canvas.pwAddress) return false;
	if( !pDestCan) return false;
    if( !pDestCan->pwAddress) return false;
#endif

    x += m_CenterPt.x;
	WORD* pDest  = pDestCan->pwAddress + y * pDestCan->size.iRealWidth + x;
	WORD* pImage = ( WORD* ) m_Canvas.pwAddress;
	WORD* pDestTemp;

	int w    = m_Canvas.size.iWidth, h = m_Canvas.size.iHeight + 1;
	int rw   = pDestCan->size.iRealWidth;
	int srw  = m_Canvas.size.iRealWidth;
	int left = - m_CenterPt.x;
	int runs, len, n, newdist, newlen;

	while( --h > 0)				
	{	
		pDestTemp = pDest;
		runs      = *pImage++; //  Ʈ ¸ ˾Ƴ.
		
		if( runs == 1)         //   ȼ Ϲ ÷ Ǿ ִ.
		{
		    pDestTemp += left;
			pImage    += left;
			m_pfBlitFunction( pDestTemp, pImage, w, h);
			pImage    += srw;
		}		
		else	               // runs == 0 ϶ ޸𸮸 ǳ ڴ.
		{	
			n = 0;
			while ( --runs > 0)
			{ 
		    	n         += *pImage;		
				pDestTemp += *pImage++;   							
				len        = *pImage++;	
                
				if( left < n) 
				{ 
					if( len + n > w + left) 
					{
						newlen = w + left - n;
						m_pfBlitFunction( pDestTemp, pImage, newlen, h);
					}
					else m_pfBlitFunction( pDestTemp, pImage, len, h);		
				}
			    else 
				{
					if( len + n > w + left) 
					{
                        newdist    = left - n;
						pDestTemp += newdist;	
						pImage    += newdist;
						m_pfBlitFunction( pDestTemp, pImage, w, h);
						pDestTemp -= newdist; 	
						pImage    -= newdist;	 
					}
					else
					{
						newdist    = left - n;
						newlen     = len - newdist;
						pDestTemp += newdist;	
						pImage    += newdist;
						m_pfBlitFunction( pDestTemp, pImage, newlen, h);
						pDestTemp -= newdist; 	
						pImage    -= newdist;
					}
                }
		
				n         += len;		// update count
				pDestTemp += len;
				pImage    += len;
			}
		}
        pDest += rw;
		 
	}

	return true;
}
////////////////////////////////////////////////////////////////////////////////
bool cGraphic :: BlitCompressedClipped( CANVASPtr pDestCan, int x, int y)
{
	assert( pDestCan);
	assert( m_pfBlitFunction);

	WORD*  pwDest = pDestCan->pwAddress + y * pDestCan->size.iRealWidth + x;// starting location
	WORD*  pDestTemp;
	WORD*  pImage = ( WORD* ) m_Canvas.pwAddress;
	int    len, bytes, clipleft = 0, clipright = 0, newlen, newdist;
	int    runs;
	int	   top = 0, left = 0, bottom = pDestCan->size.iHeight, right = pDestCan->size.iWidth,
		   height = pDestCan->size.iHeight, width = pDestCan->size.iRealWidth;
	int	   w = m_Canvas.size.iWidth, h = m_Canvas.size.iHeight;

	if( y + h > bottom) h = bottom - y;				

	while( y < top)
	{
		++y; pwDest += width; --h;	
		int runs = *pImage++;
									
		if( runs == 1){ pImage += w;} //   ȼ Ϲ ÷ Ǿ ִ.
		else // ̹  ũεǾ Ѵٸ 
		{			
			while( --runs > 0)
			{
				pImage++;	
				len = *pImage++;	
				pImage += len;
			}
		}		
	}
	if( x < left) { clipleft = left - x;}								
	if( x + w > right) { clipright = right - x;}

	while( h-- > 0)
	{
		pDestTemp = pwDest;			
		runs = *pImage++; //  ¸ ´.			
								
		if( runs == 1)
		{	
			if( clipleft) 			
			{	
				len        = w - clipleft;  
				pDestTemp += clipleft;
				pImage    += clipleft;
				m_pfBlitFunction( pDestTemp, pImage, len, h);
				pImage    -= clipleft;
			}
			else if( clipright)		
			{	
				len = clipright;
				m_pfBlitFunction( pDestTemp, pImage, len, h);
			}
			else m_pfBlitFunction( pDestTemp, pImage, w, h);
			pImage += w;
		}
		else	
		{	
			bytes = 0;	
			while( --runs > 0)
			{
				bytes     += *pImage;		
				pDestTemp += *pImage++;   							
				len        = *pImage++;	
				if( clipleft)
				{
					if( bytes >= clipleft) //Ŭ ʿ.
					{
						m_pfBlitFunction( pDestTemp, pImage, len, h);
					}
					else if( bytes + len >= clipleft)
					{
						newdist    = clipleft-bytes;
						newlen     = len - newdist;
						pDestTemp += newdist;	
						pImage    += newdist;
						m_pfBlitFunction( pDestTemp, pImage, newlen, h);
						pDestTemp -= newdist; 	
						pImage    -= newdist;	
					}
					
				}
				else if( clipright)
				{
					if( bytes >= clipright){}
					else if( bytes + len < clipright)
					{
						m_pfBlitFunction( pDestTemp, pImage, len, h);
					}
					else
					{
						int newdist = clipright-bytes;
						m_pfBlitFunction( pDestTemp, pImage, newdist, h);
					}
				}
				else m_pfBlitFunction( pDestTemp, pImage, len, h);
				bytes      += len;	
				pDestTemp  += len;
				pImage     += len;
			}
		}
		pwDest += width; 
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
WORD* cGraphic :: LLECompression16Bit( WORD* pImage, int width, int height, WORD* pNumPixels) const
{    
    assert( pImage);
	assert( pNumPixels);

	int w = width, h = height, size;
	int BytesInLine = 0;

	WORD* pTempCompress, * pCompressPtr, * pRetCompress;
	WORD* pImagePtr = pImage; //  ̹  ִ ޸

	pTempCompress = new WORD[ w * ( h << 2)]; // ̹   ޸ ũ⸦ 
    pCompressPtr = pTempCompress;	          //  ˼ Ƿ  ũ ޸𸮸 Ȯ
    ++h;

 	while( --h > 0)
	{     
		// ̹ پ 鼭 ̹  õѴ.
  		LLECompressSingleLine16Bit ( pCompressPtr, pImagePtr, w, &BytesInLine);  

   		pCompressPtr += BytesInLine; // ̹   ؼ  ޸  
 		pImagePtr    += w; //  о  ̹ ޸ 
    }   

	size = pCompressPtr - pTempCompress;// ̹  ޸  
	pRetCompress = new WORD[ size];     //   ̹  ޸ 

	Memcpy16Bit( pRetCompress, pTempCompress, size);
	*pNumPixels = size; 

	SAFE_DELETE_ARRAY( pTempCompress); 
	return pRetCompress;
}
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: LLECompressSingleLine16Bit ( WORD* pCompress, WORD* pImage, int width, int* BytesInLine) const
{
	assert( pCompress);
	assert( pImage);
	assert( BytesInLine);

	WORD*  ptr   = pCompress + 1;// ù Ʈ  ٸ  ° Ǿ . 	
	int NumBytes = 1;
                                
 	int count = CountRuns16Bit( pImage, width);
	*pCompress = ( WORD ) count; //  Ʈ  Ѵ.

	if ( count == 0)             //   ȼ  ÷Ű  ä  ̴.
	{
		*BytesInLine = 1;        //  Űµ 1Ʈ ҿǾ.
		return;
	}
	if (count == 1)              //  ÷Ű  ȼ  ̴.
	{                            // ̹    Ѵ.
		Memcpy16Bit(ptr, pImage, width);
		*BytesInLine = width + 1;
		return;
	}
    // ÷Ű   ȼ ̹ȼ   ̴.
	// count == 2 : ÷Ű | Ϲݰ 
	// count == 3 : ÷Ű | Ϲݰ | ÷Ű + (Ϲݰ) ..... 
    while ( --count > 0)
	{
   		int c   = Count0sInAnArray16Bit( pImage, width);
     	*ptr++  = ( WORD ) c; // ÷Ű c ݺǾ. 
   		width  -= c;          //   WORD ޸   
		pImage += c;		  //   ޸ ġ, ÷Ű ʰ ŵѴ.
		NumBytes++;		      //  ޸ ιƮ    
        
   		int l   = CountNon0sInAnArray16Bit( pImage, width);
  		*ptr++  = ( WORD ) l; // Ϲ ÷   
		NumBytes++;		      
    	Memcpy16Bit( ptr, pImage, l);
   		ptr +=  l; 	
		NumBytes += l;		
   		pImage += l;  				
  		width -= l;       	
    }
	*BytesInLine = NumBytes;// ּҰ  
}
///////////////////////////////////////////////////////////////////////////////
int cGraphic :: Count0sInAnArray16Bit( WORD* pImage, int num) const
{
	assert( pImage);

	int count = 0;
    while(( *pImage == m_wColorKey) && ( count < num))
    { count++; pImage++;}
    
    return count;
}
/////////////////////////////////////////////////////////////////////////////// 
int cGraphic :: CountNon0sInAnArray16Bit( WORD* pImage, int num) const
{
	assert( pImage);

	int count = 0;
    while(( *pImage != m_wColorKey) && ( count < num))
    { pImage++; count++;}

    return count;
}
///////////////////////////////////////////////////////////////////////////////
int cGraphic :: CountRuns16Bit( WORD* pImage, int num) const
{
	assert( pImage);

	int w = 0, count = 0;
	while( w < num)
	{
		int r = Count0sInAnArray16Bit( pImage, num - w);
		w += r;
		if ( w == num) break;//   ÷Ű  ä ִ. 
		pImage += r;

		int g = CountNon0sInAnArray16Bit( pImage, num - w);
		w += g;
		pImage += g;

		if( count == 0) 
		{
			count = 1;//  ȼ Ϲݰ  ִ.
			if ( w == num && !r) break;// r== 0 ϶  ο ÷Ű ִ ȼ̾.
		}			
		++count;
		if ( w == num) break;//   бⰡ .
	}
	return count;
}
///////////////////////////////////////////////////////////////////////////////
// ŸũƮ ̽  ׸  ÷ ٲ ִ...
///////////////////////////////////////////////////////////////////////////////
void cGraphic :: SetBlitFunction( DWORD dwFlag)
{
	switch( dwFlag)
	{
	case DF_NORMAL         : m_pfBlitFunction = Memcpy16Bit;             break;
	case DF_ALPHA_25       : m_pfBlitFunction = Memcpy16Bit25Percent;    break;
	case DF_ALPHA_50       : m_pfBlitFunction = Memcpy16Bit50Percent;    break;
	case DF_ALPHA_75       : m_pfBlitFunction = Memcpy16Bit75Percent;    break;
	case DF_RED            : m_pfBlitFunction = Memcpy16BitRed;          break;
	case DF_BLUE           : m_pfBlitFunction = Memcpy16BitBlue;         break;
	case DF_GREEN          : m_pfBlitFunction = Memcpy16BitGreen;        break;
	case DF_SHADOW         : m_pfBlitFunction = Memcpy16BitShadow;       break;
	case DF_SLOPED_SHADOW  : m_pfBlitFunction = Memcpy16BitSlopedShadow; break;
    case DF_DARKEN         : m_pfBlitFunction = Memcpy16BitDarkened;     break;
	case DF_LIGHTEN        : m_pfBlitFunction = Memcpy16BitLightened;    break;

	default                : m_pfBlitFunction = Memcpy16Bit;
	}

}
///////////////////////////////////////////////////////////////////////////////
//-------------------------------------------------------------------
// Function name	: operator =
// Return type		: cGraphic &cGraphic
// Argument         : cGraphic &cSrc
// Description	    : Ʈ ϴ = ڰ   ׸
// Ų  ־ Ȯ   ϵ ϱ  Ͽ.
//   װ ִ   Ȯ   ˰
//   . ..  Կ  ü
//   ü̱  ݵ ؾѴ... 
//-------------------------------------------------------------------
cGraphic &cGraphic :: operator = (cGraphic &cSrc)
{
	assert(FALSE == IsBadReadPtr(&cSrc, sizeof(cGraphic)));

	// Ͱ  ʱȭ Ȱ Ȯ Ѵ
	Clear();

	// ⺻ ʹ  ʱⰪ ״ 
	m_dwFlag		         = cSrc.m_dwFlag;
	m_wNumPixels	         = cSrc.m_wNumPixels;
	m_pfBlitFunction         = cSrc.m_pfBlitFunction;
//	m_pGraphicFormat         = cSrc.m_pGraphicFormat;
	m_wColorKey		         = cSrc.m_wColorKey;
	m_Canvas.size.iWidth     = cSrc.m_Canvas.size.iWidth;
	m_Canvas.size.iHeight    = cSrc.m_Canvas.size.iHeight;
	m_Canvas.size.iRealWidth = cSrc.m_Canvas.size.iRealWidth;

	// ͸ Ѵ
	int nImageSize = m_Canvas.size.iWidth * m_Canvas.size.iHeight;
	m_Canvas.pwAddress  = new WORD[nImageSize];
	assert(NULL != m_Canvas.pwAddress);
	assert(FALSE == IsBadWritePtr(m_Canvas.pwAddress, nImageSize));

	assert(NULL != cSrc.GetImagePtr());
	assert(FALSE == IsBadReadPtr(cSrc.GetImagePtr(), nImageSize));
	CopyMemory(m_Canvas.pwAddress, cSrc.GetImagePtr(), sizeof(WORD) * nImageSize);

	if( NULL != cSrc.m_pwScratchPad)
		m_pwScratchPad = m_Canvas.pwAddress;

	return *this;
}
//////////////////////////////////////////////////////////////////////////////////////
// ʿ Ÿ  Ȱؼ ׸ ̴. virtual cGraphicPtr Ѵ.
//////////////////////////////////////////////////////////////////////////////////////
cGraphic* cGraphic :: CreateVirtualGraphic( RECT rc)
{	
	int w  = rc.right - rc.left;
	int h  = rc.bottom - rc.top, th = rc.top;
	int rw = m_Canvas.size.iRealWidth, len;
	WORD* pSrcImage = m_Canvas.pwAddress;

	if( pSrcImage == NULL) return NULL;
	if( rc.left   < 0)     return NULL;
	if( rc.top    < 0)     return NULL;
	if( rc.right  > m_Canvas.size.iWidth)  return NULL;
	if( rc.bottom > m_Canvas.size.iHeight) return NULL;

	cGraphic* pVirtualGraphic = new cGraphic();
	if( m_dwFlag & GRP_COMPRESS)
	{
		pVirtualGraphic->m_dwFlag = GRP_VIRTUAL | GRP_VIRTUAL_COMPRESS;
		while( th--)
		{
			int runs = *pSrcImage++;									
			if( runs == 1){ pSrcImage += rw;} //   ȼ Ϲ ÷ Ǿ ִ.
			else  
			{			
				while( --runs > 0)
				{
					pSrcImage++;	
					len = *pSrcImage++;	
					pSrcImage += len;
				}
			}		
		}
	}
    else 
	{
		pSrcImage += rc.left + rc.top * m_Canvas.size.iRealWidth;
		pVirtualGraphic->m_dwFlag		          = GRP_VIRTUAL;
	}

	pVirtualGraphic->m_pfBlitFunction         = m_pfBlitFunction;
	pVirtualGraphic->m_wColorKey		      = m_wColorKey;
	pVirtualGraphic->m_Canvas.size.iWidth     = w;
	pVirtualGraphic->m_Canvas.size.iHeight    = h;
    pVirtualGraphic->m_Canvas.size.iRealWidth = rw;
	pVirtualGraphic->m_wNumPixels	          = w * h;
	pVirtualGraphic->m_Canvas.pwAddress       = pSrcImage;
	pVirtualGraphic->m_CenterPt.x             = - rc.left;
	pVirtualGraphic->m_CenterPt.y             = - rc.top;
	
	return pVirtualGraphic;   
}
//----------------------------------------------------------------------------------
// Function name	: cGraphic::CutEdge
// Return type		: void 
// Parameter        : POINT ->  ߽..
// Description	    : ״ ʿ  ߶ 
//  ۾ ʿ信  Ͽ
// by gazette2 : 01-01-16  6:04:27
//----------------------------------------------------------------------------------
void cGraphic :: CutEdge( POINT ptRelativeCenter)
{
	WORD *pOldImage = GetImagePtr();
	WORD *pNewImage = NULL;
	WORD wColorKey;

	int left, top, right, bottom;
	int n = 0;

	assert(NULL != pOldImage);
	assert(FALSE == IsBadReadPtr(pOldImage, GetWidth() * GetHeight()));

	// Į Ű Ƿ   ƴ϶   
	// ĮŰ ȴ. ʿ   Լ ڷ Ѱ ޵
	// ؾ Ѵ
	// by gazette2 : 01-01-16  6:43:11
	wColorKey = *pOldImage;

	// ̳ Ʒ   ϰ   ִ.
	// 켱  ٸ    ī͸ Ų 
	//  ī͸ Width    ִ ٱ  ȣ ȴ.
	// ̰ ̹  ޸𸮿 Ǿִٴ  Ʒ
	// Ȯ  ȴ
	// by gazette2 : 01-01-16  6:41:40

	//  
	while(pOldImage[n] == wColorKey) n++;
	top = n / GetWidth() + 1;

	// Ʒ 
	n = GetWidth() * GetHeight() - 1;
	while(pOldImage[n] == wColorKey) n--;
	//  2 ذ 0 Base Indexing̴.
	bottom = GetHeight() - (GetWidth() * GetHeight() - 1 - n) / GetWidth() - 2;
	// bottom = ((GetWidth() * GetHeight()) - n) / GetWidth();

	// Ʒʺ   ũ? ׷  ־ ̴
	assert(top < bottom);
	
	// ̳  쿡    ؾ Ѵ.
	// 켱 ʰ Ʒ ߷ κ ϰ ˻ϸ ǹǷ
	//   ̿ؾ ϰ  ̹  ˻ 
	// Point   ̿Ǿ
	// by gazette2 : 01-01-16  6:49:00

	//  
	left = 0;
	int h;
	
	for(n = 0; n < GetWidth(); n++)
	{
		for(h = top; h <= bottom; h++)
		{
			if( *(WORD *)(pOldImage + (h * GetWidth()) + n) != wColorKey ) 
				goto exit_left;
		}

		left++;
	}

exit_left:
	//  Ű ִ   ̱ 
	// ׸ ִ Ƿ 1 ؾ Ѵ
	// left++;

	assert((left >= 0) && (left < GetWidth()));

	//  
	right = GetWidth() - 1;
	for(n = GetWidth() - 1; n >= 0; n--)
	{
		for(h = bottom; h >= top; h--)
		{
			if( *(WORD *)(pOldImage + (h * GetWidth()) + n) != wColorKey ) 
				goto exit_right;
		}
		right--;
	}

exit_right:
	//  Ű ִ   ̱ 
	// ׸ ִ  Ƿ 1
	// right--;

	assert((right >= 0) && (right <= GetWidth()));

	// 翬    ۾ƾ Ѵ
	assert(left < right);

	int nOldRealWidth = m_Canvas.size.iRealWidth;

	m_Canvas.size.iWidth	 = right - left + 1;
	m_Canvas.size.iHeight	 = bottom - top + 1;
	m_Canvas.size.iRealWidth = m_Canvas.size.iWidth;

	m_wNumPixels		     = m_Canvas.size.iWidth * m_Canvas.size.iHeight;

	//    Ǿ  κи ָ ȴ..
	// 켱  ̹  ޸𸮸 ҴѴ.
	pNewImage = new WORD[m_wNumPixels];
	assert(NULL != pNewImage);
	assert(FALSE == IsBadWritePtr(pNewImage, m_wNumPixels * sizeof(WORD)));

	WORD *pTemp = pNewImage;
	for(n = top; n <= bottom; n++)
	{
		memcpy(pTemp, pOldImage + n * nOldRealWidth + left, m_Canvas.size.iRealWidth * sizeof(WORD));
		pTemp += m_Canvas.size.iRealWidth;
	}

	//  ̹ Ѵ..
	SAFE_DELETE_ARRAY(pOldImage);

	m_Canvas.pwAddress	= pNewImage;
//	if(NULL != m_pwScratchPad)
//		m_pwScratchPad		= m_Canvas.pwAddress;

	// ߽ ؼ Ѵ..
	m_CenterPt.x = ptRelativeCenter.x - left;
	m_CenterPt.y = ptRelativeCenter.y - top;
}

//----------------------------------------------------------------------------------
// Function name	: cGraphic::SetCenterPoint
// Return type		: void 
// Argument         : POINT pt
// Description	    : ߽ Ƿ   ִ. ..
//----------------------------------------------------------------------------------
#ifdef _TOOL_
void cGraphic :: SetCenterPoint(POINT pt)
{
	m_CenterPt = pt;
}
#endif