     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Screen.cpp:
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "Screen.h"
#include "Surface.h"
#include "asm.h"
#include <mmsystem.h>// timeGetTime();

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
cScreen :: cScreen( HWND hWnd, int Width, int Height, int Bpp, SCREEN_MODE sm)
{	
	D3DLIGHT7    light;
	D3DMATERIAL7 mtrl;
  
	Init( hWnd, Width, Height, Bpp, sm);

	if( sm == SM_FULLSCREEN_WINDOW) CreateFullScreen_Window();
	else if( sm == SM_FULLSCREEN)  CreateFullScreen();
	else CreateWindowed();
 
	if( CreateDirect3D( ))
	{
	    // CreateZBuffer();	//  Ʈ ZBuffer  ʿ.	       			  
		D3DUtil_InitMaterial( mtrl, 1.0f, 1.0f, 1.0f );
		m_lpD3DDevice->SetMaterial( &mtrl );

		if( !InitTransform()) Fail( this, "SCREEN_ERR_INITTRANSFORM");
		// Alpe Texture Blending
		// FinalColor = TexelColor * SourceBlendFactor + PixelColor * DestBlendFactor
		m_lpD3DDevice->LightEnable( 0, TRUE);
        m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, TRUE );
		m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_AMBIENT,  0xffffffff);
        m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE); // SouceBlendFactor = 1
		m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ONE); // DestBlendFactor  = 1
		m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );
	
		// Texture Blending : Light Maping with Texture
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE ); 
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1 );
        m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );

		// Texture filtering
		// ؽĸ   ΰ...
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR ); 
		// ؽĸ  Ȯ ΰ...
		m_lpD3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );  			
        m_lpD3DDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE);
	        
		m_lpD3DVertex = new D3DVERTEX[ 4];
		D3DVECTOR vNormal( 0.0f, 0.0f, 1.0f );
        m_lpD3DVertex[ 0] = D3DVERTEX( D3DVECTOR( -1, -1, 0), vNormal, 0, 1 );
	    m_lpD3DVertex[ 1] = D3DVERTEX( D3DVECTOR( -1,  1, 0), vNormal, 0, 0 );
	    m_lpD3DVertex[ 2] = D3DVERTEX( D3DVECTOR(  1, -1, 0), vNormal, 1, 1 );
        m_lpD3DVertex[ 3] = D3DVERTEX( D3DVECTOR(  1,  1, 0), vNormal, 1, 0 );

		m_bInitialized   = true; 
	}	
}
//////////////////////////////////////////////////////////////////////
cScreen :: ~cScreen()
{
    Clear();
}

////////////////////////////////////////////////////////////////////////
void cScreen :: Clear()
{
	SAFE_RELEASE( m_lpDDClipper);
	SAFE_RELEASE( m_lpDDSFront);
	SAFE_RELEASE( m_lpDDSBack);
	SAFE_RELEASE( m_lpDD);	

	SAFE_RELEASE( m_lpD3DDevice);
	SAFE_RELEASE( m_lpD3D);
	SAFE_RELEASE( m_lpDDSZBuffer);
	SAFE_DELETE_ARRAY( m_lpD3DVertex);
}
//////////////////////////////////////////////////////////////////////
void cScreen :: Init( HWND hWnd, int Width, int Height, int Bpp, SCREEN_MODE sm)
{
	m_lpDD                     = NULL;
	m_lpDDClipper              = NULL;
	m_lpDDSBack                = NULL;
	m_lpDDSFront               = NULL;

	m_hWnd                     = hWnd;
	m_ScreenMode               = sm;
	m_bInitialized             = false;
    m_Bpp                      = Bpp;
	m_FrameCount               = 0;
	m_FramePerSecond           = 0;

	m_ScreenCan.size.iWidth    = Width;
	m_ScreenCan.size.iHeight   = Height;

	m_lpDDSZBuffer             = NULL;
	m_lpD3D                    = NULL;
	m_lpD3DDevice              = NULL;
	m_lpD3DVertex              = NULL;

	m_guidDriver               = GUID_NULL;
	m_guidDevice               = IID_IDirect3DHALDevice;

}
//////////////////////////////////////////////////////////////////////////////////
bool cScreen :: CreateWindowed()
{
	DDSURFACEDESC2 ddsd;

	if( FAILED( DirectDrawCreateEx( &m_guidDriver, ( LPVOID*) &m_lpDD, IID_IDirectDraw7, NULL)))
	    return Fail( this, "SCREEN_DDERR_DDCREATE"); 

	// ũ ȼ尡 16Ʈ Ȯ϶....
	if( FAILED( m_lpDD->SetCooperativeLevel( m_hWnd, DDSCL_NORMAL)))
		return Fail( this, "SCREEN_DDERR_SETCOOPERATE");
	
	memset( &ddsd, 0, sizeof( ddsd));	
	ddsd.dwSize         = sizeof(ddsd);
	ddsd.dwFlags        = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSFront, NULL)))
        return Fail( this, "SCREEN_DDERR_CREATEFRONTSUR");

	ddsd.dwFlags        = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;// | DDSCAPS_SYSTEMMEMORY;
	ddsd.dwWidth        = m_ScreenCan.size.iWidth;
	ddsd.dwHeight       = m_ScreenCan.size.iHeight;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSBack, NULL)))
		return Fail( this, "SCREEN_DDERR_CREATEBACKBUFFER");

	if( FAILED( m_lpDD->CreateClipper( 0, &m_lpDDClipper, NULL)))
		return Fail( this, "SCREEN_DDERR_CREATECLIPPER");

	if( FAILED( m_lpDDClipper->SetHWnd( 0, m_hWnd)))
		return Fail( this, "SCREEN_DDCERR_SETHWND");

	if( FAILED( m_lpDDSFront->SetClipper( m_lpDDClipper)))
		return Fail( this, "SCREEN_DDSERR_SETCLIPPER");

	if( !SetColorTypeAndBitMask( m_lpDDSFront))
		return Fail( this, "SCREEN_ERR_SETCOLORTYPEANDBITMASK");

	return true ;
}
///////////////////////////////////////////////////////////////////////
bool cScreen :: CreateFullScreen()
{
	DDSURFACEDESC2 ddsd;
	DDSCAPS2       ddscaps;

	if( FAILED( DirectDrawCreateEx( &m_guidDriver, ( LPVOID*) &m_lpDD, IID_IDirectDraw7, NULL)))
	    return Fail( this, "SCREEN_DDERR_DDCREATE"); 

    int dwFlags = DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT | DDSCL_FULLSCREEN;
	if( FAILED( m_lpDD->SetCooperativeLevel( m_hWnd, dwFlags)))
		return Fail( this, "SCREEN_DDERR_SETCOOPERATE");

	if( FAILED( m_lpDD->SetDisplayMode( m_ScreenCan.size.iWidth, m_ScreenCan.size.iHeight, m_Bpp, 0, 0)))
		return Fail( this, "SCREEN_DDERR_SETDISPLAYMODE");
	
	memset( &ddsd, 0, sizeof( ddsd));
	
	ddsd.dwSize            = sizeof(ddsd);
	ddsd.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | 
		                     DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;//| DDSCAPS_SYSTEMMEMORY;
	ddsd.dwBackBufferCount = 1;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSFront, NULL)))
        return Fail( this, "SCREEN_DDERR_CREATEFRONTSUR");

	memset( &ddscaps, 0, sizeof( ddscaps));
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

	if( FAILED( m_lpDDSFront->GetAttachedSurface( &ddscaps, &m_lpDDSBack)))
		return Fail( this, "SCREEN_DDSERR_GETATTACHEDSURFACE");

	if( !SetColorTypeAndBitMask( m_lpDDSFront))
		return Fail( this, "SCREEN_ERR_SETCOLORTYPEANDBITMASK");
	
	return true;
}
//////////////////////////////////////////////////////////////////////
bool cScreen :: CreateFullScreen_Window()
{
	DDSURFACEDESC2 ddsd;

	if( FAILED( DirectDrawCreateEx( &m_guidDriver, ( LPVOID*) &m_lpDD, IID_IDirectDraw7, NULL)))
	    return Fail( this, "SCREEN_DDERR_DDCREATE"); 

    int dwFlags = DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT | DDSCL_FULLSCREEN;
	if( FAILED( m_lpDD->SetCooperativeLevel( m_hWnd, dwFlags)))
		return Fail( this, "SCREEN_DDERR_SETCOOPERATE");

	if( FAILED( m_lpDD->SetDisplayMode( m_ScreenCan.size.iWidth, m_ScreenCan.size.iHeight, m_Bpp, 0, 0)))
		return Fail( this, "SCREEN_DDERR_SETDISPLAYMODE");
	
	memset( &ddsd, 0, sizeof( ddsd));
	
	ddsd.dwSize            = sizeof(ddsd);
	ddsd.dwFlags           = DDSD_CAPS ;
	ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = 1;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSFront, NULL)))
        return Fail( this, "SCREEN_DDERR_CREATEFRONTSUR");

    ddsd.dwFlags        = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;//| DDSCAPS_SYSTEMMEMORY;
	ddsd.dwWidth        = m_ScreenCan.size.iWidth;
	ddsd.dwHeight       = m_ScreenCan.size.iHeight;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSBack, NULL)))
		return Fail( this, "SCREEN_DDERR_CREATEBACKBUFFER");

	if( !SetColorTypeAndBitMask( m_lpDDSFront))
		return Fail( this, "SCREEN_ERR_SETCOLORTYPEANDBITMASK");
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cScreen :: CreateDirect3D()
{
	if( !m_lpDD) return false;
	if( FAILED( m_lpDD->QueryInterface( IID_IDirect3D7, ( LPVOID* ) &m_lpD3D)))
		return Fail( this, "SCREEN_DDERR_QUERYINTERFACE_D3D");

	while( FAILED( m_lpD3D->CreateDevice( m_guidDevice, m_lpDDSBack, &m_lpD3DDevice)))
	{
		if( m_guidDevice == IID_IDirect3DHALDevice)      m_guidDevice = IID_IDirect3DMMXDevice;	    
		else if( m_guidDevice == IID_IDirect3DMMXDevice) m_guidDevice = IID_IDirect3DRGBDevice;
		else return Fail( this, "SCREEN_DD3DERR_CREATEDEVICE");
	}
	
    D3DVIEWPORT7 vp = { 0, 0, m_ScreenCan.size.iWidth, m_ScreenCan.size.iHeight, 0.0f, 1.0f };

    if( FAILED( m_lpD3DDevice->SetViewport( &vp ) ) )
        return Fail( this, "SCREEN_D3DDERR_SETVIEWPORT");

    return true;
}///////////////////////////////////////////////////////////////////////
bool cScreen :: CreateZBuffer()
{
	DDSURFACEDESC2 ddsd;
	DDPIXELFORMAT  ddpf;
    D3DDEVICEDESC7 d3ddesc;
   
	if( !m_lpD3DDevice) return false;
    if( !m_lpDD)        return false;
	if( !m_lpDDSBack)   return false;

	if( FAILED( m_lpD3DDevice->GetCaps( &d3ddesc )))
		return Fail( this, "SCREEN_D3DDERR_GECAPS");

    // ̽ ZBuffer شٸ.... ZBuffer ʿ.
    if( d3ddesc.dpcTriCaps.dwRasterCaps & D3DPRASTERCAPS_ZBUFFERLESSHSR )
        return true;

	ddpf.dwSize = 0;	
    if( FAILED( m_lpD3D->EnumZBufferFormats( m_guidDevice, EnumZBufferCallback, ( LPVOID) &ddpf)))
		return Fail( this, "SCREEN_D3DERR_ENUMZBUFFERFORMATS");

	if( ddpf.dwSize == 0)
        return Fail( this, "SCREEN_ERR_CANNOT_FIND_ZBUFFER");

	ddsd.dwSize = sizeof( ddsd);
	if( FAILED(m_lpDDSBack->GetSurfaceDesc( &ddsd))) 
		return Fail( this, "SCREEN_D3DSERR_GETSURFACEDESC");

	ddsd.dwFlags        = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth        = m_ScreenCan.size.iWidth;
	ddsd.dwHeight       = m_ScreenCan.size.iHeight;
	memcpy( &ddsd.ddpfPixelFormat, &ddpf, sizeof( DDPIXELFORMAT));

	if( IsEqualIID( m_guidDevice, IID_IDirect3DHALDevice))
		 ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

	if( FAILED( m_lpDD->CreateSurface( &ddsd, &m_lpDDSZBuffer, NULL)))
		return Fail( this, "SCREEN_DDSERR_CREATESURFACE_ZBUFFER");
		
	if( FAILED( m_lpDDSBack->AddAttachedSurface( m_lpDDSZBuffer)))
		return Fail( this, "SCREEN_DDSERR_ADDATTACHEDSURFACE");

	if( FAILED( m_lpD3DDevice->SetRenderTarget( m_lpDDSBack, 0)))
		return Fail( this, "SCREEN_DD3DERR_SETRENDERTARGET");

	return true;
}
///////////////////////////////////////////////////////////////////////
bool cScreen :: CreateLight( D3DLIGHTTYPE ltType, float x, float y, float z )
{
	D3DLIGHT7 light;
	D3DUtil_InitLight( light, ltType, 0.5f, 0.1f, 1.0f);

    light.dvPosition.x = x;
	light.dvPosition.y = y;
	light.dvPosition.z = z;
   
    // Set the light
	if( FAILED( m_lpD3DDevice->SetLight( 0, &light )))
		return Fail( this, "SCREEN_D3DERR_SETLIGHT");

	return true;
}
///////////////////////////////////////////////////////////////////////
void cScreen :: SetLightPosition( int LightID, float x, float y, float z)
{
	LPD3DLIGHT7 pLight = NULL;

	m_lpD3DDevice->GetLight( LightID, pLight);
	pLight->dvPosition = D3DVECTOR( x, y, z );
}
///////////////////////////////////////////////////////////////////////
void __fastcall cScreen :: Flip( HWND hWnd)
{
	assert( hWnd);
	HRESULT ret;

	if( m_ScreenMode == SM_FULLSCREEN_WINDOW)
	{
		ret = m_lpDDSFront->Blt( NULL, m_lpDDSBack, NULL, DDBLT_WAIT, NULL);
		if( ret == DDERR_WASSTILLDRAWING) return;
		if( ret == DDERR_SURFACELOST) m_lpDD->RestoreAllSurfaces();	
	}

	else if( m_ScreenMode == SM_FULLSCREEN)
	{
		ret = m_lpDDSBack->GetFlipStatus( DDGFS_ISFLIPDONE);
		if( ret == DDERR_WASSTILLDRAWING) return;
	
		ret = m_lpDDSFront->Flip( m_lpDDSBack, DDFLIP_WAIT); 
		if( ret == DDERR_SURFACELOST) m_lpDD->RestoreAllSurfaces();	
	}   
    else
	{
	    RECT Window;
        ::GetClientRect(  hWnd,   &Window);	
        ::ClientToScreen( hWnd, ( LPPOINT) &Window );
        ::ClientToScreen( hWnd, ( LPPOINT) &Window + 1 );
		
		if( FAILED( m_lpDDClipper->SetHWnd( 0, hWnd)))
			Fail( this, "SCREEN_DDCERR_SETHWND");
		    
		ret = m_lpDDSFront->Blt( &Window, m_lpDDSBack, NULL, DDBLT_WAIT, NULL);
		if( ret == DDERR_WASSTILLDRAWING) return;
        if( ret == DDERR_SURFACELOST) m_lpDD->RestoreAllSurfaces();	
	}

}
//////////////////////////////////////////////////////////////////////////
bool cScreen :: InitTransform()
{
	D3DMATRIX mat;
    D3DUtil_SetIdentityMatrix( mat);
			
	D3DMATRIX matWorld = mat;
	if( FAILED( m_lpD3DDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld )))
		return Fail( this, "TEXTURE_D3DDERR_SETTRANSFORM_WORLD");

	D3DMATRIX matView = mat;
	matView._43 = 20.0f; // 20.0f;
	if( FAILED( m_lpD3DDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView )))
		return Fail( this, "TEXTURE_D3DDERR_SETTRANSFORM_VIEW");

	D3DMATRIX matProj = mat;
	matProj._11 =  2.0f;
	matProj._22 =  2.0f;
	matProj._34 =  1.0f;
	matProj._43 = -1.0f;
	matProj._44 =  0.0f;

	if( FAILED( m_lpD3DDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj )))
		return Fail( this, "TEXTURE_D3DDERR_SETTRANSFORM_PROJECT");

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool cScreen :: RenderBegin()
{
//  if( FAILED( m_lpD3DDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER, 0L, 1.0f, 0L))) // | D3DCLEAR_ZBUFFER
// 	    return Fail( this, "SCREEN_D3DDERR_CLEAR");
   
    if( FAILED( m_lpD3DDevice->BeginScene()))
		return Fail( this, "SCREEN_D3DDERR_BEGINSCENE");

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool cScreen :: RenderEnd()
{
	if( FAILED( m_lpD3DDevice->EndScene()))
		return Fail( this, "SCREEN_D3DDERR_ENDSCENE");

	return true;
}
////////////////////////////////////////////////////////////////////////
CANVASPtr cScreen :: PrepareFrame()
{
	if( !m_bInitialized) return NULL;
	if( !m_lpDDSBack) return NULL;

	DDSURFACEDESC2 ddsd;
 	ZeroMemory ( &ddsd, sizeof ( DDSURFACEDESC2 ));
 	ddsd.dwSize = sizeof ( ddsd);
 	int result;
 	do{
   		result = m_lpDDSBack->Lock ( NULL, &ddsd, 
				 DDLOCK_SURFACEMEMORYPTR, NULL);
    }while( result != DD_OK );

	m_lpDDSBack->Unlock( NULL );
	m_ScreenCan.pwAddress       = ( WORD* ) ddsd.lpSurface;
	m_ScreenCan.size.iRealWidth = ddsd.lPitch / 2;
    // Memset16Bit( m_ScreenCan.pwAddress, 0, m_ScreenCan.size.iRealWidth * m_ScreenCan.size.iHeight);

	return &m_ScreenCan;
}
////////////////////////////////////////////////////////////////////////
void cScreen :: RestoreAllSurface()
{
	if( !m_lpDD) return;
	m_lpDD->RestoreAllSurfaces();
}
//////////////////////////////////////////////////////////////////////////
bool cScreen :: DrawRect( RECT rc, HDC hdc, HPEN hGreenPen)
{
	HPEN  hOldPen;
	
    hOldPen = ( HPEN ) SelectObject( hdc, hGreenPen);
    SelectObject( hdc, GetStockObject( NULL_BRUSH));   
    Rectangle( hdc , rc.left, rc.top, rc.right, rc.bottom);
    SelectObject( hdc, hOldPen); 
	
	return true;
}
//////////////////////////////////////////////////////////////////////////
bool cScreen :: SetColorTypeAndBitMask( LPDIRECTDRAWSURFACE7 lpdds)
{
	assert( lpdds);

	DDSURFACEDESC2 ddsd;
	if( !lpdds) return Fail( this, "SCREEN_ERR_SETCOLORTYPEANDBITMASK");

	memset( &ddsd, 0, sizeof( ddsd));
	ddsd.dwSize  = sizeof ( ddsd);
  	ddsd.dwFlags = DDSD_PIXELFORMAT;
	if( FAILED( lpdds->GetSurfaceDesc( &ddsd)))
         return Fail( this,"SCREEN_DDSERR_PIXELFORMAT_NOT_AVAILABLE");
		
    m_GraphicFormat.dwRBitMask = ( int) ddsd.ddpfPixelFormat.dwRBitMask;
    m_GraphicFormat.dwGBitMask = ( int) ddsd.ddpfPixelFormat.dwGBitMask;
    m_GraphicFormat.dwBBitMask = ( int) ddsd.ddpfPixelFormat.dwBBitMask;
	 	
	int g = m_GraphicFormat.dwGBitMask >> 5;// assumes 5 for red, g = 0x000001111100000 or 0x0000011111100000
	
	if( g == 0x1F)      m_GraphicFormat.ColorType = _5x5x5_;   // g = 31, 0x0000011111
	else if( g == 0x3F) m_GraphicFormat.ColorType = _5x6x5_;   // g = 63, 0x00000111111 
	
	return true;
}
//////////////////////////////////////////////////////////////////////////
void cScreen :: WriteFrameCount()
{
	DWORD time = timeGetTime();// get the current millisec
	m_FrameCount++; 

	if( time - m_TimeLast >= 1000)
	{	
		m_TimeLast = time;// update time
	    m_FramePerSecond = m_FrameCount;
		m_FrameCount = 0;
	}
	char num[ 15];
	_itoa( m_FramePerSecond, num, 10); // 10 

	string Frame( "ʴ   : ");
	Frame += string( num);
    WriteText( 32, 32, Frame.c_str());

}
//////////////////////////////////////////////////////////////////////////
void cScreen :: WriteText( int x, int y, LPCSTR String)
{
	HDC hdc;
    LPDIRECTDRAWSURFACE7 lpDDS= m_lpDDSBack;//m_pScreenSurface->GetDDSurface();
	if( FAILED( lpDDS->GetDC( &hdc)))
	    Fail( this, "SCREEN_DDERR_GETDC_FORTEXT");

	SetBkMode (hdc, TRANSPARENT);
    SetTextColor (hdc, RGB( 255, 255, 255));
    TextOut( hdc, x, y, String, strlen( String));
    lpDDS->ReleaseDC (hdc);
}
//////////////////////////////////////////////////////////////////////////
// Callback Function
//////////////////////////////////////////////////////////////////////////
HRESULT WINAPI EnumZBufferCallback( LPDDPIXELFORMAT lpDDPixFmt, LPVOID lpContext)
{
    DDPIXELFORMAT* pddpf = ( DDPIXELFORMAT* ) lpContext;
	if( lpDDPixFmt->dwFlags == DDPF_ZBUFFER)
	{
		memcpy( pddpf, lpDDPixFmt, sizeof( DDPIXELFORMAT) );
		return D3DENUMRET_CANCEL;
	}
	return D3DENUMRET_OK;
}

//////////////////////////////////////////////////////////////////////////




