     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// terrain.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "terrain.h"

extern string g_sTerrainsFolder; 
///////////////////////////////////////////////////////////////////////////////
void cTerrain_Type :: Clear()
{
    SAFE_DELETE( m_pTerrains);
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain_Type :: LoadGraphicFromDirectory( string sPath)
{   // sPath = ...../grass_soil
	m_iPatternNum = CountFolder( sPath);
	if( m_iPatternNum == 0) Fail( this, "TERRAIN_TYPE_ERR_NO_SUBFOLDER");

	m_pTerrains = new cGraphic_Sequence < cGraphic > [ m_iPatternNum];
	for( int i = 0; i < m_iPatternNum; i++)
	{
       DWORD dwFlag = GetGraphicFlag( i);
	   if( !m_pTerrains[ i].LoadGraphicFromDirectory( sPath, dwFlag))
	       return Fail( this, "TERRAIN_TYPE_ERR_LOADGRPHICFROMDIRECTORY");	
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
cGraphic* cTerrain_Type :: GetGraphic( TERRAIN_FLAG tFlag)
{
	assert( m_pTerrains);	

	if( !m_pTerrains) return NULL; 
	return ( cGraphic* ) m_pTerrains[ tFlag.uPattern].GetGraphic( tFlag.uId);
}
///////////////////////////////////////////////////////////////////////////////
int cTerrain_Type :: GetGraphicFlag( int i)
{
	switch( i)
	{
	case TP_TILE_SPRITE: return GRP_SPRITE;
	case TP_SPRITE     : return GRP_SPRITE; // 0  Ʈ..

    default            : return GRP_TILE;
	}
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain_Type :: Load( cFile& file)
{
	assert( file.Status() == 0 );	

	if( file.Status() != 0) return Fail( this, "TERRAINGRPAHIC_ERR_LOAD");
	for( int i = 0; i < m_iPatternNum; i++)
	{
		if( !m_pTerrains[ i].Load( file)) 
			return Fail( this, "TERRAINGROUP_ERR_LOAD");
	}
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// Ȯڴ trn
///////////////////////////////////////////////////////////////////////////////
bool cTerrain_Type :: Save( cFile& file)
{
    assert( file.Status() == 0 );

	if( file.Status() != 0) return Fail( this, "TERRAINGRPAHIC_ERR_SAVE");
	for( int i = 0; i < m_iPatternNum; i++)
	{
		if( !m_pTerrains[ i].Save( file)) 
			return Fail( this, "TERRAINGROUP_ERR_SAVE");
	}
	return true;
}
///////////////////////////////////////////////////////////////////////////////
int cTerrain_Type :: CountFolder( string sFolderName)
{   // sFolderName = ..../head/

	string sSubPath;
   	int    Count = 0;
    char   cwd[ 255];
	 _getcwd( cwd, 255);//  ۾ 丮 
	
    while( true)
	{
		char num[ 15];
		itoa( Count, num, 10);

		sSubPath  = sFolderName;  // ..../head/
		sSubPath += string( num); // ..../head/0
		
		if( _chdir( sSubPath.c_str()) == 0) Count++;
	    else break;
	}
	 
	_chdir( cwd);
    return Count;
}
///////////////////////////////////////////////////////////////////////////////
// cTerrain_Mgr
///////////////////////////////////////////////////////////////////////////////
void cTerrain_Mgr :: Clear()
{
	cTerrain_TypePtr pType;
	int size = m_mapTerrainType.size();
    mapTerrainType :: iterator iter = m_mapTerrainType.begin();

	for( int i = 0; i < size; i++)
	{
	   pType = ( iter++)->second;
	   SAFE_DELETE( pType);
	} 
	
	m_mapTerrainType.clear();
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain_Mgr :: LoadTerrainsFromStage( int iTType)
{
	cTerrain_TypePtr pType = new cTerrain_Type();

	string sFilePath  = g_sTerrainsFolder;
	sFilePath        += "/";
	sFilePath        += GetTypeName( iTType);
	sFilePath        += ".trn";

	if( !Load( pType, sFilePath))
	    return Fail( this, "TERRAIN_MGR_ERR_LOADTERRAINFROMSTAGE");
 
 	InsertTerrainType( iTType, pType);
	return true;
}
///////////////////////////////////////////////////////////////////////////////
void cTerrain_Mgr :: InsertTerrainType( int iTType, cTerrain_TypePtr pType)
{
	if( iTType >= TT_NUM || !pType) return;
    m_mapTerrainType[ iTType] = pType;
}
///////////////////////////////////////////////////////////////////////////////
void cTerrain_Mgr :: EraseTerrainType( int iTType) 
{
	if( iTType >= TT_NUM) return;
	m_mapTerrainType.erase( iTType);
}   
///////////////////////////////////////////////////////////////////////////////
cTerrain_TypePtr cTerrain_Mgr :: FindTerrainType( int iTType) 
{
	mapTerrainType :: iterator iter = m_mapTerrainType.find( iTType);
    return ( *iter).second;
}
///////////////////////////////////////////////////////////////////////////////
int cTerrain_Mgr :: GetDefaultTerrainType()
{
	return 1;
}
///////////////////////////////////////////////////////////////////////////////
string cTerrain_Mgr :: GetTypeName( int iTType)
{
	if( iTType == TT_GRASS_SOIL)     return string( "Grass_Soil");
	if( iTType == TT_GRASS_FOREST)   return string( "Grass_Forest");
	if( iTType == TT_GRASS_WATER)    return string( "Grass_Water");
	if( iTType == TT_GRASS_DESERT)   return string( "Grass_Desert");

	return string();
}
///////////////////////////////////////////////////////////////////////////////
cGraphic* cTerrain_Mgr :: GetGraphic( TERRAIN_FLAG tFlag)
{
    cTerrain_TypePtr pType = FindTerrainType( tFlag.uType);
	
	if( !pType) return NULL;
	return pType->GetGraphic( tFlag);
}
///////////////////////////////////////////////////////////////////////////////
// cTerrain
///////////////////////////////////////////////////////////////////////////////
cTerrain :: cTerrain()
{
	memset( &m_TerrainFlag, 0, sizeof( DWORD));
	m_pGraphic = NULL;
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain :: Draw( int x, int y)
{
	assert( m_pGraphic);

	if( !m_pGraphic) return false;
	return m_pGraphic->Draw( x, y);
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain :: DrawAt( CANVASPtr pCanvas, int x, int y)
{
	assert( NULL != pCanvas );
	assert( FALSE == IsBadWritePtr( pCanvas->pwAddress, pCanvas->size.iRealWidth * pCanvas->size.iHeight));
	assert( m_pGraphic );

	if( !m_pGraphic) return false;
	return m_pGraphic->DrawAt( pCanvas, x, y);
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain :: Save( cFile& file)
{
	assert(  file.Status() != 0);
	if( file.Status() != 0) return Fail( this, "TERRAIN_ERR_SAVE_INVALID_HFILE");

	file.Write( &m_TerrainFlag, sizeof( DWORD)); 
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cTerrain :: Load( cFile& file)
{
	assert(  file.Status() != 0);
    if( file.Status() != 0) return Fail( this, "TERRAIN_ERR_LOAD_INVALID_HFILE");

	file.Read( &m_TerrainFlag, sizeof( DWORD)); 
	return true;
}
///////////////////////////////////////////////////////////////////////////////
vector < cGraphicPtr >  cTerrain :: CreateVirtualGraphics()
{
	RECT rc;
	vector < cGraphicPtr > vVGraphics;
	cGraphicPtr pVGraphic;

	for( int i = 0; i < TILE_XNUM; i++)
	{
		for( int j = 0; j < TILE_YNUM; j++)
		{
            SetRect( &rc, i * TILE_WIDTH, j * TILE_HEIGHT, ( i + 1) * TILE_WIDTH, ( j + 1) * TILE_HEIGHT);
			pVGraphic = m_pGraphic->CreateVirtualGraphic( rc);

			vVGraphics.push_back( pVGraphic);         
		}
	}

	return vVGraphics;
}
