// LeftBar.cpp : implementation file
//

#include "stdafx.h"
#include "MapEdit.h"
#include "LeftBar.h"

#include "MapEditDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLeftBar

CLeftBar::CLeftBar()
{
}

CLeftBar::~CLeftBar()
{
}


BEGIN_MESSAGE_MAP(CLeftBar, CDynCtrlBar)
	//{{AFX_MSG_MAP(CLeftBar)
	ON_WM_ERASEBKGND()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLeftBar message handlers

BOOL CLeftBar::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	return CDynCtrlBar::PreCreateWindow(cs);
}

void CLeftBar::OnDraw(CDC *pDC)
{
	CMapEditDoc *pDoc = GetDocument();

	const STerrainManager *pManager = pDoc->GetTerrainManager();
	const STerrainType *pType = pManager->GetType(0);

	STerrain::ID id;
	id.nType = 0;
	for (id.nPattern = 0;id.nPattern < pType->GetPatternCount();id.nPattern++)
	{
		const STerrainPattern *pPattern = pType->GetPattern(id.nPattern);
		for (id.nID = 0;id.nID < pPattern->GetTerrainCount();id.nID++)
			DrawTerrain(pDC, id);
	}
}

CMapEditDoc *CLeftBar::GetDocument()
{
	ASSERT(AfxGetMainWnd() != NULL);
	return (CMapEditDoc *) ((CFrameWnd *) AfxGetMainWnd())->GetActiveDocument();
}

void CLeftBar::GetRect(const STerrain::ID &id, CRect *pRect)
{
	ASSERT(id.nType == 0);
	pRect->top = id.nPattern * (64 + 4) + 4;
	pRect->bottom = pRect->top + 64;
	pRect->left = id.nID * (96 + 4) + 4;
	pRect->right = pRect->left + 96;
}

BOOL CLeftBar::OnEraseBkgnd(CDC* pDC) 
{
	CRect rect;
	GetClientRect(&rect);
	pDC->FillSolidRect(&rect, GetSysColor(COLOR_WINDOW));
	return TRUE;
}

void CLeftBar::DrawTerrain(CDC *pDC, const STerrain::ID &id)
{
	CMapEditDoc *pDoc = GetDocument();
	const STerrainManager *pManager = pDoc->GetTerrainManager();
	const STerrainType *pType = pManager->GetType(id.nType);
	const STerrainPattern *pPattern = pType->GetPattern(id.nPattern);
	const STerrain *pTerrain = pPattern->GetTerrain(id.nID);

	CRect rect;
	GetRect(id, &rect);

	CRect rcBack = rect;
	rcBack.InflateRect(2, 2, 2, 2);
	if (id == m_idSelected)
		pDC->FillSolidRect(&rcBack, GetSysColor(COLOR_HIGHLIGHT));
	pTerrain->DrawBitmap(*pDC, rect.left, rect.top);
}

int CLeftBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDynCtrlBar::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetScrollSizes(MM_TEXT, CSize(TR_WIDTH * 8, TR_HEIGHT * 22));

	m_idSelected.nType = 0;
	m_idSelected.nPattern = 0;
	m_idSelected.nID = 0;
	return 0;
}
