#ifndef __COMMDEF_H__
#define __COMMDEF_H__

#define inrange(N, MIN, MAX) ((N) >= (MIN) && (N) < (MAX))
#define div(N1, N2) ((N1) / (N2) + ((N1) % (N2) < (N2) - ((N1) % (N2)) ? 0 : 1))
#define countof(ARR) (int) (sizeof(ARR) / sizeof(ARR[0]))

#define PI 3.1415926535898
#define ALIGN(A, N) (((N) + ((A) - 1)) & ~((A) - 1))
#define ALIGNWORD(N) ALIGN(2, N)
#define ALIGNLONG(N) ALIGN(4, N)

template <class T>
inline void swap(T &t1, T &t2)
{
	T t = t1;
	t1 = t2;
	t2 = t;
}

inline BOOL IsValidAddress(LPVOID lp, UINT nSize)
{
	return !IsBadReadPtr(lp, nSize) && !IsBadWritePtr(lp, nSize);
}

inline BOOL IsValidReadOnlyAddress(LPCVOID lp, UINT nSize)
{
	return !IsBadReadPtr(lp, nSize);
}

template <class T>
inline BOOL IsValidAddress(T *pt, UINT nCount = 1)
{
	return !IsBadReadPtr(pt, sizeof(T) * nCount) && !IsBadWritePtr(pt, sizeof(T) * nCount);
}

template <class T>
inline BOOL IsValidReadOnlyAddress(const T *pt, UINT nCount = 1)
{
	return !IsBadReadPtr(pt, sizeof(T) * nCount);
}

inline BOOL IsValidString(LPCSTR lpsz)
{
	return !IsBadStringPtrA(lpsz, -1);
}

inline BOOL IsValidString(LPCWSTR lpsz)
{
	return !IsBadStringPtrW(lpsz, -1);
}

inline BOOL IsValidCode(LPCVOID lp)
{
	return !IsBadCodePtr((FARPROC) lp);
}

inline void SendCommandMessage(HWND hParentWnd, HWND hChildWnd, UINT nCode)
{
	UINT nID = GetWindowLong(hChildWnd, GWL_ID);
	SendMessage(hParentWnd, WM_COMMAND, MAKELONG(nID, nCode), (LPARAM) hChildWnd);
}

inline void PostCommandMessage(HWND hParentWnd, HWND hChildWnd, UINT nCode)
{
	UINT nID = GetWindowLong(hChildWnd, GWL_ID);
	PostMessage(hParentWnd, WM_COMMAND, MAKELONG(nID, nCode), (LPARAM) hChildWnd);
}

inline void SendNotifyMessage(HWND hParentWnd, HWND hChildWnd, UINT nCode, NMHDR *pNMHDR)
{
	pNMHDR->hwndFrom = hChildWnd;
	pNMHDR->idFrom = GetWindowLong(hChildWnd, GWL_ID);
	pNMHDR->code = nCode;
	SendMessage(hParentWnd, WM_NOTIFY, pNMHDR->idFrom, (LPARAM) pNMHDR);
}

#ifdef __AFXWIN_H__

inline void SendCommandMessage(CWnd *pParentWnd, CWnd *pChildWnd, UINT nCode)
{
	UINT nID = ::GetWindowLong(pChildWnd->m_hWnd, GWL_ID);
	pParentWnd->SendMessage(WM_COMMAND, MAKELONG(nID, nCode), (LPARAM) pChildWnd->m_hWnd);
}

inline void PostCommandMessage(CWnd *pParentWnd, CWnd *pChildWnd, UINT nCode)
{
	UINT nID = ::GetWindowLong(pChildWnd->m_hWnd, GWL_ID);
	pParentWnd->SendMessage(WM_COMMAND, MAKELONG(nID, nCode), (LPARAM) pChildWnd->m_hWnd);
}

inline void SendNotifyMessage(CWnd *pParentWnd, CWnd *pChildWnd, UINT nCode, NMHDR *pNMHDR)
{
	pNMHDR->hwndFrom = pChildWnd->m_hWnd;
	pNMHDR->idFrom = ::GetWindowLong(pChildWnd->m_hWnd, GWL_ID);
	pNMHDR->code = nCode;
	pParentWnd->SendMessage(WM_NOTIFY, pNMHDR->idFrom, (LPARAM) pNMHDR);
}

#endif // __AFXWIN_H__

template <class T>
class SRef;
template <class T>
class SHeap;
template <class T>
class SArrHeap;

template <class T>
class SPtr
{
public:
	SPtr()
	{
		m_pt = NULL;
	}
	SPtr(T *pt)
	{
		m_pt = pt;
	}
	~SPtr()
	{
		if (m_pt != NULL)
			delete m_pt;
	}

public:
	SPtr<T> &operator =(T *pt)
	{
		if (m_pt != NULL)
			delete m_pt;
		m_pt = pt;
		return *this;
	}
	operator T *()
	{
		return m_pt;
	}
	operator const T *() const
	{
		return m_pt;
	}
	T *operator ->()
	{
		ASSERT(m_pt != NULL);
		return m_pt;
	}
	const T *operator ->() const
	{
		ASSERT(m_pt != NULL);
		return m_pt;
	}

private:
	T *m_pt;

	SPtr(const SPtr<T> &ptr);
	SPtr(const SRef<T> &ref);
	SPtr(const SHeap<T> &hp);
	SPtr(const SArrHeap<T> &hp);
	SPtr<T> &operator =(const SPtr<T> &ptr);
	SPtr<T> &operator =(const SRef<T> &ref);
	SPtr<T> &operator =(const SHeap<T> &hp);
	SPtr<T> &operator =(const SArrHeap<T> &hp);
};

template <class T>
class SRef
{
public:
	SRef()
	{
		m_pRef = NULL;
	}
	SRef(const SRef<T> &ref)
	{
		if (ref.m_pRef == NULL)
			m_pRef = NULL;
		else
		{
			m_pRef = ref.m_pRef;
			ref.m_pRef->nCount++;
		}
	}
	SRef(T *pt)
	{
		if (pt == NULL)
			m_pRef = NULL;
		else
		{
			m_pRef = new REF;
			m_pRef->pt = pt;
			m_pRef->nCount = 1;
		}
	}
	~SRef()
	{
		if (m_pRef != NULL && --m_pRef->nCount == 0)
		{
			delete m_pRef->pt;
			delete m_pRef;
		}
	}

public:
	SRef<T> &operator =(const SRef<T> &ref)
	{
		if (m_pRef != NULL && --m_pRef->nCount == 0)
		{
			delete m_pRef->pt;
			delete m_pRef;
		}
		if (ref.m_pRef == NULL)
			m_pRef = NULL;
		else
		{
			m_pRef = ref.m_pRef;
			ref.m_pRef->nCount++;
		}
		return *this;
	}
	SRef<T> &operator =(T *pt)
	{
		if (m_pRef != NULL && --m_pRef->nCount == 0)
		{
			delete m_pRef->pt;
			delete m_pRef;
		}
		if (pt == NULL)
			m_pRef = NULL;
		else
		{
			m_pRef = new REF;
			m_pRef->pt = pt;
			m_pRef->nCount = 1;
		}
		return *this;
	}
	operator T *()
	{
		return m_pRef == NULL ? NULL : m_pRef->pt;
	}
	operator const T *() const
	{
		return m_pRef == NULL ? NULL : m_pRef->pt;
	}
	T *operator ->()
	{
		ASSERT(m_pRef != NULL);
		return m_pRef->pt;
	}
	const T *operator ->() const
	{
		ASSERT(m_pRef != NULL);
		return m_pRef->pt;
	}

private:
	struct REF
	{
		T *pt;
		int nCount;
	} *m_pRef;

	SRef(const SPtr<T> &ptr);
	SRef(const SHeap<T> &hp);
	SRef(const SArrHeap<T> &hp);
	SRef<T> &operator =(const SPtr<T> &ptr);
	SRef<T> &operator =(const SHeap<T> &hp);
	SRef<T> &operator =(const SArrHeap<T> &hp);
};

template <class T>
class SHeap
{
public:
	SHeap()
	{
		m_pt = NULL;
	}
	SHeap(T *pt)
	{
		m_pt = pt;
	}
	~SHeap()
	{
		if (m_pt != NULL)
			delete [] m_pt;
	}

public:
	T *Detach()
	{
		ASSERT(m_pt != NULL);
		T *pt = m_pt;
		m_pt = NULL;
		return pt;
	}
	SHeap<T> &operator =(T *pt)
	{
		m_pt = pt;
		return *this;
	}
	operator T *()
	{
		return m_pt;
	}
	operator const T *() const
	{
		return m_pt;
	}

private:
	T *m_pt;

	SHeap(const SHeap<T> &hp);
	SHeap(const SArrHeap<T> &hp);
	SHeap<T> &operator =(const SHeap<T> &hp);
	SHeap<T> &operator =(const SArrHeap<T> &hp);
};

template <class T>
class SArrHeap
{
public:
	SArrHeap()
	{
		m_pt = NULL;
	}
	SArrHeap(T *pt)
	{
		m_pt = pt;
	}
	~SArrHeap()
	{
		if (m_pt != NULL)
			delete [] m_pt;
	}

public:
	T *Detach()
	{
		ASSERT(m_pt != NULL);
		T *pt = m_pt;
		m_pt = NULL;
		return pt;
	}
	SArrHeap<T> &operator =(T *pt)
	{
		m_pt = pt;
		return *this;
	}
	operator T *()
	{
		return m_pt;
	}
	operator const T *() const
	{
		return m_pt;
	}

private:
	T *m_pt;

	SArrHeap(const SHeap<T> &hp);
	SArrHeap(const SArrHeap<T> &hp);
	SArrHeap<T> &operator =(const SHeap<T> &hp);
	SArrHeap<T> &operator =(const SArrHeap<T> &hp);
};

#endif // __COMMDEF_H__
