// DynCtrlBar.cpp : implementation file
//

#include "stdafx.h"
#include "DynCtrlBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDynCtrlBar

CDynCtrlBar::CDynCtrlBar()
{
}

CDynCtrlBar::~CDynCtrlBar()
{
}


BEGIN_MESSAGE_MAP(CDynCtrlBar, CControlBar)
	//{{AFX_MSG_MAP(CDynCtrlBar)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_NCCREATE()
	ON_WM_NCCALCSIZE()
	ON_WM_NCPAINT()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDynCtrlBar message handlers

BOOL CDynCtrlBar::Create(LPCTSTR lpszWindowName, DWORD dwStyle, const RECT &rect, CWnd *pChild, CWnd *pParentWnd, UINT nID)
{
	ASSERT_VALID(pParentWnd);
	ASSERT(!(dwStyle & CBRS_SIZE_FIXED && dwStyle & CBRS_SIZE_DYNAMIC));

	m_dwStyle = dwStyle & CBRS_ALL;
	m_size.cx = rect.right - rect.left;
	m_size.cy = rect.bottom - rect.top;

	m_pChild = pChild;

	static CString strClassName;
	if (strClassName.IsEmpty())
		strClassName = AfxRegisterWndClass(CS_DBLCLKS,
			AfxGetApp()->LoadStandardCursor(IDC_ARROW),
			(HBRUSH) (COLOR_3DFACE + 1));
	if (!CreateEx(0, strClassName, lpszWindowName, dwStyle | WS_CLIPCHILDREN, rect, pParentWnd, nID))
		return FALSE;
	return TRUE;
}

void CDynCtrlBar::DoPaint(CDC* pDC)
{
}

CSize CDynCtrlBar::CalcFixedLayout(BOOL bStretch, BOOL bHorz)
{
	if(IsFloating())
		return m_size;
	else if (bHorz)
	{
		CRect rect;
		m_pDockSite->GetControlBar(AFX_IDW_DOCKBAR_TOP)->GetWindowRect(&rect);
		int nHorzDockBarWidth = bStretch ? 32767 : rect.Width() + 4;
		return CSize(nHorzDockBarWidth, m_size.cy);
	}
	else
	{
		CRect rect;
		m_pDockSite->GetControlBar(AFX_IDW_DOCKBAR_LEFT)->GetWindowRect(&rect);
		int nVertDockBarHeight = bStretch ? 32767 : rect.Height() + 4;
		return CSize(m_size.cx, nVertDockBarHeight);
	}
}

CSize CDynCtrlBar::CalcDynamicLayout(int nLength, DWORD dwMode)
{
	if (dwMode & (LM_HORZDOCK | LM_VERTDOCK))
		return CControlBar::CalcDynamicLayout(nLength, dwMode);
	return m_size;
}

void CDynCtrlBar::OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler)
{
}

int CDynCtrlBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CControlBar::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_nBorderSize = 6;
	m_nGripperSize = 3;
	m_hHorzCursor = AfxGetApp()->LoadCursor(AFX_IDC_HSPLITBAR);
	if (m_hHorzCursor == NULL)
		m_hHorzCursor = AfxGetApp()->LoadStandardCursor(IDC_SIZEWE);
	m_hVertCursor = AfxGetApp()->LoadCursor(AFX_IDC_VSPLITBAR);
	if (m_hVertCursor == NULL)
		m_hVertCursor = AfxGetApp()->LoadStandardCursor(IDC_SIZENS);
	m_bRecalcNC = FALSE;
	return 0;
}

void CDynCtrlBar::OnPaint() 
{
	CPaintDC dc(this);
	OnPrepareDC(&dc);
	OnDraw(&dc);
}

void CDynCtrlBar::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);

	SCROLLINFO si;
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = m_sizeTotal.cy;
	si.nPage = cy;
	SetScrollInfo(SB_VERT, &si);

	si.nMin = 0;
	si.nMax = m_sizeTotal.cx;
	si.nPage = cx;
	SetScrollInfo(SB_HORZ, &si);
}

void CDynCtrlBar::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SCROLLINFO si;
	GetScrollInfo(SB_VERT, &si);

	int n;
	switch (nSBCode)
	{
	case SB_TOP:
		n = si.nMin - si.nPos;
		break;
	case SB_BOTTOM:
		n = si.nMax - si.nPos;
		break;
	case SB_LINEUP:
		n = -1;
		break;
	case SB_LINEDOWN:
		n = 1;
		break;
	case SB_PAGEUP:
		n = -(int) si.nPage;
		break;
	case SB_PAGEDOWN:
		n = si.nPage;
		break;
	case SB_THUMBTRACK:
		n = nPos - si.nPos;
		break;
	default:
		return;
	}

	int nMin = si.nMin - si.nPos, nMax = si.nMax - si.nPos - si.nPage + 1;
	if (n < nMin)
		n = nMin;
	if (n > nMax)
		n = nMax;
	if (n != 0)
	{
		SetScrollPos(SB_VERT, si.nPos + n);
		ScrollWindow(0, -n);
	}
	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CDynCtrlBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SCROLLINFO si;
	GetScrollInfo(SB_HORZ, &si);

	int n;
	switch (nSBCode)
	{
	case SB_TOP:
		n = si.nMin - si.nPos;
		break;
	case SB_BOTTOM:
		n = si.nMax - si.nPos;
		break;
	case SB_LINEUP:
		n = -1;
		break;
	case SB_LINEDOWN:
		n = 1;
		break;
	case SB_PAGEUP:
		n = -(int) si.nPage;
		break;
	case SB_PAGEDOWN:
		n = si.nPage;
		break;
	case SB_THUMBTRACK:
		n = nPos - si.nPos;
		break;
	default:
		return;
	}

	int nMin = si.nMin - si.nPos, nMax = si.nMax - si.nPos - si.nPage + 1;
	if (n < nMin)
		n = nMin;
	if (n > nMax)
		n = nMax;
	if (n != 0)
	{
		SetScrollPos(SB_HORZ, si.nPos + n);
		ScrollWindow(-n, 0);
	}
	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDynCtrlBar::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CPoint ptWindow = point;
	ClientToWindow(&ptWindow);
	if (m_rcBorder.PtInRect(ptWindow))
	{
		StartTracking(ptWindow);
		return;
	}

	CRect rect;
	GetClientRect(&rect);
	if (rect.PtInRect(point))
		return;
	CControlBar::OnLButtonDown(nFlags, point);
}

void CDynCtrlBar::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if (GetCapture() == this)
	{
		CPoint ptWindow = point;
		ClientToWindow(&ptWindow);
		StopTracking(ptWindow);
		return;
	}

	CRect rect;
	GetClientRect(&rect);
	if (rect.PtInRect(point))
		return;
	CControlBar::OnLButtonUp(nFlags, point);
}

void CDynCtrlBar::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CPoint ptWindow = point;
	ClientToWindow(&ptWindow);
	if (m_rcBorder.PtInRect(ptWindow))
	{
		StartTracking(ptWindow);
		return;
	}
	CControlBar::OnLButtonDblClk(nFlags, point);
}

void CDynCtrlBar::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (GetCapture() == this)
	{
		InvertTracker(m_rcTracker);

		CPoint ptWindow = point;
		ClientToWindow(&ptWindow);

		m_rcTracker = m_rcBorder;
		WindowToScreen(&m_rcTracker);
		if (m_nDock == left || m_nDock == right)
		{
			m_rcTracker.DeflateRect(1, 0, 1, 0);
			m_rcTracker.OffsetRect(ptWindow.x - m_ptOld.x, 0);
		}
		else
		{
			ASSERT(m_nDock == top || m_nDock == bottom);
			m_rcTracker.DeflateRect(0, 1, 0, 1);
			m_rcTracker.OffsetRect(0, ptWindow.y - m_ptOld.y);
		}
		InvertTracker(m_rcTracker);
		return;
	}
	CControlBar::OnMouseMove(nFlags, point);
}

BOOL CDynCtrlBar::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	CPoint point;
	GetCursorPos(&point);
	ScreenToWindow(&point);
	if (m_rcBorder.PtInRect(point))
	{
		if (m_nDock == left || m_nDock == right)
			SetCursor(m_hHorzCursor);
		else
		{
			ASSERT(m_nDock == top || m_nDock == bottom);
			SetCursor(m_hVertCursor);
		}
		return TRUE;
	}
	return CControlBar::OnSetCursor(pWnd, nHitTest, message);
}

void CDynCtrlBar::ClientToWindow(CPoint *pPoint)
{
	CRect rcWindow;
	GetWindowRect(&rcWindow);

	ClientToScreen(pPoint);
	pPoint->x -= rcWindow.left;
	pPoint->y -= rcWindow.top;
}

void CDynCtrlBar::ScreenToWindow(CPoint *pPoint)
{
	CRect rcWindow;
	GetWindowRect(&rcWindow);

	pPoint->x -= rcWindow.left;
	pPoint->y -= rcWindow.top;
}

void CDynCtrlBar::WindowToScreen(CRect *pRect)
{
	CRect rcWindow;
	GetWindowRect(&rcWindow);

	pRect->left += rcWindow.left;
	pRect->top += rcWindow.top;
	pRect->right += rcWindow.left;
	pRect->bottom += rcWindow.top;
}

void CDynCtrlBar::StartTracking(CPoint point)
{
	SetCapture();
	m_ptOld = point;

	m_rcTracker = m_rcBorder;
	WindowToScreen(&m_rcTracker);
	if (m_nDock == left || m_nDock == right)
	{
		m_rcTracker.DeflateRect(1, 0, 1, 0);
		m_rcTracker.OffsetRect(point.x - m_ptOld.x, 0);
	}
	else
	{
		ASSERT(m_nDock == top || m_nDock == bottom);
		m_rcTracker.DeflateRect(0, 1, 0, 1);
		m_rcTracker.OffsetRect(0, point.y - m_ptOld.y);
	}
	InvertTracker(m_rcTracker);
}

void CDynCtrlBar::StopTracking(CPoint point)
{
	ReleaseCapture();

	InvertTracker(m_rcTracker);
	switch (m_nDock)
	{
	case left:
		m_size.cx += point.x - m_ptOld.x;
		break;
	case top:
		m_size.cy += point.y - m_ptOld.y;
		break;
	case right:
		m_size.cx -= point.x - m_ptOld.x;
		break;
	case bottom:
		m_size.cy -= point.y - m_ptOld.y;
		break;
	default:
		ASSERT(FALSE);
	}
	if (m_size.cx < 16)
		m_size.cx = 16;
	if (m_size.cy < 16)
		m_size.cy = 16;
	m_pDockSite->RecalcLayout();

	OnNcPaint();
	Invalidate();
}

void CDynCtrlBar::InvertTracker(const CRect &rect)
{
	CClientDC dc(NULL);
	CBrush *pOldBrush = dc.SelectObject(CDC::GetHalftoneBrush());
	dc.PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATINVERT);
	dc.SelectObject(pOldBrush);
}

void CDynCtrlBar::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CControlBar::OnWindowPosChanged(lpwndpos);

	if (m_bRecalcNC)
	{
		if (m_pChild != NULL && m_pChild->m_hWnd != NULL)
		{
			CRect rect;
			GetClientRect(&rect);
			m_pChild->MoveWindow(&rect);
		}
		return;
	}

	m_pDockSite->RecalcLayout();

	switch (GetParent()->GetDlgCtrlID())
	{
	case AFX_IDW_DOCKBAR_LEFT:
		m_nDock = left;
		break;
	case AFX_IDW_DOCKBAR_TOP:
		m_nDock = top;
		break;
	case AFX_IDW_DOCKBAR_RIGHT:
		m_nDock = right;
		break;
	case AFX_IDW_DOCKBAR_BOTTOM:
		m_nDock = bottom;
		break;
	default:
		m_nDock = none;
	}

	CRect rect;
    GetWindowRect(&rect);
	rect.SetRect(0, 0, rect.Width(), rect.Height());

	switch (m_nDock)
	{
	case left:
		m_rcBorder.left = rect.right - m_nBorderSize;
		m_rcBorder.right = rect.right - 1;
		m_rcBorder.top = rect.top + 2;
		m_rcBorder.bottom = rect.bottom - 2;

		m_rcGripper.left = rect.left + 4;
		m_rcGripper.top = rect.top + 4;
		m_rcGripper.right = rect.right - m_nBorderSize - 2;
		m_rcGripper.bottom = m_rcGripper.top + m_nGripperSize;
		break;
	case top:
		m_rcBorder.top = rect.bottom - m_nBorderSize;
		m_rcBorder.bottom = rect.bottom - 1;
		m_rcBorder.left = rect.left + 2;
		m_rcBorder.right = rect.right - 2;

		m_rcGripper.left = rect.left + 4;
		m_rcGripper.top = rect.top + 4;
		m_rcGripper.right = m_rcGripper.left + m_nGripperSize;
		m_rcGripper.bottom = rect.bottom - m_nBorderSize - 2;
		break;
	case right:
		m_rcBorder.right = rect.left + m_nBorderSize;
		m_rcBorder.left = rect.left + 1;
		m_rcBorder.top = rect.top + 2;
		m_rcBorder.bottom = rect.bottom - 2;

		m_rcGripper.left = m_rcBorder.left + 3;
		m_rcGripper.top = 4;
		m_rcGripper.right = m_rcBorder.left - 2;
		m_rcGripper.bottom = m_rcGripper.top + m_nGripperSize;

		m_rcGripper.left = rect.left + m_nBorderSize + 2;
		m_rcGripper.top = rect.top + 4;
		m_rcGripper.right = rect.right - 4;
		m_rcGripper.bottom = m_rcGripper.top + m_nGripperSize;
		break;
	case bottom:
		m_rcBorder.bottom = rect.top + m_nBorderSize;
		m_rcBorder.top = rect.top + 1;
		m_rcBorder.left = rect.left + 2;
		m_rcBorder.right = rect.right - 2;

		m_rcGripper.left = rect.left + 4;
		m_rcGripper.top = rect.top + m_nBorderSize + 2;
		m_rcGripper.right = m_rcGripper.left + m_nGripperSize;
		m_rcGripper.bottom = rect.bottom - 4;
		break;
	case none:
		m_rcBorder.SetRectEmpty();
		m_rcGripper.SetRectEmpty();
		break;
	default:
		ASSERT(FALSE);
	}

	m_bRecalcNC = TRUE;
	SetWindowPos(NULL, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOZORDER | SWP_FRAMECHANGED);
	m_bRecalcNC = FALSE;
}

BOOL CDynCtrlBar::OnNcCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (!CControlBar::OnNcCreate(lpCreateStruct))
		return FALSE;
	m_nDock = none;
	return TRUE;
}

void CDynCtrlBar::OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp) 
{
	CRect rect;
    GetWindowRect(&rect);
	rect.SetRect(0, 0, rect.Width(), rect.Height());

	switch (m_nDock)
	{
	case left:
		lpncsp->rgrc[0].left += 2 + 2;
		lpncsp->rgrc[0].top += m_nGripperSize + 4 + 2;
		lpncsp->rgrc[0].right -= m_nBorderSize + 2;
		lpncsp->rgrc[0].bottom -= 4 + 2 + 2;
		break;
	case top:
		lpncsp->rgrc[0].left += m_nGripperSize + 4 + 2;
		lpncsp->rgrc[0].top += 2 + 2;
		lpncsp->rgrc[0].right -= 2;
		lpncsp->rgrc[0].bottom -= m_nBorderSize + 2;
		break;
	case right:
		lpncsp->rgrc[0].left += m_nBorderSize + 2;
		lpncsp->rgrc[0].top += m_nGripperSize + 4 + 2;
		lpncsp->rgrc[0].right -= 2 + 2;
		lpncsp->rgrc[0].bottom -= 4 + 2 + 2;
		break;
	case bottom:
		lpncsp->rgrc[0].left += m_nGripperSize + 4 + 2;
		lpncsp->rgrc[0].top += m_nBorderSize + 2;
		lpncsp->rgrc[0].right -= 2;
		lpncsp->rgrc[0].bottom -= 2 + 2;
		break;
	case none:
		lpncsp->rgrc[0].left += 2;
		lpncsp->rgrc[0].top += 2;
		lpncsp->rgrc[0].right -= 2;
		lpncsp->rgrc[0].bottom -= 2;
		break;
	default:
		ASSERT(FALSE);
	}

	if (GetExStyle() & WS_EX_CLIENTEDGE)
	{
		lpncsp->rgrc[0].left += 2;
		lpncsp->rgrc[0].top += 2;
		lpncsp->rgrc[0].right -= 2;
		lpncsp->rgrc[0].bottom -= 2;
	}
}

void CDynCtrlBar::OnNcPaint() 
{
	CWindowDC dc(this);

	m_pDockSite->RecalcLayout();

	CRect rcWindow;
    GetWindowRect(&rcWindow);

	CRect rcClient;
	GetClientRect(&rcClient);
	ClientToScreen(&rcClient);
	rcClient.left -= rcWindow.left;
	rcClient.top -= rcWindow.top;
	rcClient.right -= rcWindow.left;
	rcClient.bottom -= rcWindow.top;

	if (GetExStyle() & WS_EX_CLIENTEDGE)
		rcClient.InflateRect(2, 2, 2, 2);

	rcWindow.SetRect(0, 0, rcWindow.Width(), rcWindow.Height());

	CRect rect(rcWindow.left, rcWindow.top, rcWindow.right, rcWindow.top + 2);
	dc.DrawEdge(&rect, BDR_SUNKENOUTER, BF_TOP | BF_BOTTOM);
	rect.SetRect(rcWindow.left, rcWindow.bottom - 2, rcWindow.right, rcWindow.bottom);
	dc.DrawEdge(&rect, BDR_SUNKENOUTER, BF_TOP | BF_BOTTOM);
	rect.SetRect(rcWindow.left, rcWindow.top + 2, rcWindow.left + 2, rcWindow.bottom - 2);
	dc.DrawEdge(&rect, BDR_SUNKENOUTER, BF_LEFT | BF_RIGHT);
	rect.SetRect(rcWindow.right - 2, rcWindow.top + 2, rcWindow.right, rcWindow.bottom - 2);
	dc.DrawEdge(&rect, BDR_SUNKENOUTER, BF_LEFT | BF_RIGHT);

	rcWindow.DeflateRect(2, 2, 2, 2);

	rect.SetRect(rcWindow.left, rcWindow.top, rcWindow.right, rcClient.top);
	dc.FillSolidRect(&rect, GetSysColor(COLOR_3DFACE));
	rect.SetRect(rcWindow.left, rcClient.top, rcClient.left, rcWindow.bottom);
	dc.FillSolidRect(&rect, GetSysColor(COLOR_3DFACE));
	rect.SetRect(rcClient.right, rcClient.top, rcWindow.right, rcWindow.bottom);
	dc.FillSolidRect(&rect, GetSysColor(COLOR_3DFACE));
	rect.SetRect(rcClient.left, rcClient.bottom, rcClient.right, rcWindow.bottom);
	dc.FillSolidRect(&rect, GetSysColor(COLOR_3DFACE));

	if (GetExStyle() & WS_EX_CLIENTEDGE)
		dc.DrawEdge(&rcClient, EDGE_SUNKEN, BF_RECT);

	switch (m_nDock)
	{
	case left:
		dc.DrawEdge(&m_rcGripper, BDR_RAISEDINNER, BF_RECT);
		rect.SetRect(m_rcBorder.left, m_rcBorder.top, m_rcBorder.left + 1, m_rcBorder.bottom);
		dc.FillSolidRect(&rect, GetSysColor(COLOR_3DHILIGHT));
		break;
	case top:
		dc.DrawEdge(&m_rcGripper, BDR_RAISEDINNER, BF_RECT);
		rect.SetRect(m_rcBorder.left, m_rcBorder.top, m_rcBorder.right, m_rcBorder.top + 1);
		dc.FillSolidRect(&rect, GetSysColor(COLOR_3DHILIGHT));
		break;
	case right:
		dc.DrawEdge(&m_rcGripper, BDR_RAISEDINNER, BF_RECT);
		rect.SetRect(m_rcBorder.right - 1, m_rcBorder.top, m_rcBorder.right, m_rcBorder.bottom);
		dc.FillSolidRect(&rect, GetSysColor(COLOR_3DSHADOW));
		break;
	case bottom:
		dc.DrawEdge(&m_rcGripper, BDR_RAISEDINNER, BF_RECT);
		rect.SetRect(m_rcBorder.left, m_rcBorder.bottom - 1, m_rcBorder.right, m_rcBorder.bottom);
		dc.FillSolidRect(&rect, GetSysColor(COLOR_3DSHADOW));
		break;
	case none:
		break;
	default:
		ASSERT(FALSE);
	}
}

UINT CDynCtrlBar::OnNcHitTest(CPoint point) 
{
	UINT nHitTest = CControlBar::OnNcHitTest(point);
	if (nHitTest == HTNOWHERE)
		return HTCLIENT;
	return nHitTest;
}

void CDynCtrlBar::OnDraw(CDC *pDC)
{
}

void CDynCtrlBar::OnPrepareDC(CDC *pDC)
{
	pDC->SetViewportOrg(-GetScrollPos(SB_HORZ), -GetScrollPos(SB_VERT));
}

CSize CDynCtrlBar::GetTotalSize() const
{
	return m_sizeTotal;
}

void CDynCtrlBar::SetScrollSizes(int nMapMode, SIZE sizeTotal)
{
	ASSERT(nMapMode == MM_TEXT);
	m_sizeTotal = sizeTotal;

	CRect rect;
	GetClientRect(&rect);

	SCROLLINFO si;
	si.fMask = SIF_RANGE | SIF_PAGE;
	si.nMin = 0;
	si.nMax = m_sizeTotal.cy;
	si.nPage = rect.Width();
	SetScrollInfo(SB_VERT, &si);

	si.nMin = 0;
	si.nMax = m_sizeTotal.cx;
	si.nPage = rect.Height();
	SetScrollInfo(SB_HORZ, &si);
}
