#if !defined(AFX_DYNCTRLBAR_H__20D0A6D2_4AE1_43E8_8F2A_196F1000BC8F__INCLUDED_)
#define AFX_DYNCTRLBAR_H__20D0A6D2_4AE1_43E8_8F2A_196F1000BC8F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DynCtrlBar.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDynCtrlBar window

class CDynCtrlBar : public CControlBar
{
// Construction
public:
	CDynCtrlBar();
	BOOL Create(LPCTSTR lpszWindowName, DWORD dwStyle, const RECT &rect, CWnd *pChild, CWnd *pParentWnd, UINT nID);

// Attributes
public:
	CSize GetTotalSize() const;
	void SetScrollSizes(int nMapMode, SIZE sizeTotal);

// Operations
public:

// Overridables
	virtual void OnDraw(CDC *pDC);
	virtual void OnPrepareDC(CDC *pDC);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDynCtrlBar)
	//}}AFX_VIRTUAL
	public:
	virtual void DoPaint(CDC* pDC);
	virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
	virtual CSize CalcDynamicLayout(int nLength, DWORD dwMode);
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

// Implementation
public:
	virtual ~CDynCtrlBar();

private:
	enum { none, left, top, right, bottom } m_nDock;

	CWnd *m_pChild;

	int m_nBorderSize, m_nGripperSize;

	CSize m_size, m_sizeTotal;
	CRect m_rcBorder, m_rcGripper, m_rcClient;

	CPoint m_ptOld;
	CRect m_rcTracker;

	BOOL m_bRecalcNC;

	HCURSOR m_hHorzCursor, m_hVertCursor;

	void ClientToWindow(CPoint *pPoint);
	void ScreenToWindow(CPoint *pPoint);
	void WindowToScreen(CRect *pRect);
	void StartTracking(CPoint point);
	void StopTracking(CPoint point);
	void InvertTracker(const CRect &rect);

	// Generated message map functions
protected:
	//{{AFX_MSG(CDynCtrlBar)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
	afx_msg void OnNcPaint();
	afx_msg UINT OnNcHitTest(CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DYNCTRLBAR_H__20D0A6D2_4AE1_43E8_8F2A_196F1000BC8F__INCLUDED_)
