#include "stdafx.h"
#include "FindFile.h"

BOOL IsFileExisting(LPCTSTR lpszFileName, BOOL bWideCard /*= FALSE*/)
{
	ASSERT(IsValidString(lpszFileName));
	if (!bWideCard)
		for (int i = 0;lpszFileName[i];i++)
			if (lpszFileName[i] == '*' || lpszFileName[i] == '?')
				return FALSE;

	SFindFile find;
	for (BOOL bDone = find.FindFirst(lpszFileName);bDone;bDone = find.FindNext())
		if (!(find.GetFileAttributes() & FILE_ATTRIBUTE_DIRECTORY))
			return TRUE;
	return FALSE;
}

BOOL IsDirectoryExisting(LPCTSTR lpszFileName, BOOL bWideCard /*= FALSE*/)
{
	ASSERT(IsValidString(lpszFileName));
	if (!bWideCard)
		for (int i = 0;lpszFileName[i];i++)
			if (lpszFileName[i] == '*' || lpszFileName[i] == '?')
				return FALSE;

	SFindFile find;
	for (BOOL bDone = find.FindFirst(lpszFileName);bDone;bDone = find.FindNext())
		if (find.GetFileAttributes() & FILE_ATTRIBUTE_DIRECTORY)
			return TRUE;
	return FALSE;
}
