//============================================================================

#ifndef __FINDFILE_H__
#define __FINDFILE_H__

#include "Commdef.h"

class SFindFile
{
public:
	SFindFile();
	~SFindFile();

protected:
	HANDLE m_hFind;
	WIN32_FIND_DATA m_fd;

public:
	BOOL FindFirst(LPCTSTR lpszFileName);
	BOOL FindNext();
	void Close();

	DWORD GetFileAttributes() const;
	FILETIME GetCreationTime() const;
	FILETIME GetLastAccessTime() const;
	FILETIME GetLastWriteTime() const;
	DWORD GetFileSizeHigh() const;
	DWORD GetFileSizeLow() const;
	DWORD GetFileSize() const;
	UINT64 GetFileSize64() const;
	LPTSTR GetFileName();
	LPTSTR GetAlternateFileName();
	LPCTSTR GetFileName() const;
	LPCTSTR GetAlternateFileName() const;
};

inline SFindFile::SFindFile()
{
	m_hFind = INVALID_HANDLE_VALUE;
}

inline SFindFile::~SFindFile()
{
	if (m_hFind != INVALID_HANDLE_VALUE)
		FindClose(m_hFind);
}

inline BOOL SFindFile::FindFirst(LPCTSTR lpszFileName)
{
	ASSERT(m_hFind == INVALID_HANDLE_VALUE);
	ASSERT(IsValidString(lpszFileName));
	m_hFind = FindFirstFile(lpszFileName, &m_fd);
	return m_hFind != INVALID_HANDLE_VALUE;
}

inline BOOL SFindFile::FindNext()
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return FindNextFile(m_hFind, &m_fd);
}

inline void SFindFile::Close()
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	FindClose(m_hFind);
	m_hFind = INVALID_HANDLE_VALUE;
}

inline DWORD SFindFile::GetFileAttributes() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.dwFileAttributes;
}

inline FILETIME SFindFile::GetCreationTime() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.ftCreationTime;
}

inline FILETIME SFindFile::GetLastAccessTime() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.ftLastAccessTime;
}

inline FILETIME SFindFile::GetLastWriteTime() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.ftLastWriteTime;
}

inline DWORD SFindFile::GetFileSizeHigh() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.nFileSizeHigh;
}

inline DWORD SFindFile::GetFileSizeLow() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.nFileSizeLow;
}

inline DWORD SFindFile::GetFileSize() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.nFileSizeLow;
}

inline UINT64 SFindFile::GetFileSize64() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	UINT64 nSize;
	*((DWORD *) &nSize) = m_fd.nFileSizeLow;
	*((DWORD *) &nSize + 1) = m_fd.nFileSizeHigh;
	return nSize;
}

inline LPTSTR SFindFile::GetFileName()
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.cFileName;
}

inline LPTSTR SFindFile::GetAlternateFileName()
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.cAlternateFileName;
}

inline LPCTSTR SFindFile::GetFileName() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.cFileName;
}

inline LPCTSTR SFindFile::GetAlternateFileName() const
{
	ASSERT(m_hFind != INVALID_HANDLE_VALUE);
	return m_fd.cAlternateFileName;
}

BOOL IsFileExisting(LPCTSTR lpszFileName, BOOL bWideCard = FALSE);
BOOL IsDirectoryExisting(LPCTSTR lpszPath, BOOL bWideCard = FALSE);

#endif // __FINDFILE_H__
