// MapEditDoc.cpp : implementation of the CMapEditDoc class
//

#include "stdafx.h"
#include "MapEdit.h"

#include "MapEditDoc.h"

#include "MainFrm.h"
#include "NewDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapEditDoc

IMPLEMENT_DYNCREATE(CMapEditDoc, CDocument)

BEGIN_MESSAGE_MAP(CMapEditDoc, CDocument)
	//{{AFX_MSG_MAP(CMapEditDoc)
	ON_UPDATE_COMMAND_UI(ID_TOOL_TILE_MODE, OnUpdateToolTileMode)
	ON_COMMAND(ID_TOOL_TILE_MODE, OnToolTileMode)
	ON_UPDATE_COMMAND_UI(ID_TOOL_WALL_MODE, OnUpdateToolWallMode)
	ON_COMMAND(ID_TOOL_WALL_MODE, OnToolWallMode)
	ON_UPDATE_COMMAND_UI(ID_TOOL_DELETE_WALL, OnUpdateToolDeleteWall)
	ON_COMMAND(ID_TOOL_DELETE_WALL, OnToolDeleteWall)
	ON_UPDATE_COMMAND_UI(ID_TOOL_DELETE_WALL_POINT, OnUpdateToolDeleteWallPoint)
	ON_COMMAND(ID_TOOL_DELETE_WALL_POINT, OnToolDeleteWallPoint)
	ON_COMMAND(ID_FILE_SAVE_TILE, OnFileSaveTile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapEditDoc construction/destruction

CMapEditDoc::CMapEditDoc()
{
	TRY
	{
		m_mngTerrain.Load(_T("Terrain"));
	}
	CATCH(CUserException, e)
	{
		ExitProcess(-1);
	}
	AND_CATCH_ALL(e)
	{
		e->ReportError(MB_OK | MB_ICONERROR);
		ExitProcess(-1);
	}
	END_CATCH_ALL
}

CMapEditDoc::~CMapEditDoc()
{
}

BOOL CMapEditDoc::OnNewDocument()
{
	CNewDlg dlg;
	static BOOL bFirst = TRUE;
	if (bFirst)
		bFirst = FALSE;
	else
		if (dlg.DoModal() != IDOK)
			return FALSE;

	if (!CDocument::OnNewDocument())
		return FALSE;
	const STerrainPattern *pPattern = m_mngTerrain.GetType(0)->GetPattern(0);
	m_map.Create(dlg.m_nWidth, dlg.m_nHeight, &m_mngTerrain, pPattern);

	GetTerrainFloatBar()->Update(this);
	GetWallAttributesFloatBar()->Update(this);
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CMapEditDoc serialization

void CMapEditDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMapEditDoc diagnostics

#ifdef _DEBUG
void CMapEditDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMapEditDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMapEditDoc commands

void CMapEditDoc::DeleteContents() 
{
	m_nMode = ID_TOOL_TILE_MODE;
	if (m_map.GetWidth() > 0 && m_map.GetHeight() > 0)
		m_map.Delete();

	m_pSelWallLine = NULL;
	m_pSelWallPoint = NULL;

	m_wallattrib.m_bMove = TRUE;
	m_wallattrib.m_bThrough = TRUE;
	m_wallattrib.m_bView = TRUE;
	CDocument::DeleteContents();
}

BOOL CMapEditDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	DeleteContents();
	m_map.Load(lpszPathName);

	SetModifiedFlag(FALSE);
	return TRUE;
}

BOOL CMapEditDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	m_map.Save(lpszPathName);

	SetModifiedFlag(FALSE);
	return TRUE;
}

void CMapEditDoc::OnUpdateToolTileMode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_nMode == ID_TOOL_TILE_MODE);
}

void CMapEditDoc::OnToolTileMode() 
{
	m_nMode = ID_TOOL_TILE_MODE;
	UpdateAllViews(NULL);
}

void CMapEditDoc::OnUpdateToolWallMode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_nMode == ID_TOOL_WALL_MODE);
}

void CMapEditDoc::OnToolWallMode() 
{
	m_nMode = ID_TOOL_WALL_MODE;
	UpdateAllViews(NULL);
}

void CMapEditDoc::OnUpdateToolDeleteWall(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pSelWallLine != NULL);
}

void CMapEditDoc::OnToolDeleteWall() 
{
	ASSERT(m_pSelWallLine != NULL);
	m_listWall.Remove((PNODE) m_pSelWallLine);
	m_pSelWallLine = NULL;
	m_pSelWallPoint = NULL;

	UpdateAllViews(NULL);
}

void CMapEditDoc::OnUpdateToolDeleteWallPoint(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pSelWallPoint != NULL);
}

void CMapEditDoc::OnToolDeleteWallPoint() 
{
	ASSERT(m_pSelWallLine != NULL);
	m_pSelWallLine->RemovePoint(m_pSelWallPoint);
	m_pSelWallLine = NULL;
	m_pSelWallPoint = NULL;

	UpdateAllViews(NULL);
}

CWallAttributesFloatBar *CMapEditDoc::GetWallAttributesFloatBar()
{
	CMainFrame *pMainFrame = (CMainFrame *) AfxGetMainWnd();
	ASSERT_VALID(pMainFrame);
	return &pMainFrame->m_wndWallAttributes;
}

CTerrainFloatBar *CMapEditDoc::GetTerrainFloatBar()
{
	CMainFrame *pMainFrame = (CMainFrame *) AfxGetMainWnd();
	ASSERT_VALID(pMainFrame);
	return &pMainFrame->m_wndTerrain;
}

BOOL CMapEditDoc::DrawTerrain(int x, int y)
{
	if (!m_map.DrawTerrain(x, y, GetTerrainFloatBar()->GetSelType()))
		return FALSE;
	return TRUE;
}

void CMapEditDoc::MergeMap()
{
	m_map.MergeMap();
	SetModifiedFlag();
}

SWallLine *CMapEditDoc::GetPrevWall(SWallLine *pLine)
{
	PNODE pNode = (PNODE) pLine;
	ASSERT(m_listWall.IsValidNode(pNode));
	return (SWallLine *) m_listWall.GetPrev(pNode);
}

SWallLine *CMapEditDoc::GetNextWall(SWallLine *pLine)
{
	PNODE pNode = (PNODE) pLine;
	ASSERT(m_listWall.IsValidNode(pNode));
	return (SWallLine *) m_listWall.GetNext(pNode);
}

BOOL CMapEditDoc::AddWallPoint(int x, int y)
{
	for (PNODE pNode = m_listWall.GetHead();pNode;pNode = m_listWall.GetNext(pNode))
	{
		SWallPoint *pPoint = m_listWall[pNode].FindLine(CPoint(x, y));
		if (pPoint != NULL)
		{
			m_pSelWallLine = &m_listWall[pNode];
			m_pSelWallPoint = m_pSelWallLine->InsertPoint(pPoint, x, y);

			m_pSelWallPoint->SetAttributes(m_wallattrib);
			ASSERT(m_pSelWallLine->GetNextPoint(m_pSelWallPoint) != NULL);
			m_pSelWallLine->GetNextPoint(m_pSelWallPoint)->SetAttributes(m_wallattrib);
			return TRUE;
		}
	}

	if (m_pSelWallLine == NULL)
	{
		m_pSelWallLine = &m_listWall.AddTail();
		m_pSelWallPoint = m_pSelWallLine->InsertPoint(NULL, x, y);
		m_pSelWallPoint->SetAttributes(m_wallattrib);
	}
	else
	{
		if (m_pSelWallPoint == m_pSelWallLine->GetFirstPoint())
		{
			m_pSelWallPoint = m_pSelWallLine->InsertPoint(m_pSelWallPoint, x, y);

			ASSERT(m_pSelWallLine->GetNextPoint(m_pSelWallPoint) != NULL);
			m_pSelWallLine->GetNextPoint(m_pSelWallPoint)->SetAttributes(m_wallattrib);
		}
		else if (m_pSelWallPoint == m_pSelWallLine->GetLastPoint())
		{
			m_pSelWallPoint = m_pSelWallLine->InsertPoint(NULL, x, y);
			m_pSelWallPoint->SetAttributes(m_wallattrib);
		}
		else
			return FALSE;
	}
	return TRUE;
}

BOOL CMapEditDoc::FindWallPoint(CPoint point)
{
	for (PNODE pNode = m_listWall.GetHead();pNode;pNode = m_listWall.GetNext(pNode))
		if (m_listWall[pNode].FindPoint(point) != NULL)
			return TRUE;
	return FALSE;
}

BOOL CMapEditDoc::FindWallLine(CPoint point)
{
	for (PNODE pNode = m_listWall.GetHead();pNode;pNode = m_listWall.GetNext(pNode))
		if (m_listWall[pNode].FindLine(point) != NULL)
			return TRUE;
	return FALSE;
}

BOOL CMapEditDoc::SelectWallPoint(CPoint point)
{
	for (PNODE pNode = m_listWall.GetHead();pNode;pNode = m_listWall.GetNext(pNode))
	{
		SWallPoint *pPoint = m_listWall[pNode].FindPoint(point);
		if (pPoint != NULL)
		{
			m_pSelWallLine = &m_listWall[pNode];
			m_pSelWallPoint = pPoint;
			return TRUE;
		}
	}
	return FALSE;
}

BOOL CMapEditDoc::SetWallAttributes(CPoint point, BOOL bAllPoint)
{
	for (PNODE pNode = m_listWall.GetHead();pNode;pNode = m_listWall.GetNext(pNode))
	{
		SWallPoint *pPoint = m_listWall[pNode].FindLine(point);
		if (pPoint != NULL)
		{
			if (bAllPoint)
			{
				SWallLine *pLine = &m_listWall[pNode];
				for (pPoint = pLine->GetFirstPoint();pPoint;pPoint = pLine->GetNextPoint(pPoint))
					pPoint->SetAttributes(m_wallattrib);
			}
			else
				pPoint->SetAttributes(m_wallattrib);
			return TRUE;
		}
	}
	return FALSE;
}

void CMapEditDoc::OnFileSaveTile() 
{
	CWaitCursor wait;
	TRY
	{
		m_mngTerrain.SaveForEngine(_T("Terrain"));
	}
	CATCH_ALL(e)
	{
		e->ReportError(MB_OK | MB_ICONERROR);
	}
	END_CATCH_ALL
}
