// MapEditView.h : interface of the CMapEditView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAPEDITVIEW_H__6FB50F35_2986_4F79_9187_F5CFFC8E1AD2__INCLUDED_)
#define AFX_MAPEDITVIEW_H__6FB50F35_2986_4F79_9187_F5CFFC8E1AD2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CMapEditView : public CScrollView
{
protected: // create from serialization only
	CMapEditView();
	DECLARE_DYNCREATE(CMapEditView)

// Attributes
public:
	CMapEditDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapEditView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnScrollBy(CSize sizeScroll, BOOL bDoScroll = TRUE);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMapEditView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
	//  ۸
	int m_xBack, m_yBack;
	SDIBSection m_bmpBack, m_bmpWall;

	void UpdateBack();
	void UpdateWall();

	// Ÿ ׸
	BOOL m_bLastDrawResult;
	int m_xLast, m_yLast;

	void TileLButtonDown(UINT nFlags, CPoint point);
	void TileLButtonUp(UINT nFlags, CPoint point);
	void TileLButtonDblClk(UINT nFlags, CPoint point);
	void TileRButtonDown(UINT nFlags, CPoint point);
	void TileMouseMove(UINT nFlags, CPoint point);

	BOOL DPtoTP(CPoint point, int *px, int *py);
	BOOL IsValidPoint(int x, int y);

	//  ׸
	HCURSOR m_hCrossCursor, m_hMoveCursor, m_hLineCursor;

	void WallLButtonDown(UINT nFlags, CPoint point);
	void WallLButtonUp(UINT nFlags, CPoint point);
	void WallLButtonDblClk(UINT nFlags, CPoint point);
	void WallRButtonDown(UINT nFlags, CPoint point);
	void WallMouseMove(UINT nFlags, CPoint point);

	void DrawWallLine(CDC *pDC, CPoint ptStart, CPoint ptEnd, double dDistance, CPen &pen);

// Generated message map functions
protected:
	//{{AFX_MSG(CMapEditView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in MapEditView.cpp
inline CMapEditDoc* CMapEditView::GetDocument()
   { return (CMapEditDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAPEDITVIEW_H__6FB50F35_2986_4F79_9187_F5CFFC8E1AD2__INCLUDED_)
