#include "stdafx.h"
#include "Wall.h"

SWallPoint *SWallLine::GetPrevPoint(SWallPoint *pPoint)
{
	PNODE pNode = (PNODE) pPoint;
	ASSERT(m_listPoint.IsValidNode(pNode));
	return (SWallPoint *) m_listPoint.GetPrev(pNode);
}

SWallPoint *SWallLine::GetNextPoint(SWallPoint *pPoint)
{
	PNODE pNode = (PNODE) pPoint;
	ASSERT(m_listPoint.IsValidNode(pNode));
	return (SWallPoint *) m_listPoint.GetNext(pNode);
}

SWallPoint *SWallLine::InsertPoint(SWallPoint *pPoint, int x, int y)
{
	SWallPoint *pNewPoint;
	if (pPoint == NULL)
		pNewPoint = &m_listPoint.AddTail();
	else
		pNewPoint = &m_listPoint.InsertBefore((PNODE) pPoint);
	pNewPoint->SetPoint(x, y);
	return pNewPoint;
}

SWallPoint *SWallLine::FindPoint(CPoint point)
{
	for (PNODE pNode = m_listPoint.GetHead();pNode;pNode = m_listPoint.GetNext(pNode))
	{
		CRect rect;
		m_listPoint[pNode].GetRect(&rect);
		if (rect.PtInRect(point))
			return &m_listPoint[pNode];
	}
	return NULL;
}

SWallPoint *SWallLine::FindLine(CPoint point)
{
	PNODE pNode = m_listPoint.GetHead();
	for (pNode = m_listPoint.GetNext(pNode);pNode;pNode = m_listPoint.GetNext(pNode))
	{
		int xStart, yStart, xEnd, yEnd;
		m_listPoint[m_listPoint.GetPrev(pNode)].GetPoint(&xStart, &yStart);
		m_listPoint[pNode].GetPoint(&xEnd, &yEnd);

		int cx = xEnd - xStart, cy = yEnd - yStart;
		int x = point.x - xStart;
		int y = point.y - yStart;
		if (abs(cx) > abs(cy))
		{
			if (inrange(x, min(0, cx), max(0, cx)))
			{
				int yFind = x * cy / cx;
				if (inrange(y, yFind - 3, yFind + 4))
					return &m_listPoint[pNode];
			}
		}
		else
		{
			if (inrange(y, min(0, cy), max(0, cy)))
			{
				int xFind = y * cx / cy;
				if (inrange(x, xFind - 3, xFind + 4))
					return &m_listPoint[pNode];
			}
		}
	}
	return NULL;
}
