#ifndef __WALL_H__
#define __WALL_H__

class SWallAttributes
{
public:
	BOOL m_bMove;
	BOOL m_bThrough;
	BOOL m_bView;

	void SetAttributes(const SWallAttributes &attrib)
		{ *this = attrib; }
};

class SWallPoint : public SWallAttributes
{
public:
	int GetX()
		{ return m_x; }
	int GetY()
		{ return m_y; }
	void GetPoint(int *px, int *py)
		{ *px = m_x; *py = m_y; }
	void SetPoint(int x, int y)
		{ m_x = x; m_y = y; }
	void GetRect(CRect *pRect)
		{ pRect->SetRect(m_x - 4, m_y - 4, m_x + 4, m_y + 4); }

private:
	int m_x, m_y;
};

class SWallLine
{
public:
	int GetPointCount()
		{ return m_listPoint.GetCount(); }
	SWallPoint *GetFirstPoint()
		{ return (SWallPoint *) m_listPoint.GetHead(); }
	SWallPoint *GetLastPoint()
		{ return (SWallPoint *) m_listPoint.GetTail(); }
	SWallPoint *GetPrevPoint(SWallPoint *pPoint);
	SWallPoint *GetNextPoint(SWallPoint *pPoint);

public:
	SWallPoint *InsertPoint(SWallPoint *pPoint, int x, int y);
	void RemovePoint(SWallPoint *pPoint)
		{ m_listPoint.Remove((PNODE) pPoint); }

	SWallPoint *FindPoint(CPoint point);
	SWallPoint *FindLine(CPoint point);

private:
	SList<SWallPoint> m_listPoint;
};

#endif // __WALL_H__
