// WallAttributesFloatBar.cpp : implementation file
//

#include "stdafx.h"
#include "MapEdit.h"
#include "WallAttributesFloatBar.h"

#include "MapEditDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_MOVE_CHECK    1000
#define IDC_THROUGH_CHECK 1001
#define IDC_VIEW_CHECK    1002

/////////////////////////////////////////////////////////////////////////////
// CWallAttributesFloatBar

CWallAttributesFloatBar::CWallAttributesFloatBar()
{
}

CWallAttributesFloatBar::~CWallAttributesFloatBar()
{
}


BEGIN_MESSAGE_MAP(CWallAttributesFloatBar, CMiniFrameWnd)
	//{{AFX_MSG_MAP(CWallAttributesFloatBar)
	ON_WM_CREATE()
	ON_BN_CLICKED(IDC_MOVE_CHECK, OnClickedMoveCheck)
	ON_BN_CLICKED(IDC_THROUGH_CHECK, OnClickedThroughCheck)
	ON_BN_CLICKED(IDC_VIEW_CHECK, OnClickedViewCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWallAttributesFloatBar message handlers

BOOL CWallAttributesFloatBar::Create(CPoint point, CWnd *pParentWnd, UINT nID)
{
	static CString strClassName;
	if (strClassName.IsEmpty())
		strClassName = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
			AfxGetApp()->LoadStandardCursor(IDC_ARROW),
			(HBRUSH) (COLOR_3DFACE + 1));

	CRect rect(point.x, point.y, point.x + 100, point.y + 77);
	if (!CreateEx(WS_EX_TOOLWINDOW, strClassName, _T(" Ӽ"), WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU | MFS_SYNCACTIVE, rect, pParentWnd, 0))
		return FALSE;

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		pSysMenu->RemoveMenu(SC_RESTORE, MF_BYCOMMAND);
		pSysMenu->RemoveMenu(SC_MINIMIZE, MF_BYCOMMAND);
		pSysMenu->RemoveMenu(SC_MAXIMIZE, MF_BYCOMMAND);
	}
	return TRUE;
}

void CWallAttributesFloatBar::PostNcDestroy() 
{
}

int CWallAttributesFloatBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMiniFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_font.CreatePointFont(90, _T(""));

	CRect rect(16, 4, 16 + 50, 4 + 16);
	m_ctlMoveCheck.Create(_T("̵"), WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_AUTOCHECKBOX, rect, this, IDC_MOVE_CHECK);
	m_ctlMoveCheck.SetFont(&m_font);

	rect.OffsetRect(0, rect.Height());
	m_ctlThroughCheck.Create(_T(""), WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_AUTOCHECKBOX, rect, this, IDC_THROUGH_CHECK);
	m_ctlThroughCheck.SetFont(&m_font);

	rect.OffsetRect(0, rect.Height());
	m_ctlViewCheck.Create(_T("þ"), WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_AUTOCHECKBOX, rect, this, IDC_VIEW_CHECK);
	m_ctlViewCheck.SetFont(&m_font);
	return 0;
}

void CWallAttributesFloatBar::OnClickedMoveCheck()
{
	GetDocument()->GetWallAttributes()->m_bMove = m_ctlMoveCheck.GetCheck();
}

void CWallAttributesFloatBar::OnClickedThroughCheck()
{
	GetDocument()->GetWallAttributes()->m_bThrough = m_ctlThroughCheck.GetCheck();
}

void CWallAttributesFloatBar::OnClickedViewCheck()
{
	GetDocument()->GetWallAttributes()->m_bView = m_ctlViewCheck.GetCheck();
}

CMapEditDoc *CWallAttributesFloatBar::GetDocument()
{
	CFrameWnd *pFrame = ((CFrameWnd *) AfxGetMainWnd());
	ASSERT_VALID(pFrame);
	CMapEditDoc *pDoc = (CMapEditDoc *) pFrame->GetActiveDocument();
	ASSERT_VALID(pDoc);
	return pDoc;
}

void CWallAttributesFloatBar::Update(CMapEditDoc *pDoc)
{
	SWallAttributes *pAttrib = pDoc->GetWallAttributes();
	m_ctlMoveCheck.SetCheck(pAttrib->m_bMove);
	m_ctlThroughCheck.SetCheck(pAttrib->m_bThrough);
	m_ctlViewCheck.SetCheck(pAttrib->m_bView);
}
