     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// animation.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "animation.h"
#include "graphic_directional.h"

extern string g_sAnimFolder;
///////////////////////////////////////////////////////////////////////////////
// cAnimation 
///////////////////////////////////////////////////////////////////////////////
cGraphic_Source* cAnimation :: CreateAnimSource( ANIM_STYLE AnimStyle)
{	
	switch( AnimStyle)
    {
    case AS_SEQUENCE_GRAPHIC   : return new cGraphic_Sequence    < cGraphic >       ();    
	case AS_SEQUENCE_TEXTURE   : return new cGraphic_Sequence    < cTexture >       (); 

	case AS_DIRECTIONAL_GRAPHIC: return new cGraphic_Directional < cGraphic >       (); 
	case AS_DIRECTIONAL_TEXTURE: return new cGraphic_Directional < cTexture >       (); 
	case AS_DIRECTIONAL_COSTUME: return new cGraphic_Directional < cCostume_Order > ();
    
	}  	

	return NULL;
}
///////////////////////////////////////////////////////////////////////////////
// cAnimation_Normal
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Normal :: Clear()
{
	SAFE_DELETE( m_pAnimSource);
	SAFE_DELETE_ARRAY( m_pFrames);
}

///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Normal :: LoadAnimSource( string sFilePath, ANIM_STYLE AnimStyle)
{
	m_AnimStyle   = AnimStyle;
    m_pAnimSource = CreateAnimSource( AnimStyle);

	if( !m_pAnimSource)
		return Fail( this, "ANIMATION_ERR_CREATEANIMSOURCE");

	if( ! :: Load( m_pAnimSource, sFilePath))
		return Fail( this, "ANIMATION_ERR_LOAD_SOURCE");
    
	m_AnimInfo.uTotalFrame = m_pAnimSource->GetSequenceNum(); 
    m_pFrames              = new FRAME[ m_AnimInfo.uTotalFrame];

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Normal :: Save( cFile& file)
{
	file.Write( &m_AnimStyle, sizeof( ANIM_STYLE));
	file.Write( &m_AnimInfo, sizeof( ANIM_INFO));

	if( !m_pAnimSource->Save( file))
		return Fail( this, "ANIMATION_ERR_SAVE");
	   
	int iframe = m_AnimInfo.uTotalFrame;
	for( int i = 0; i < iframe; i++)
	{
		file.Write( &m_pFrames[ i], sizeof( FRAME));
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Normal :: Load( cFile& file)
{
    file.Read( &m_AnimStyle, sizeof( ANIM_STYLE));
	file.Read( &m_AnimInfo, sizeof( ANIM_INFO));

	m_pAnimSource = CreateAnimSource( m_AnimStyle);
	
	if( m_pAnimSource != NULL && !m_pAnimSource->Load( file))
		return Fail( this, "ANIMATION_ERR_SAVE");

	int iframe = m_AnimInfo.uTotalFrame;
	m_pFrames = new FRAME[ iframe];
	   
	for( int i = 0; i < iframe; i++)
	{
		file.Read( &m_pFrames[ i], sizeof( FRAME));
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
void* cAnimation_Normal :: GetGraphic( cAnimation_StatePtr pAnimState) const
{
	assert( m_pAnimSource);
	assert( pAnimState);
    
	if( !m_pAnimSource) return NULL;
	if( !pAnimState) return NULL;

	return m_pAnimSource->GetGraphic( pAnimState);
}
///////////////////////////////////////////////////////////////////////////////
void* cAnimation_Normal :: GetGraphic( int iFrame, int iDir, int iAnim) const
{
	assert( m_pAnimSource);
    
	if( !m_pAnimSource) return NULL;
	return m_pAnimSource->GetGraphic( iFrame, iDir, iAnim);
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Normal :: Draw( cAnimation_StatePtr pAnimState, int x, int y)
{
    assert( m_pAnimSource);

    if( !m_pAnimSource) return false;
	return m_pAnimSource->Draw( pAnimState, x, y);
}
///////////////////////////////////////////////////////////////////////////////
int cAnimation_Normal :: UpdateFrame( cAnimation_StatePtr pAnimState)
{
	assert( m_pAnimSource);
	assert( pAnimState);

	int frame = pAnimState->GetFrame();

	if( !m_pAnimSource) return 0;
	if( pAnimState->GetDelay() >= m_pFrames[ frame].uDelay) 
    { 
		if( frame >= m_AnimInfo.uTotalFrame - 1) pAnimState->ResetFrame();
		else pAnimState->UpdateFrame();

		pAnimState->ResetDelay();
		return  1;
	}
	else
	{
		pAnimState->UpdateDelay();
        return - 1;
	}
}
///////////////////////////////////////////////////////////////////////////////
FRAMEPtr cAnimation_Normal :: GetFrames( int iFrame)
{
	if( iFrame >= m_AnimInfo.uTotalFrame) return NULL;
	else return &m_pFrames[ iFrame];
}
///////////////////////////////////////////////////////////////////////////////
// cAnimation_Monster
///////////////////////////////////////////////////////////////////////////////
cAnimation_Monster :: cAnimation_Monster()
{
	m_iNumAnim = 0;
	for( int i = 0 ; i < AT_NUM; i++)
	{
		m_pNormalAnim[ i] = NULL;
	}
}
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Monster :: Clear()
{
    for( int i = 0; i < AT_NUM ; i++)
	{
		SAFE_DELETE( m_pNormalAnim[ i]);	
	}
}
///////////////////////////////////////////////////////////////////////////////
// wait, walk, attack  ִϸ̼ .
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Monster :: LoadAnimSource( string sFilePath, ANIM_STYLE AnimStyle)
{  
    for( int i = 0 ; i < AT_NUM ; i++)
	{	
		string sFileName  = sFilePath;
		sFileName        += "/";
	    sFileName        += GetAnimName( i);
		sFileName        += ".ani";
		m_pNormalAnim[ i] = new cAnimation_Normal();
		
		if( ! :: Load( m_pNormalAnim[ i], sFileName))
		{
			SAFE_DELETE( m_pNormalAnim[ i]);  
		}
		else ++m_iNumAnim;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
string cAnimation_Monster :: GetAnimName( int at)
{
	if( at == AT_WAIT)        return string( "Wait");
	if( at == AT_WALK)        return string( "Walk");
	if( at == AT_WALK_START)  return string( "Walk_Start");
	if( at == AT_ATTACK)      return string( "Attack");
	if( at == AT_SPELL)       return string( "Spell");

	return string();
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Monster ::  Load( cFile& file)
{
	BYTE ExistAnim;

	file.Read( & m_iNumAnim, sizeof( BYTE));
    for( BYTE i = 0 ; i < m_iNumAnim ; i++)
	{
		file.Read( &ExistAnim, sizeof( BYTE)); 
		if( !m_pNormalAnim[ ExistAnim]) m_pNormalAnim[ ExistAnim] = new cAnimation_Normal();
		if( !m_pNormalAnim[ ExistAnim]->Load( file)) 
				return Fail( this, "ANIMATION_CHARACTER_ERR_SAVE"); 
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Monster :: Save( cFile& file)
{
	file.Write(&m_iNumAnim, sizeof( BYTE));
    for( int i = 0 ; i < AT_NUM ; i++)
	{
		if( m_pNormalAnim[ i]) 
		{
			file.Write( &i, sizeof( BYTE));
			if( !m_pNormalAnim[ i]->Save( file)) 
				return Fail( this, "ANIMATION_CHARACTER__ERR_SAVE"); 
		}
	}
    
	return true;
}
///////////////////////////////////////////////////////////////////////////////
void* cAnimation_Monster :: GetGraphic( cAnimation_StatePtr pAnimState) const
{
	assert( pAnimState);
	if( !pAnimState) return NULL;

	int iAnim = pAnimState->GetAnimType();
	assert( m_pNormalAnim[ iAnim]);

	if( !m_pNormalAnim[ iAnim]) return NULL;
	return m_pNormalAnim[ iAnim]->GetGraphic( pAnimState);
}
///////////////////////////////////////////////////////////////////////////////
void* cAnimation_Monster :: GetGraphic( int iFrame, int iDir, int iAnim) const
{
	assert( m_pNormalAnim[ iAnim]);

	if( !m_pNormalAnim[ iAnim]) return NULL;
	return m_pNormalAnim[ iAnim]->GetGraphic( iFrame, iDir, iAnim);
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Monster :: Draw( cAnimation_StatePtr pAnimState, int x, int y)
{
	assert( pAnimState);		
	assert( m_pNormalAnim[ pAnimState->GetAnimType()]);
	int AnimType = pAnimState->GetAnimType();

    if( !pAnimState) return false;
	if( !m_pNormalAnim[ AnimType]) return false;

    return m_pNormalAnim[ AnimType]->Draw( pAnimState, x, y);
}
///////////////////////////////////////////////////////////////////////////////
int cAnimation_Monster :: UpdateFrame( cAnimation_StatePtr pAnimState)
{
	assert( pAnimState);
    assert( m_pNormalAnim[ pAnimState->GetAnimType()]);
	int AnimType = pAnimState->GetAnimType();

	if( !pAnimState) return 0;
	if( !m_pNormalAnim[ AnimType]) return 0;
	return m_pNormalAnim[ AnimType]->UpdateFrame( pAnimState);
}
///////////////////////////////////////////////////////////////////////////////
// cAnimation_Hero
///////////////////////////////////////////////////////////////////////////////
void cAnimation_Hero :: Clear()
{
	cAnimation_Monster :: Clear();

	for( int i = 0; i < CT_NUM; i++)
	{
		m_CostumeStorages[ i].Clear();
	}
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Hero :: Draw( cAnimation_State* pAnimState, int x, int y)
{
	assert( pAnimState);

	if( !pAnimState) return false;
	cGraphic_Costume* pCostumeSrc = NULL;
	cCostume_OrderPtr pco = ( cCostume_OrderPtr) GetGraphic( pAnimState);
	
	for( int i = 0; i < CT_NUM; i++)
	{
		pCostumeSrc = ( cGraphic_Costume* ) pAnimState->GetCostume( pco->GetCostumeOrder( i));

		if( !pCostumeSrc) return false;
//		pAnimState->SetDrawFlag( DF_SLOPED_SHADOW);
		pCostumeSrc->Draw( pAnimState, x, y);

//		pAnimState->SetDrawFlag( DF_NORMAL);
//		pCostumeSrc->Draw( pAnimState, x, y);
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
cGraphic_CostumePtr cAnimation_Hero :: PutonCostume( COSTUME_INFO ci)
{
	if(  ci.uType >= CT_NUM) return NULL;
	return m_CostumeStorages[  ci.uType].PutonCostume(  ci);
}
///////////////////////////////////////////////////////////////////////////////
cGraphic_CostumePtr cAnimation_Hero :: FindCostume( COSTUME_INFO ci)
{
	if(  ci.uType >= CT_NUM) return NULL;
	return m_CostumeStorages[  ci.uType].FindCostume(  ci);
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Hero :: TakeoffCostume( COSTUME_INFO ci)
{
	if(  ci.uType >= CT_NUM) return false;
	return m_CostumeStorages[  ci.uType].TakeoffCostume(  ci);
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Hero :: PutonStartingCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci)
{
    for( int i = 0; i < CT_NUM; i++)
	{
		ci.uType  = i;
		ci.uLevel = pAnimState->GetLevel( i);
    	cGraphic_CostumePtr pCostumeSrc = PutonCostume( ci);

		if( !pCostumeSrc) return Fail( this, "ANIMATION_HERO_PUTONSTARTINGCOSTUME");
        pAnimState->SetCostume( ci.uType, pCostumeSrc);
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cAnimation_Hero :: PutonCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci)
{
    COSTUME_INFO oldci  = ci;
	oldci.uLevel = pAnimState->GetLevel( oldci.uType);
	if( TakeoffCostume( oldci)) //   ´.
    {
		cGraphic_CostumePtr pCostumeSrc = PutonCostume( ci);
        pAnimState->SetCostume( ci.uType, pCostumeSrc);
	    pAnimState->SetLevel( ci.uType, ci.uLevel);

		return true;
	}

	return false;

}