     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// animation.h
///////////////////////////////////////////////////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
///////////////////////////////////////////////////////////////////////////////
#ifndef _ANIMATION_H_
#define _ANIMATION_H_

#ifndef _GRAPHIC_COSTUME_H_
#include "graphic_costume.h"
#endif

#ifndef _COSTUME_STORAGE_H_
#include "costume_storage.h"
#endif

#ifndef _ANIMATION_STATE_H_
#include "animation_state.h"
#endif

///////////////////////////////////////////////////////////////////////////////
enum ANIM_STYLE
{
    AS_SEQUENCE_GRAPHIC,
	AS_SEQUENCE_TEXTURE,
	
	AS_DIRECTIONAL_GRAPHIC,
	AS_DIRECTIONAL_TEXTURE,
	AS_DIRECTIONAL_COSTUME,

	AS_CHARACTER,
	AS_NUM
};

///////////////////////////////////////////////////////////////////////////////
// ANIM_INFO
///////////////////////////////////////////////////////////////////////////////
typedef struct ANIM_INFO
{
	DWORD   uTotalFrame :  6;
    DWORD   uSound      : 26;

} ANIM_INFO, * ANIM_INFOPtr;
///////////////////////////////////////////////////////////////////////////////
typedef struct FRAME
{	
	BYTE    uDelay   : 4; //  
	BYTE    bLaunch  : 1; // Ư ִϸ̼ ´.
	BYTE    bSound   : 1; // Ư 尡 ´.
    
	BYTE    uPad     : 2;

	FRAME()  
	{
		uDelay  = 0; // test
		bLaunch = bSound = 0;
	}


} FRAME, * FRAMEPtr;

///////////////////////////////////////////////////////////////////////////////
// cAnimation
///////////////////////////////////////////////////////////////////////////////
typedef class cAnimation
{
public:
	cAnimation() {}
	virtual ~cAnimation() {}

	virtual void                Clear() = 0;

	virtual bool                Save( cFile& file) = 0;
	virtual bool                Load( cFile& file) = 0;
	virtual bool                LoadAnimSource( string sFilePath, ANIM_STYLE AnimStyle) { return true;}

	virtual void*               GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const { return NULL;}
	virtual void*               GetGraphic( cAnimation_StatePtr) const { return NULL;}
	virtual FRAMEPtr            GetFrames( int Frame) { return NULL;}
   
	virtual bool                Draw( cAnimation_StatePtr pAnimState, int x, int y) { return true;}
	virtual int                 UpdateFrame( cAnimation_StatePtr pAnimState) { return 1;}

	virtual cGraphic_CostumePtr PutonCostume( COSTUME_INFO ci) { return NULL;}
	virtual cGraphic_CostumePtr FindCostume( COSTUME_INFO ci) { return NULL;}
	virtual bool                TakeoffCostume( COSTUME_INFO ci) { return true;}

	virtual bool                PutonStartingCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci) { return true;}
    virtual bool                PutonCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci) { return true;}
	virtual bool                TakeoffCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci) { return true;}

protected:
    cGraphic_Source*            CreateAnimSource( ANIM_STYLE AnimStyle);

} cAnimation, * cAnimationPtr;
///////////////////////////////////////////////////////////////////////////////
// cAnimation_Mormal
///////////////////////////////////////////////////////////////////////////////
typedef class cAnimation_Normal : public cAnimation
{
public:
	cAnimation_Normal() { m_pAnimSource = NULL; m_pFrames = NULL;}
	virtual ~cAnimation_Normal() { Clear();}

	void     Clear();

	bool     Save( cFile& file);
	bool     Load( cFile& file);
	bool     LoadAnimSource( string sFilePath, ANIM_STYLE AnimStyle);

	void*    GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const;
	void*    GetGraphic( cAnimation_StatePtr) const;
	FRAMEPtr GetFrames( int Frame);
   
	bool     Draw( cAnimation_StatePtr pAnimState, int x, int y);
	int      UpdateFrame( cAnimation_StatePtr pAnimState);

	void     SetAnimStyle( ANIM_STYLE AnimStyle) { m_AnimStyle = AnimStyle;}

    ////////////////////////////////
protected:
    cGraphic_Source* m_pAnimSource;
    ANIM_STYLE       m_AnimStyle;
	ANIM_INFO        m_AnimInfo;
    FRAMEPtr         m_pFrames;
	
} cAnimation_Normal, * cAnimation_NormalPtr;
///////////////////////////////////////////////////////////////////////////////
// cAnimation_Monster
///////////////////////////////////////////////////////////////////////////////
typedef class cAnimation_Monster : public cAnimation
{
public:
	cAnimation_Monster();
	virtual ~cAnimation_Monster() { Clear();}

	void       Clear();
    
	bool       Save( cFile& file);
	bool       Load( cFile& file);
	bool       LoadAnimSource( string sFilePath, ANIM_STYLE AnimStyle);

	void*      GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const;
   	void*      GetGraphic( cAnimation_StatePtr) const;	

	bool       Draw( cAnimation_StatePtr pAnimState, int x, int y);
	int        UpdateFrame( cAnimation_StatePtr pAnimState);

	string     GetAnimName( int at);

	////////////////////////////////////////////////
protected:
	cAnimation_Normal*  m_pNormalAnim[ AT_NUM];
	BYTE                m_iNumAnim;

} cAnimation_Monster, * cAnimation_MonsterPtr;

///////////////////////////////////////////////////////////////////////////////
// cAnimation_Hero
///////////////////////////////////////////////////////////////////////////////
typedef class cAnimation_Hero : public cAnimation_Monster
{
public:
    cAnimation_Hero() {} 
    virtual ~cAnimation_Hero() { Clear();}

    void                Clear();

    bool                Draw( cAnimation_StatePtr pAnimState, int x, int y);

	cGraphic_CostumePtr PutonCostume( COSTUME_INFO ci);
	cGraphic_CostumePtr FindCostume( COSTUME_INFO ci);
	bool                TakeoffCostume( COSTUME_INFO ci);
	
	bool                PutonStartingCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci);
    bool                PutonCostume( cAnimation_StatePtr pAnimState, COSTUME_INFO ci);
	
protected:
	cCostume_Storage    m_CostumeStorages[ CT_NUM];
	string              m_sStorageFolder;

} cAnimation_Hero, * cAnimation_HeroPtr;
///////////////////////////////////////////////////////////////////////////////
#endif // _ANIMATION_H_