     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// costume_storage.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "costume_storage.h"
///////////////////////////////////////////////////////////////////////////////
void cCostume_Storage :: Clear()
{
	COSTUME costume;
	int size = m_mapCostumeStg.size();
    mapCostumeStorage :: iterator iter = m_mapCostumeStg.begin();

	for( int i = 0; i < size; i++)
	{
	   costume = ( *iter++).second;
	   SAFE_DELETE( costume.pCostumeSrc);
	} 
	
	m_mapCostumeStg.clear();   
}
///////////////////////////////////////////////////////////////////////////////
cGraphic_CostumePtr cCostume_Storage :: LoadCostume( string sFilePath)
{
	cGraphic_CostumePtr pCostumeSrc = new cGraphic_Costume();

	if( !:: Load( pCostumeSrc, sFilePath))
	{
		SAFE_DELETE( pCostumeSrc);
		return NULL;
	}
	
    return pCostumeSrc;
}
///////////////////////////////////////////////////////////////////////////////
cGraphic_CostumePtr cCostume_Storage :: PutonCostume( COSTUME_INFO ci)
{
	mapCostumeStorage :: iterator iter = m_mapCostumeStg.find( ci.uLevel);
	if( iter == m_mapCostumeStg.end()) // ó ش costume ҿ   
	{
		COSTUME Costume;
		string sFilePath     = GetFilePath( ci);
		Costume.uPriority    = 1;
		Costume.pCostumeSrc  = LoadCostume( sFilePath ); 

		m_mapCostumeStg[ ci.uLevel] = Costume;
		return Costume.pCostumeSrc;
	}
	else // ̹   
	{
        COSTUMEPtr pCostume  = &( iter->second);
		pCostume->uPriority += 1;

		return pCostume->pCostumeSrc;
	}
}
///////////////////////////////////////////////////////////////////////////////
bool cCostume_Storage :: TakeoffCostume( COSTUME_INFO ci) 
{
	mapCostumeStorage :: iterator iter = m_mapCostumeStg.find( ci.uLevel);
	if( iter != m_mapCostumeStg.end())
	{
        COSTUMEPtr pCostume  = &( iter->second);
		pCostume->uPriority -= 1;

		if( pCostume->uPriority == 0)
		{
			SAFE_DELETE( pCostume->pCostumeSrc);
			m_mapCostumeStg.erase( ci.uLevel);
		}
		
		return true;
	}
	
	return false;
}   
///////////////////////////////////////////////////////////////////////////////
cGraphic_CostumePtr cCostume_Storage :: FindCostume( COSTUME_INFO ci)
{
	mapCostumeStorage :: iterator iter = m_mapCostumeStg.find( ci.uLevel);
	if( iter != m_mapCostumeStg.end()) 
	{
       COSTUMEPtr pCostume = &( iter->second);
	   return pCostume->pCostumeSrc;
	}
	else return NULL;

}
///////////////////////////////////////////////////////////////////////////////
string cCostume_Storage :: GetFilePath( COSTUME_INFO ci)
{
    char num[ 15];
	itoa( ci.uLevel, num, 10);
    
	string sFilePath( "G:/׸/kai"); // TEST
	sFilePath       += "/";
	sFilePath       += GetCostumeName( ci.uType);
	sFilePath       += string( num); 
	sFilePath       += ".cst";      
	
	return sFilePath;
}
///////////////////////////////////////////////////////////////////////////////
string cCostume_Storage :: GetCostumeName( int iType)
{
	if( iType == CT_HEAD)  return string( "Head");
	if( iType == CT_BODY)  return string( "Body");
	if( iType == CT_LHAND) return string( "LHand");
	if( iType == CT_RHAND) return string( "RHand");
	if( iType == CT_LEG)   return string( "Leg");
	if( iType == CT_CLOAK) return string( "Cloak");

	return string();
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
