     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000


// d3dutil.h
///////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif 

#ifndef _D3DUTIL_H_
#define _D3DUTIL_H_

#define D3D_OVERLOADS
#include <ddraw.h>
#include <d3d.h>

///////////////////////////////////////////////////////////////////
void D3DUtil_InitSurfaceDesc( DDSURFACEDESC2& ddsd, DWORD dwFlags = 0, DWORD dwCaps = 0 );

void D3DUtil_InitMaterial( D3DMATERIAL7& mtrl, float r = 0.0f, float g = 0.0f, float b = 0.0f, float a = 1.0f );

void D3DUtil_InitLight( D3DLIGHT7& light, D3DLIGHTTYPE ltType, float x = 0.0f, float y = 0.0f, float z = 0.0f );

void D3DUtil_SetTranslateMatrix( D3DMATRIX& m, float tx, float ty, float tz );

HRESULT D3DUtil_SetViewMatrix( D3DMATRIX& mat, D3DVECTOR& vFrom, D3DVECTOR& vAt, D3DVECTOR& vUp );

HRESULT D3DUtil_SetProjectionMatrix( D3DMATRIX& mat, FLOAT fFOV = 1.570795f,
                                     float fAspect = 1.0f,
                                     float fNearPlane = 1.0f,
                                     float fFarPlane = 1000.0f );

inline VOID D3DUtil_SetIdentityMatrix( D3DMATRIX& m )
{
    m._12 = m._13 = m._14 = m._21 = m._23 = m._24 = 0.0f;
    m._31 = m._32 = m._34 = m._41 = m._42 = m._43 = 0.0f;
    m._11 = m._22 = m._33 = m._44 = 1.0f;
}

inline VOID D3DUtil_SetTranslateMatrix( D3DMATRIX& m, FLOAT tx, FLOAT ty,
                                        FLOAT tz )
{  m._41 = tx; m._42 = ty; m._43 = tz; }

inline VOID D3DUtil_SetTranslateMatrix( D3DMATRIX& m, D3DVECTOR& v )
{ D3DUtil_SetTranslateMatrix( m, v.x, v.y, v.z ); }

inline VOID D3DUtil_SetScaleMatrix( D3DMATRIX& m, FLOAT sx, FLOAT sy,
                                    FLOAT sz )
{ m._11 = sx; m._22 = sy; m._33 = sz; }

inline VOID SetScaleMatrix( D3DMATRIX& m, D3DVECTOR& v )
{ D3DUtil_SetScaleMatrix( m, v.x, v.y, v.z ); }

/////////////////////////////////////////////////////////////////////////////
typedef struct TEXTUREINFO
{
	DWORD          dwDesiredBPP;   // Input for texture format search
    bool           bUseAlpha;
    bool           bUsePalette;
    bool           bFoundGoodFormat;

    DDPIXELFORMAT* pddpf; // Output of texture format search

} TEXTUREINFO, * TEXTUREINFOPtr;
/////////////////////////////////////////////////////////////////////////////


#endif// _D3DUTIL_H_