     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// file.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "file.h"
#include <fcntl.h>    // _O_RDONLY ....
#include <sys/stat.h> // _S_IWRITE ....

#if defined(_MSC_VER) // microsoft compiler
#define  O_RDONLY   _O_RDONLY
#define  O_WRONLY   _O_WRONLY
#define  O_CREAT    _O_CREAT
#define  S_IREAD    _S_IREAD
#define  S_IWRITE   _S_IWRITE
#define  open       _open
#define  close      _close
#define  write      _write
#define  read       _read
#define  lseek      _lseek
#define  tell       _tell
#define  findfirst	_findfirst
#define  findnext   _findnext
#define  findclose	_findclose
#define  finddata_t _finddata_t

#endif
///////////////////////////////////////////////////////////////////////////////
// cFile
///////////////////////////////////////////////////////////////////////////////
cFile :: cFile( string sFilePath, FILE_FLAGS fFlag)
{
	if( fFlag == FF_NO_IO) return;

	if( fFlag == FF_READ) Open( sFilePath);
	else if( fFlag == FF_WRITE) Create( sFilePath);
	else m_fFlag = FF_NO_IO;
}
///////////////////////////////////////////////////////////////////////////////
cFile :: ~cFile()
{
	if( m_fFlag != FF_NO_IO) close( m_hFile); 
}
///////////////////////////////////////////////////////////////////////////////
cFile :: FILE_ERR
cFile :: Create( string sFilePath)
{
    m_hFile = open( sFilePath.c_str(), O_WRONLY | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
	if( m_hFile == -1) m_fFlag = FF_NO_IO;
	else m_fFlag = FF_WRITE;

	return Status();
}
///////////////////////////////////////////////////////////////////////////////
cFile :: FILE_ERR
cFile :: Open( string sFilePath)
{
	m_hFile = open( sFilePath.c_str(), O_RDONLY | O_BINARY, S_IWRITE | S_IREAD);
	if( m_hFile == - 1) m_fFlag = FF_NO_IO;
	else m_fFlag = FF_READ;

	return Status();
}
///////////////////////////////////////////////////////////////////////////////
cFile :: FILE_ERR  
cFile :: Status()
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////		
cFile :: FILE_ERR  
cFile :: Write ( void* data, int size )
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	if( m_fFlag == FF_READ) return FE_NOT_READABLE;

	int val = write( m_hFile, data, size );

	if (val == -1) return FE_PROBLEM;
	return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////
cFile :: FILE_ERR  
cFile :: Read ( void* data, int size )
{
	if( m_fFlag == FF_NO_IO) return FE_PROBLEM;
	if( m_fFlag == FF_WRITE) return FE_NOT_WRITABLE;

	int val = read( m_hFile, data, size );
	if( val == -1) return FE_PROBLEM;
    return FE_NONE;
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: Seek( int where)
{
	if( m_fFlag == FF_NO_IO) return -1;
	if( lseek( m_hFile, where, SEEK_SET) == -1) return -1;

	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: Advance( int howmuch)
{
	if( m_fFlag == FF_NO_IO) return -1; 
	if( lseek( m_hFile, howmuch, SEEK_CUR) == -1) return -1;

	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////
int cFile :: SeekFromEnd( int where)
{
	if( m_fFlag == FF_NO_IO) return -1;
	if( lseek( m_hFile, where, SEEK_END) == -1) return -1;

	return ( int ) tell( m_hFile);
}
///////////////////////////////////////////////////////////////////////////////
// cFile_Package
///////////////////////////////////////////////////////////////////////////////
cFile_Package :: cFile_Package()
{
	m_dwOffset = 0;
}
///////////////////////////////////////////////////////////////////////////////
cFile_Package :: ~cFile_Package()
{
    Clear();
}
///////////////////////////////////////////////////////////////////////////////
void cFile_Package :: Clear()
{
    m_mapPack.clear();
}
///////////////////////////////////////////////////////////////////////////////
bool cFile_Package :: BuildFilePackage( string sPackageFile, string sBaseDir)
{
	m_sBaseDir = sBaseDir;

    if( ReadDirectory( sBaseDir) == 0)
        return Fail( this, "FILE_PACKAGE_ERR_BUILDFILEPACKAGE");
    
	if( Create( sPackageFile) != FE_NONE) return false;

	mapPackPtr begin = m_mapPack.begin();
	mapPackPtr end   = m_mapPack.end();
    
	CalculateOffset( begin, end);
	SaveDirectory( begin, end);
	SaveFiles( begin, end);
	
    return true;
}
///////////////////////////////////////////////////////////////////////////////
void cFile_Package :: SaveDirectory( mapPackPtr begin, mapPackPtr end)
{
	assert( m_mapPack.empty() == false);
	if( m_mapPack.empty() == true) return;

	int Size = m_mapPack.size();
	Write( &Size, sizeof( int));
	
	mapPackPtr iter = begin;
	while( iter != end)
	{
		string sFilePath( iter->first);
		PACK pack = iter->second;
	   
		BYTE s = sFilePath.size();
		Write( &s, sizeof( BYTE));
        Write( ( void*) sFilePath.c_str(), s);
		Write( &pack, sizeof( PACK));
		++iter;		
	}
}
///////////////////////////////////////////////////////////////////////////////
cFile& cFile_Package :: FindFile( string sFilePath)
{	
	assert( m_mapPack.empty() == false);
    
	if( m_mapPack.empty() == false)
	{
		PACK* pPack = FindPack( sFilePath);
		if( pPack != NULL) 
		{
			Seek( pPack->uOffset);
			return *this;
		}
		
	}

    assert( !"not exist file");
	m_fFlag = FF_NO_IO;
	
	return  *this; //
}
///////////////////////////////////////////////////////////////////////////////
void cFile_Package :: SaveFiles( mapPackPtr begin, mapPackPtr end)
{
	assert( m_mapPack.empty() == false);
	if( m_mapPack.empty() == true) return;

	mapPackPtr iter = begin;
	while( iter != end)
	{
        string sFilePath = m_sBaseDir + "/";	
	    string s( iter->first);
	    sFilePath += s;
		PACK pack = iter->second;

		cFile file( sFilePath, FF_READ);
		BYTE* pData = new BYTE[ pack.uSize];

		file.Read( pData, pack.uSize);
		Write( pData, pack.uSize);
		SAFE_DELETE_ARRAY( pData);
		++iter;		
	}
}
///////////////////////////////////////////////////////////////////////////////
void cFile_Package :: CalculateOffset( mapPackPtr begin, mapPackPtr end)
{
	assert( m_mapPack.empty() == false);
	if( m_mapPack.empty() == true) return;

	m_dwOffset += sizeof( int);
	mapPackPtr iter = begin;
	
	while( iter != end)
	{
		PACK pack   = iter->second;
	    m_dwOffset += pack.uStrSize + sizeof( PACK) + sizeof( BYTE); 
		++iter;		
	}

	iter = begin;
	while( iter != end)
	{
       	PACK* pPack    = &iter->second;
	    pPack->uOffset = m_dwOffset;
		m_dwOffset    += pPack->uSize;
		++iter;
	}
}
///////////////////////////////////////////////////////////////////////////////
int cFile_Package :: ReadDirectory( string sDir)
{
	int  count = 0;
	PACK pack;
    finddata_t data;
	char cwd[ 255];

	memset( &data, 0, sizeof ( _finddata_t));
	data.attrib = _A_SUBDIR;
	_getcwd( cwd, 255);//  ۾ 丮  

	if( _chdir( sDir.c_str()) == 0) 
	{
		long ID;
		long done = ID = findfirst( "*", &data);
		while( done != -1)
		{	
			string sSubDir = sDir;
			string sDirName( data.name);

			if( sDirName != "." && sDirName != ".." )
			{	
				sSubDir += "/";
				sSubDir += sDirName;
				++count;

				if( sDirName.rfind( ".") != - 1)
				{
					int pos = sSubDir.find_first_not_of( m_sBaseDir);
				    sSubDir.erase( 0, pos);

					pack.uSize    = data.size;
                    pack.uStrSize = sSubDir.size();
					
					m_mapPack[ sSubDir] = pack; // offset 0 ʱȭ Ѵ.
				} 
			    else ReadDirectory( sSubDir);
			}
			done = findnext( ID, &data );
		
		}
		findclose( ID ); 
		_chdir( cwd);
	}

	return count;
}
///////////////////////////////////////////////////////////////////////////////
bool cFile_Package :: LoadFilePackage( string sFilePath)
{
	if( Open( sFilePath) != FE_NONE) 
		return Fail( this, "FILE_PACKAGE_ERR_LOADFILEPACKAGE");

	int size;
	char sStr[ 100];
	Read( &size, sizeof( int));

	if( size == 0) return false;
	for( int i = 0; i < size; i++)
	{
		memset( sStr, 0, 100);
		BYTE s;
		PACK pack;

		Read( &s, sizeof( BYTE));
		Read( sStr, s);
        Read( &pack, sizeof( PACK));

		string sFilePath( sStr);
		m_mapPack[ sFilePath] = pack;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
PACK* cFile_Package :: FindPack( string sName)
{
	assert( m_mapPack.empty() == false);
	if( m_mapPack.empty() == true) return NULL;

	mapPackPtr end  = m_mapPack.end();
	mapPackPtr iter = m_mapPack.find( sName);
	
	if( iter != end) return &( iter->second);
	else return NULL;
}
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
