     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// file.h
///////////////////////////////////////////////////////////////////////////////
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef _FILE_H_
#define _FILE_H_

#ifndef _STRUCT_H_
#include "struct.h"
#endif

#ifndef _SINGLETON_H_
#include "singleton.h"
#endif

typedef int FILE_HANDLE;
///////////////////////////////////////////////////////////////////////////////
// PACK
///////////////////////////////////////////////////////////////////////////////
typedef struct PACK
{
	DWORD uSize    : 25;
	DWORD uStrSize :  7;
	DWORD uOffset;

} PACK, * PACKPtr;
///////////////////////////////////////////////////////////////////////////////
// cFile
///////////////////////////////////////////////////////////////////////////////
typedef class cFile
{
public:
    enum FILE_FLAGS { FF_NO_IO, FF_READ, FF_WRITE };
	enum FILE_ERR { FE_NONE, FE_NOT_READABLE, FE_NOT_WRITABLE, FE_PROBLEM };

public:
	cFile() { m_fFlag = FF_NO_IO; m_hFile = 0;}
	cFile( string sFileName, FILE_FLAGS fFlag);
	virtual ~cFile();

	FILE_ERR         Create( string sFileName);
	FILE_ERR         Open( string sFileName);
	FILE_ERR         Status();					
	FILE_ERR         Write( void* data, int size );
	FILE_ERR         Read( void* data, int size );

	int              Seek( int where);
	int              Advance( int howmuch);
	int              SeekFromEnd( int where);

protected:
    FILE_FLAGS       m_fFlag;
	FILE_HANDLE      m_hFile;
	   
} cFile, * cFilePtr;

typedef map < string, PACK > mapPack;
typedef mapPack :: iterator  mapPackPtr;
///////////////////////////////////////////////////////////////////////////////
// cFile_Package
///////////////////////////////////////////////////////////////////////////////
typedef class cFile_Package : public cFile
{
public:
	cFile_Package();
	virtual ~cFile_Package();

	void             Clear();
	bool             BuildFilePackage( string sPackageFile, string sDir);
    cFile&           FindFile( string sFilePath);
	int              ReadDirectory( string sDirName);

	void             InsertPack( string sName, PACK pack);
	void             ErasePack( string sName);
	PACK*            FindPack( string sName);

	bool             LoadFilePackage( string sFilePath);

protected:
    void             SaveDirectory( mapPackPtr begin, mapPackPtr end);
	void             SaveFiles( mapPackPtr begin, mapPackPtr end);
	void             CalculateOffset( mapPackPtr begin, mapPackPtr end);

protected:
	mapPack          m_mapPack;
	DWORD            m_dwOffset;
	string           m_sBaseDir;
 
} cFile_Package, * cFile_PackagePtr;
///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool Load( Type* pType, string sFilePath)
{
	cFile file( sFilePath, cFile :: FF_READ);

	if( file.Status() != 0) return false;
	if( !pType->Load( file)) return Fail( pType, "FILE_ERR_LOAD");

    return true;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool Save( Type* pType, string sFilePath)
{ 
	cFile file( sFilePath, cFile :: FF_WRITE);

	if( file.Status() != 0) return false;
	if( !pType->Save( file)) return Fail(  pType, "FILE_ERR_SAVE");
	
    return true;
}
///////////////////////////////////////////////////////////////////////////////
#endif //_FILE_H_
///////////////////////////////////////////////////////////////////////////////