// graphic_costume.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "graphic_costume.h"

///////////////////////////////////////////////////////////////////////////////
// cGraphic_Costume 
///////////////////////////////////////////////////////////////////////////////
cGraphic_Costume :: cGraphic_Costume ()
{
	m_iNumAnim = 0;
	for( int i = 0 ; i < AT_NUM; i++)
	{
		m_pAnimations[ i] = NULL;
	}
}
///////////////////////////////////////////////////////////////////////////////
void cGraphic_Costume :: Clear()
{
    for( int i = 0; i < AT_NUM ; i++)
	{
		SAFE_DELETE( m_pAnimations[ i]);	
	}
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume :: CreateCharacter( int iFrame, int iDir)
{
    for( int i = 0 ; i < AT_NUM ; i++)
	{		
		m_pAnimations[ i] = new cGraphic_Directional < cGraphic >();
		if( !m_pAnimations[ i]->CreateDirectional( iFrame, iDir)) 
			return Fail( this, "GRAPHIC_CHARACTER_ERR_CREATECHARACTER"); 
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume ::  Load( cFile& file)
{
	assert( file.Status() == 0);
	BYTE ExistAnim;

	file.Read( &m_iNumAnim, sizeof( BYTE));
    for( BYTE i = 0 ; i < m_iNumAnim ; i++)
	{
		file.Read( &ExistAnim, sizeof( BYTE)); 
		if( !m_pAnimations[ ExistAnim]) m_pAnimations[ ExistAnim] = new cGraphic_Directional < cGraphic > ();
		if( !m_pAnimations[ ExistAnim]->Load( file)) 
			return Fail( this, "GRAPHIC_CHARACTER_ERR_SAVE"); 
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume :: Save( cFile& file)
{
	assert( file.Status() == 0);

	file.Write( &m_iNumAnim, sizeof( BYTE));
    for( int i = 0 ; i < AT_NUM ; i++)
	{
		if( m_pAnimations[ i]) 
		{
			file.Write( &i, sizeof( BYTE));
			if( !m_pAnimations[ i]->Save( file)) 
				return Fail( this, "GRAPHIC_CHARACTER__ERR_SAVE"); 
		}
	}
    
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume :: LoadGraphicFromPrevious( string sFilePath, int iDir)
{  
    for( int i = 0 ; i < AT_NUM ; i++)
	{	
		string sFileName  = sFilePath;
		sFileName        += "/";
	    sFileName        += GetAnimName( i);
		sFileName        += ".dir";
		m_pAnimations[ i] = new cGraphic_Directional < cGraphic > ();
		
		if( !:: Load( m_pAnimations[ i], sFileName))
		{
			SAFE_DELETE( m_pAnimations[ i]);  
		}
		else ++m_iNumAnim;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume :: LoadGraphicFromDirectory( string sFilePath, DWORD dwFlag)
{  
	for( int i = 0 ; i < AT_NUM ; i++)
	{	
		string sSubPath   = sFilePath;
		sSubPath         += "/";
	    sSubPath         += GetAnimName( i);
		m_pAnimations[ i] = new cGraphic_Directional < cGraphic > ();
		
		if( !m_pAnimations[ i]->LoadGraphicFromDirectory( sSubPath, dwFlag))
		{
			SAFE_DELETE( m_pAnimations[ i]);  
		}
		else ++m_iNumAnim;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
void* cGraphic_Costume :: GetGraphic( cAnimation_State* pAnimState) const
{
	assert( pAnimState);

	int iAnim = pAnimState->GetAnimType();
	assert( m_pAnimations[ iAnim]);

	if( !m_pAnimations[ iAnim]) return NULL;
	return m_pAnimations[ iAnim]->GetGraphic( pAnimState);
}
///////////////////////////////////////////////////////////////////////////////
void* cGraphic_Costume :: GetGraphic( int iFrame, int iDir, int iAnim) const
{
	assert( m_pAnimations[ iAnim]);

	if( !m_pAnimations[ iAnim]) return NULL;
	return m_pAnimations[ iAnim]->GetGraphic( iFrame, iDir, iAnim);
}
///////////////////////////////////////////////////////////////////////////////
string cGraphic_Costume :: GetAnimName( int at)
{
	if( at == AT_WAIT)        return string( "Wait");
	if( at == AT_WALK)        return string( "Walk");
	if( at == AT_WALK_START)  return string( "Walk_Start");
	if( at == AT_ATTACK)      return string( "Attack");
	if( at == AT_SPELL)       return string( "Spell");

	return string();
}

///////////////////////////////////////////////////////////////////////////////
bool cGraphic_Costume :: Draw( cAnimation_State* pAnimState, int x, int y)
{
	assert( m_pAnimations[ pAnimState->GetAnimType()]);
	int AnimType = pAnimState->GetAnimType();

	if( !m_pAnimations[ AnimType]) return NULL;
	return m_pAnimations[ AnimType]->Draw( pAnimState, x, y);
}
