     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// GraphicSequence.h
//////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
//////////////////////////////////////////////////////////////////////////
#ifndef _GRAPHIC_SEQUENCE_H_
#define _GRAPHIC_SEQUENCE_H_

#ifndef _STRUCT_H_
#include "struct.h"
#endif

#ifndef _GRAPHIC_H_
#include "graphic.h"
#endif

#ifndef _SURFACE_H_
#include "Surface.h"
#endif

#ifndef _TEXTURE_H_
#include "texture.h"
#endif

#ifndef _COSTUME_H_
#include "costume.h"
#endif

#ifndef _ANIMATION_STATE_H_
#include "animation_state.h"
#endif

///////////////////////////////////////////////////////////////////////////////
// cGraphic_Source( ߽ ó ׷ ҽ .)
///////////////////////////////////////////////////////////////////////////////
typedef class cGraphic_Source
{
public:
	cGraphic_Source() {}
	virtual ~cGraphic_Source() {}

	virtual void     Clear() {};
    ////////////////////////////

	virtual bool     Save( cFile& file) = 0; 
	virtual bool     Load( cFile& file) = 0; 
	virtual bool     LoadGraphicFromPrevious( string spath, int iDirNum = 0) { return true;}
    virtual bool     LoadGraphicFromDirectory( string sFilePath, DWORD dwFlag) { return true;}
    
	virtual int      GetSequenceNum () const { return 0;} 
	virtual void*    GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const { return NULL;}
	virtual void*    GetGraphic( cAnimation_State*) const { return NULL;}
	virtual bool     Draw( cAnimation_State* pAnimState, int x, int y) { return true;}

	virtual bool     CreateDirectional( int iFrame, int iDir) { return true;}

} cGraphic_Source, * cGraphic_SourcePtr;
///////////////////////////////////////////////////////////////////////////////
// cGraphic_Sequence
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
class cGraphic_Sequence : public cGraphic_Source
{
public:
	cGraphic_Sequence();
	virtual ~cGraphic_Sequence();

	///////////////////////////

    virtual void     Clear();
    
    ///////////////////////////
	bool             Save( cFile& file);
	bool             Load( cFile& file);	   
	bool             LoadGraphicFromDirectory( string sFilePath, DWORD dwFlag);
	bool             CreateSequence( int iFrameNum);

	int              GetSequenceNum () const { return m_iNum;}
	void*            GetGraphic( int iFrame, int iDir = 0, int iAnim = 0) const;
	void*            GetGraphic( cAnimation_State*) const ;
	bool             Draw( cAnimation_State* pAnimState, int x, int y);

private:
	bool             LoadSequence( string spath, DWORD dwFlag, int iNum);
	int              CountFileNum( string sFilePath);
	
	////////////////////////////
private:
	Type*            m_pType;//   ŭ Sprite ȴ.
    BYTE             m_iNum; // Ʈ  ..
 
};
///////////////////////////////////////////////////////////////////////////////
// cGraphic_Sequence
///////////////////////////////////////////////////////////////////////////////
template < typename Type>
cGraphic_Sequence < Type > :: cGraphic_Sequence()
{
	m_pType          = NULL;
	m_iNum           = 0;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
cGraphic_Sequence < Type > :: ~cGraphic_Sequence()
{
	Clear();
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
void cGraphic_Sequence < Type > :: Clear()
{ 
	if( m_pType) SAFE_DELETE_ARRAY( m_pType);
	m_iNum = 0;
}
///////////////////////////////////////////////////////////////////////////////
// ʰ̴ ý Ͽ  ƾ ʿ 
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: CreateSequence( int iFrameNum)
{
	SAFE_DELETE_ARRAY( m_pType); //   Sequence ִٸ Ѵ.
	m_pType = new Type[ iFrameNum];
	m_iNum  = iFrameNum;

	if( m_pType) return true;
	else return false;
}
///////////////////////////////////////////////////////////////////////////////
// ε Ʈ ͸ ִϸ̼ Ϸ  ̴.
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: Save( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) 
	    return Fail( this, "GRAPHIC_SEQUENCE_ERR_INVALID_FILE");
	file.Write( &m_iNum, sizeof( BYTE));

	for( int i = 0 ; i < m_iNum ; i++)
	{
       if( !m_pType[ i].Save( file))
		   return Fail( this, "GRAPHICSEQUENCE_ERR_CANNOT_SAVE");
	}
       
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// animation  а Ʈ  ǥ   ŭ .
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: Load( cFile& file)
{  
	assert( file.Status() == 0 );

	if( file.Status() != 0) 
	return Fail( this, "GRAPHIC_SEQUENCE_ERR_INVALID_FILE");

    file.Read( &m_iNum, sizeof( BYTE));

    if( !CreateSequence( m_iNum))
		return Fail( this, "GRAPHIC_SEQUENCE_ERR_CREATESEQUENCES");

    for( int i = 0; i < m_iNum ; i++)
	{
		if( !m_pType[ i].Load( file))
			return Fail( this, "GRAPHICSEQUENCE_ERR_CANNOT_LOAD");
    }
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// iDir cGraphic_Directional Ŭ ܰ迡 ǹ̸ ´. 
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: LoadGraphicFromDirectory( string sFilesPath, DWORD dwFlag)
{  	   
	int NumFile = CountFileNum( sFilesPath);
	if( NumFile == 0) return false;
	
	if( !LoadSequence( sFilesPath, dwFlag, NumFile)) 
		return Fail( this, "GRAPHIC_SEQUENCE_ERR_LOADGRAPHICFORMDIRECTORY");
	// ù° ̸ ˷ָ   ִ 
	// Bmpϵ  ޸𸮻 ε ̴.

	return true;
}
///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
int cGraphic_Sequence < Type > :: CountFileNum( string sFilesPath)
{
	_finddata_t   data;
    LONG id, done, Count = 0; 
	string sWild( "*.");
    sWild += "bmp";
    char cwd[ 255];
	 _getcwd( cwd, 255);//  ۾ 丮  

    if( _chdir( sFilesPath.c_str()) == 0) 
	{
		done = id = _findfirst( sWild.c_str(), &data);
		while( done != -1)
		{
		   Count++;
		   done  = _findnext( id, &data );
		}
		_findclose( id);
		_chdir( cwd);

		return ( int) Count;

    }
	else return 0;
	
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: LoadSequence( string sFilesPath, DWORD dwFlag , int NumSqc)
{ //// sFilesPath = ...../wait
    m_iNum  = NumSqc;
	string sFilePath; // ..../lightning
	sFilesPath += "/";       // ..../lightning/
	
    if( !CreateSequence( NumSqc))
		return Fail( this, "GRAPHIC_SEQUENCE_ERR_CREATESEQUENCES");

    for( int i = 0 ; i < NumSqc ; i++)
	{	
		char num[ 15];
		itoa( i, num, 10);

		sFilePath  = sFilesPath;
		sFilePath += string( num); // ..../lightning/0 
		sFilePath += ".bmp";       // ..../lightning/0.bmp
		
		if( !m_pType[ i].LoadGraphic( sFilePath, dwFlag)) 
			return Fail( this,"GRAPHICSEQUENCE_ERR_LOADGRAPHIC");                    
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
void* cGraphic_Sequence < Type > :: GetGraphic( cAnimation_State* pAnimState) const
{
	assert( m_pType);

	int iFrame = pAnimState->GetFrame();
	if( iFrame < 0 || iFrame >= m_iNum) return NULL;
	if( m_pType == NULL) return NULL;

	return &m_pType[ iFrame];
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
void* cGraphic_Sequence < Type > :: GetGraphic( int iFrame, int iDir, int iAnim) const
{
	assert( m_pType);

	if( iFrame < 0 || iFrame >= m_iNum) return NULL;
	if( m_pType == NULL) return NULL;

	return &m_pType[ iFrame];
}
///////////////////////////////////////////////////////////////////////////////
template < typename Type >
bool cGraphic_Sequence < Type > :: Draw( cAnimation_State* pAnimState, int x, int y)
{
	assert( pAnimState);

	if( !pAnimState) return false;
	return m_pType[ pAnimState->GetFrame()].Draw( x, y, pAnimState->GetDrawFlag());
}

///////////////////////////////////////////////////////////////////////////////
#endif // _GRAPHICSEQUENCE_H_