     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Map.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "Map.h"
#include <algorithm>

void cMap :: Clear()
{
	SAFE_DELETE_ARRAY(m_ppTerrains);
	m_nWidth = m_nHeight = 0;
}

void cMap :: Draw()
{
	for (int y = 0;y < m_nHeight;y++)
		for (int x = 0;x < m_nWidth;x++)
		{
			cTerrainPtr pTerrain = m_ppTerrains[x + y * m_nWidth];
			pTerrain->Draw(x * cTerrain::GetWidth(), y * cTerrain::GetHeight());
		}
}

bool cMap :: Load(cFile& file)
{
	// ι ε  .
	assert(m_ppTerrains == NULL);

	LPCSTR lpszID = "û Map";
	char szID[32];
	file.Read(szID, strlen(lpszID));
	szID[strlen(lpszID)] = NULL;
	if (strcmp(lpszID, szID) != 0)
	{
		// û   ƴϴ.
		return false;
	}

	m_mgrTerrain.Load(file);

	file.Read(&m_nWidth, sizeof(m_nWidth));
	file.Read(&m_nHeight, sizeof(m_nHeight));

	int nMapSize = m_nWidth * m_nHeight;
	m_ppTerrains = new cTerrainPtr[nMapSize];
	for (int i = 0;i < nMapSize;i++)
	{
		int nType, nIndex;
		file.Read(&nType, sizeof(nType));
		file.Read(&nIndex, sizeof(nIndex));
		m_ppTerrains[i] = m_mgrTerrain.GetTerrain(nType, nIndex);
	}
	return true;
}

/*
// extern cScreenPtr g_pScreen;
///////////////////////////////////////////////////////////////////////////////
// cMap :  ó Ҷ   ڴ.
///////////////////////////////////////////////////////////////////////////////
cMap :: cMap( int iWorldWidth, int iWorldHeight)
{
	assert( g_pScreen);

	sm_wScreenWidth  = g_pScreen->GetWidth();
	sm_wScreenHeight = g_pScreen->GetHeight();

#ifdef _TOOL_
	m_iScreenXDim   = sm_wScreenWidth / TERRAIN_WIDTH;
	m_iScreenYDim   = sm_wScreenHeight / TERRAIN_HEIGHT;
#else
    m_iScreenXDim   = sm_wScreenWidth / TILE_WIDTH;   
	m_iScreenYDim   = sm_wScreenHeight / TILE_HEIGHT; 
#endif

    CreateMap( iWorldWidth, iWorldHeight);
}
///////////////////////////////////////////////////////////////////////////////
cMap :: cMap()
{
	assert( g_pScreen);

	sm_wScreenWidth  = g_pScreen->GetWidth();
	sm_wScreenHeight = g_pScreen->GetHeight();

#ifdef _TOOL_
	m_iScreenXDim   = sm_wScreenWidth / TERRAIN_WIDTH;
	m_iScreenYDim   = sm_wScreenHeight / TERRAIN_HEIGHT;
#else
    m_iScreenXDim   = sm_wScreenWidth / TILE_WIDTH;    
	m_iScreenYDim   = sm_wScreenHeight / TILE_HEIGHT; 
#endif

}
///////////////////////////////////////////////////////////////////////////////
void cMap :: Clear()
{	
    for( BYTE i = 0; i < m_iTerrainYDim; i++)
		SAFE_DELETE_ARRAY( m_pTerrains[ i]);

	SAFE_DELETE_ARRAY( m_pTerrains);

	///////////////////////////////////
    for( i = 0; i < m_iTileYDim; i++)
		SAFE_DELETE_ARRAY( m_pTiles[ i]);

	SAFE_DELETE_ARRAY( m_pTiles);
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: CreateMap( int iWorldWidth, int iWorldHeight)
{
    sm_wWorldWidth  = iWorldWidth;
	sm_wWorldHeight = iWorldHeight;

	m_iTileXDim     = sm_wWorldWidth / TILE_WIDTH;
	m_iTileYDim     = sm_wWorldHeight / TILE_HEIGHT;

	m_iTerrainXDim  = sm_wWorldWidth / TERRAIN_WIDTH;
	m_iTerrainYDim  = sm_wWorldHeight / TERRAIN_HEIGHT;

	CreateTiles();
	CreateTerrains();
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: CreateTiles()
{
	m_pTiles = new cTile* [ m_iTileYDim];
	for( BYTE i = 0; i < m_iTileYDim; i++)
		m_pTiles[ i] = new cTile[ m_iTileXDim];
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: CreateTerrains()
{
	m_pTerrains = new cTerrain* [ m_iTerrainYDim];
	for( int i = 0; i < m_iTerrainYDim; i++)
		m_pTerrains[ i] = new cTerrain[ m_iTerrainXDim];
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: CreateTileGraphic()
{
	assert( m_pTiles);
	assert( m_pTerrains);

	if( !m_pTiles) return false;
	if( !m_pTerrains) return false;

	for( int j = 0; j < m_iTerrainYDim; j++)
	{
	   for( int i = 0; i < m_iTerrainXDim; i++)
	   {
		   vector < cGraphicPtr > vGraphics = m_pTerrains[ j][ i].CreateVirtualGraphics();
		   vector < cGraphicPtr > :: iterator iter;

		   for( int k = 0; k < TILE_YNUM; k++)
		   {
			   for( int l = 0; l < TILE_XNUM; l++)
			   {
				   m_pTiles[ j * TILE_YNUM + k][ i * TILE_XNUM + l].SetGraphic( *iter++);
			   }
		   }

		   vGraphics.clear();
	   }
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
// wx, wy  ǥ̴.
///////////////////////////////////////////////////////////////////////////////
void cMap :: GetTilePosition( int wx, int wy, int& tx, int& ty)
{
	tx = wx / TILE_WIDTH; // Ÿ ǥ
	ty = wy / TILE_HEIGHT;
}
///////////////////////////////////////////////////////////////////////////////
cTilePtr cMap :: GetTileAtWorld( int wx, int wy)
{
    int tx, ty;

	GetTilePosition( wx, wy, tx, ty);
    return GetTile( tx, ty);
}
///////////////////////////////////////////////////////////////////////////////
cTilePtr cMap :: GetTile( int tx, int ty)
{
	if( tx < 0)              return NULL;
	if( ty < 0)              return NULL;
	if( tx >= m_iTileXDim)   return NULL;
	if( ty >= m_iTileYDim)   return NULL;

	if( !m_pTiles) return NULL;
	else return &m_pTiles[ ty][ tx];
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: GetTerrainPosition( int wx, int wy, int& tx, int& ty)
{
	tx = wx / TERRAIN_WIDTH; // Ÿ ǥ
	ty = wy / TERRAIN_HEIGHT;
}
///////////////////////////////////////////////////////////////////////////////
cTerrainPtr cMap :: GetTerrainAtWorld( int wx, int wy)
{
    int tx, ty;

	GetTerrainPosition( wx, wy, tx, ty);
    return GetTerrain( tx, ty);
}
///////////////////////////////////////////////////////////////////////////////
cTerrainPtr cMap :: GetTerrain( int tx, int ty)
{
	if( tx < 0)               return NULL;
	if( ty < 0)               return NULL;
	if( tx >= m_iTerrainXDim) return NULL;
	if( ty >= m_iTerrainYDim) return NULL;

	if( !m_pTerrains) return NULL;
	else return &m_pTerrains[ ty][ tx];
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: Save( cFile& file)
{
	assert( file.Status() == 0);
    if( file.Status() != 0) return Fail( this, "MAP_ERR_SAVE");
	
	file.Write( &sm_wWorldWidth, sizeof( WORD));
	file.Write( &sm_wWorldHeight, sizeof( WORD));

	///////////// Tile Save ////////////////
	for( int i = 0; i < m_iTileYDim; i++)
	{
		for( int j = 0; j < m_iTileXDim; j++)
		{
			m_pTiles[ i][ j].Save( file);
		}
	}
    
	//////////// Terrain Save /////////////
	for( i = 0; i < m_iTerrainYDim; i++)
	{
		for( int j = 0; j < m_iTerrainXDim; j++)
		{
			m_pTerrains[ i][ j].Save( file);
		}
	}

    return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: Load( cFile& file)
{
	assert( file.Status() == 0 );
	if( file.Status() != 0) return Fail( this, "MAP_ERR_SAVE");

	file.Read( &sm_wWorldWidth, sizeof( WORD));
	file.Read( &sm_wWorldHeight, sizeof( WORD));
    
	CreateMap( sm_wWorldWidth, sm_wWorldHeight);
	for( int i = 0; i < m_iTileYDim; i++)
	{
		for( int j = 0; j < m_iTileXDim; j++)
		{
			m_pTiles[ i][ j].Load( file);
		}
	}
    
	//////////////////////////////////////////////
	for( i = 0; i < m_iTerrainYDim; i++)
	{
		for( int j = 0; j < m_iTerrainXDim; j++)
		{
			m_pTerrains[ i][ j].Load( file);

			cGraphic* pGraphic;//= m_pTerrainMgr->GetGraphic( m_pTerrains[ i][ j].GetFlag());
			m_pTerrains[ i][ j].SetGraphic( pGraphic);
		}
	}

	if( CreateTileGraphic() == false)
		return Fail( this, "MAP_ERR_LOAD_CREATETILEGRAPHIC");

    return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawObject()
{
#ifdef _TOOL_
	return DrawTerrains();
#else 
	return DrawTiles();
#endif
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawObjectAt( CANVASPtr pCanvas)
{
#ifdef _TOOL_
	return DrawTerrainsAt( pCancvas);
#else 
	return DrawTilesAt( pCanvas);
#endif
}
///////////////////////////////////////////////////////////////////////////////
//  Terrain   ׸.
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawTerrains()
{
	int tx, ty;
	GetTerrainPosition( sm_shUpperX, sm_shUpperY, tx, ty);

	for( int i = ty; i < m_iScreenYDim + 1; i++)
	{
		for( int j = tx; j < m_iScreenXDim + 1; j++)
		{
			m_pTerrains[ i][ j].Draw( j * TERRAIN_WIDTH, i * TERRAIN_HEIGHT);
		}
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
// ӿ Ÿ   ׸.
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawTiles()
{
	int tx, ty;
	GetTilePosition( sm_shUpperX, sm_shUpperY, tx, ty);

	for( int i = ty; i < m_iScreenYDim + 1; i++)
	{
		for( int j = tx; j < m_iScreenXDim + 1; j++)
		{
			m_pTiles[ i][ j].Draw( j * TILE_WIDTH, i * TILE_HEIGHT);
		}
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawTerrainsAt( CANVASPtr pCanvas)
{
	assert( pCanvas);
	assert( FALSE == IsBadWritePtr(pCanvas->pwAddress, pCanvas->size.iRealWidth * pCanvas->size.iHeight));

	int tx, ty;
	GetTerrainPosition( sm_shUpperX, sm_shUpperY, tx, ty);

	for( int i = ty; i < m_iScreenYDim + 1; i++)
	{
		for( int j = tx; j < m_iScreenXDim + 1; j++)
		{
			m_pTerrains[ i][ j].DrawAt( pCanvas, j * TERRAIN_WIDTH, i * TERRAIN_HEIGHT);
		}
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cMap :: DrawTilesAt( CANVASPtr pCanvas)
{
	assert( pCanvas);
	assert( FALSE == IsBadWritePtr(pCanvas->pwAddress, pCanvas->size.iRealWidth * pCanvas->size.iHeight));

	int tx, ty;
	GetTilePosition( sm_shUpperX, sm_shUpperY, tx, ty);

	for( int i = ty; i < m_iScreenYDim + 1; i++)
	{
		for( int j = tx; j < m_iScreenXDim + 1; j++)
		{
			m_pTiles[ i][ j].DrawAt( pCanvas, j * TILE_WIDTH, i * TILE_HEIGHT);
		}
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
//  Ÿ  ũ Ǿ Ѵ. Ÿ ̹ ߾ ׷ 
// Ŭ ó  ʴ´.^^;
///////////////////////////////////////////////////////////////////////////////
void cMap :: MoveInMap( int x, int y) 
{
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: MoveLeft()
{
	sm_shUpperX -= MOVE_RIGHTLEFT;
    if( sm_shUpperX < 0) sm_shUpperX = 0;
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: MoveRight()
{
	int X = sm_wWorldWidth - sm_wScreenWidth;

	sm_shUpperX += MOVE_RIGHTLEFT;
	if( sm_shUpperX > X) sm_shUpperX = X;
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: MoveUp()   
{
	sm_shUpperY -= MOVE_UPDOWN;
	if( sm_shUpperY < 0) sm_shUpperY = 0;
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: MoveDown() 
{
	int Y = sm_wWorldHeight - sm_wScreenHeight;

	sm_shUpperY += MOVE_UPDOWN;
	if( sm_shUpperY > Y) sm_shUpperY = Y;
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: MouseScroll( int x, int y)
{
	if( x < 32)                    MoveLeft();
	if( y < 32)                    MoveUp();   
	if( x > sm_wScreenWidth - 32)  MoveRight();
	if( y > sm_wScreenHeight - 32) MoveDown(); 
}
///////////////////////////////////////////////////////////////////////////////
// TERRAIN FlagӼ    ȭ鿡 ϱ  Լ
///////////////////////////////////////////////////////////////////////////////
void cMap :: Update()
{
	for( int i = 0; i < m_iTerrainYDim; i++)
	{
		for( int j = 0; j < m_iTerrainXDim; j++)
		{
			cGraphic* pGraphic = m_pTerrainMgr->GetGraphic( m_pTerrains[ i][ j].GetFlag());
			m_pTerrains[ i][ j].SetGraphic( pGraphic);
		}
	}
}
///////////////////////////////////////////////////////////////////////////////
void cMap :: SetTerrainFlag( int tx, int ty, TERRAIN_FLAG tFlag)
{
	if( tx < 0 || ty < 0)    return;
	if( tx > m_iTerrainXDim) return;
	if( ty > m_iTerrainYDim) return;

	m_pTerrains[ ty][ tx].SetFlag( tFlag);
}
///////////////////////////////////////////////////////////////////////////////
//  Terrain ó  ׶ ׷ Ʈ( Pattern = 0) ׶
// Ѵ.
///////////////////////////////////////////////////////////////////////////////
void cMap :: SetDefaultTerrain()
{   
	TERRAIN_FLAG flag;
	flag.uType    = m_pTerrainMgr->GetDefaultTerrainType();
	flag.uPattern = 0;
	if( flag.uType == TT_NUM) return;

	for( int j = 0; j < m_iTerrainYDim; j++)
	{
	   for( int i = 0; i < m_iTerrainXDim; i++)
	   {
		   flag.uId = ( rand() % 8);
		   m_pTerrains[ j][ i].SetFlag( flag);
		   m_pTerrains[ j][ i].SetGraphic( m_pTerrainMgr->GetGraphic( flag));
	   }
	}
}
*/
