     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Screen.h
//////////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef _SCREEN_H_
#define _SCREEN_H_

#ifndef  _SINGLETON_H_
#include "singleton.h"
#endif

#ifndef  _STRUCT_H_
#include "struct.h"
#endif

#ifndef  _D3DUTIL_H_
#include "d3dutil.h"
#endif

/////////////////////////////////////////////////////////////////////////////
HRESULT WINAPI EnumZBufferCallback( LPDDPIXELFORMAT lpDDPixFmt, LPVOID lpContext);

class cScreen;
#define g_pScreen  cScreen :: GetSingletonPtr()
/////////////////////////////////////////////////////////////////////////////
// cScreen
/////////////////////////////////////////////////////////////////////////////
typedef class cScreen : public cSingleton < cScreen >
{
public:
	enum SCREEN_MODE { SM_FULLSCREEN, SM_FULLSCREEN_WINDOW, SM_WINDOW};

public:
	cScreen();
	virtual ~cScreen();

	bool                   CreateScreen( HWND hWnd , int Width = 800, int Height = 600, 
		                   int Bpp = 16, SCREEN_MODE sm = SM_FULLSCREEN_WINDOW);
	void                   Clear();
	void __fastcall        ClearScreenSurface();
	void                   RestoreAllSurface();
	void                   WriteFrameCount();
	void                   WriteText( int x, int y, LPCSTR String);
	void __fastcall        Flip( HWND hWnd);	
	bool                   DrawRect( RECT rc, HDC hdc, HPEN hPen);

	void                   FillScreen( COLOR color);
	bool                   RenderBegin();
	bool                   RenderEnd();
	CANVASPtr              PrepareFrame();
	void                   SetLightPosition( int LightID, float x, float y, float z);
	bool                   CreateLight( D3DLIGHTTYPE ltType, float x, float y, float z);
	bool                   IsInitialize() const { return m_bInitialized;}

	int                    GetWidth() { return m_ScreenCan.size.iWidth;}
	int                    GetHeight() { return m_ScreenCan.size.iHeight;}
	GRAPHIC_FORMAT*        GetGraphicFormat() { return &m_GraphicFormat;}
	CANVAS                 GetCanvas() const { return m_ScreenCan;}
	LPDIRECTDRAW7          GetDirectDraw() const { return m_lpDD;}
	LPDIRECT3DDEVICE7      GetDirect3DDevice() const { return m_lpD3DDevice;}
    LPD3DVERTEX            GetVertexs() const { return m_lpD3DVertex;}
    LPDIRECTDRAWSURFACE7   GetBackBuffer() const { return m_lpDDSBack;} 
	LPDIRECTDRAWSURFACE7   GetFrontBuffer() const { return m_lpDDSFront;}
  
	///////////////////////////////////////////////////
private:
	void                   Init( HWND hWnd, int Width, int Height,
	                            int Bpp, SCREEN_MODE sm );

    bool                   CreateFullScreen();
	bool                   CreateWindowed();
	bool                   CreateFullScreen_Window();
	bool                   CreateDirect3D();
	bool                   CreateZBuffer();
    bool                   InitTransform();
	bool                   SetColorTypeAndBitMask( LPDIRECTDRAWSURFACE7 lpdds);

protected:
	LPDIRECTDRAW7          m_lpDD;
	LPDIRECTDRAWSURFACE7   m_lpDDSFront;
	LPDIRECTDRAWSURFACE7   m_lpDDSBack;
	LPDIRECTDRAWCLIPPER    m_lpDDClipper;
	
    HWND                   m_hWnd;
	int                    m_Bpp;
	int                    m_FrameCount, m_FramePerSecond;
	DWORD                  m_TimeLast;
	bool                   m_bInitialized;
	SCREEN_MODE            m_ScreenMode;
	CANVAS                 m_ScreenCan;
	GRAPHIC_FORMAT         m_GraphicFormat;

    ///////////////// D3D ////////////////////
	LPDIRECTDRAWSURFACE7   m_lpDDSZBuffer;
	LPDIRECT3D7            m_lpD3D;
	LPDIRECT3DDEVICE7      m_lpD3DDevice;
	LPD3DVERTEX            m_lpD3DVertex;

	GUID                   m_guidDriver;
	GUID                   m_guidDevice;

} cScreen, * cScreenPtr;

#endif //_SCREEN_H_
/////////////////////////////////////////////////////////////////////