     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// stage.cpp
////////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "stage.h"
#include <algorithm>

////////////////////////////////////////////////////////////////////////////////
cStage :: cStage()
{
}
////////////////////////////////////////////////////////////////////////////////
cStage :: ~cStage()
{
	Clear();
}
////////////////////////////////////////////////////////////////////////////////
void cStage :: Clear()
{
	cEvent event;
	int size = m_mapEvent.size();
    mapEvent :: iterator iter = m_mapEvent.begin();

	for( int i = 0; i < size; i++)
	{
	   event = ( *iter++).second;
	   event.Clear();
	} 
	
	m_mapEvent.clear();
    m_vObjectNames.clear();

}
////////////////////////////////////////////////////////////////////////////////
bool cStage :: RunEvent( string sEventName)
{
	if( m_mapEvent.empty()) return Fail( this, "STAGE_ERR_EMPTY_MAPEVENT");

	cEvent Event = FindEvent( sEventName);
	Event.Run_Event();

	return true;
}
////////////////////////////////////////////////////////////////////////////////
void cStage :: InsertEvent( cEvent event)
{
	m_mapEvent[ event.GetEventName()] = event;
}
////////////////////////////////////////////////////////////////////////////////
void cStage :: EraseEvent( string sname) 
{
	m_mapEvent.erase( sname);
}   
////////////////////////////////////////////////////////////////////////////////
cEvent cStage :: FindEvent( string sEventName)
{
	mapEvent :: iterator iter = m_mapEvent.find( sEventName);
    return ( *iter).second;
}
////////////////////////////////////////////////////////////////////////////////
void cStage :: InsertObject( int iName)
{
	m_vObjectNames.push_back( iName);
}
////////////////////////////////////////////////////////////////////////////////
void cStage :: EraseObject( int iName)
{
	vector < WORD > :: iterator iter; 
    iter = find( m_vObjectNames.begin(), m_vObjectNames.end(), iName);

	m_vObjectNames.erase( iter);
}
////////////////////////////////////////////////////////////////////////////////
// txtSciptFile   ̺Ʈ   ũƮ ۼǾ ִ.
////////////////////////////////////////////////////////////////////////////////
bool cStage :: LoadScriptFromTextFile( string stxtFilePath)
{   
	cScript Script;
    if( !Script.LoadScript( this, stxtFilePath))
		return Fail( this, "STAGE_ERR_LOADSCRIPTFROMTEXTFILE");

	char* pchTemp = Script.GetCurrentPosition();
	if( !pchTemp) return Fail( this, "STAGE_ERR_INVALID_TEXTSCRIPT");

	while( true)
	{
	   cEvent Event = Script.Parsing( pchTemp);
	   if( Event.EmptyCommand()) break; // 
	  
	   InsertEvent( Event);
	   pchTemp = Script.GetCurrentPosition();
	}
	
	return true;
}
////////////////////////////////////////////////////////////////////////////////
bool cStage :: Load( cFile& file)
{
	assert( file.Status() == 0 );
//    Clear(); //  ε  .
		
	if( !file.Status()) return Fail( this, "STAGE_ERR_LOAD_INVALID_FILE");
	/*/////////////  ̸ ε //////////////
	char chName[ 30];
	memset( chName, 0, 30);
    BYTE size, s;

	file.Read( &size, sizeof( BYTE));	
	file.Read( chName, size);

	SetMapName( chName);

	/*///////// Ʈ ̸ ε ////////////
	WORD uName;
    BYTE s;
	file.Read( &s, sizeof( BYTE));
	for( int i = 0; i < s; i++)
	{       
	    file.Read( &uName, sizeof( WORD));
		InsertObject( uName);
	}
	////////// ũƮ  ε ////////////
	file.Read( &s, sizeof( BYTE));
	for( i = 0; i < s; i++)
	{
		cEvent Event;
		if( !Event.Load( file))
			return Fail( this, "STAGE_ERR_LOAD");

		InsertEvent( Event);
	}
    
	return true;
}

////////////////////////////////////////////////////////////////////////////////
bool cStage :: Save( cFile& file)
{
	assert( file.Status() == 0 );
	if( !file.Status()) return Fail( this, "STAGE_ERR_SAVE_INVALID_FILE"); 

	/*/////////////  ̸ //////////////
	BYTE size, s;
	size = m_sMapName.length();

	file.Write( &size, sizeof( BYTE));
	file.Write( m_sMapName.c_str(), size);

	/*///////// Ʈ ̸  ////////////
	BYTE s = m_vObjectNames.size();
	file.Write( &s, sizeof( BYTE));
	vector < WORD > :: iterator iter = m_vObjectNames.begin(); 

	for( int i = 0; i < s; i++)
	{
	    file.Write( iter++, sizeof( WORD));
	}
	////////// ũƮ   //////////// 
	s = m_mapEvent.size();
	file.Write( &s, sizeof( BYTE));
    mapEvent :: iterator pevt = m_mapEvent.begin();

	for( i = 0; i < s; i++)
	{
		cEvent Event(( *pevt++).second); 
		Event.Save( file);
	}

	return true;
}
////////////////////////////////////////////////////////////////////////////////