     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Surface.cpp:
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "surface.h"
#include "asm.h"

///////////////////////////////////////////////////////////////////////////////
// Construction/Destruction
///////////////////////////////////////////////////////////////////////////////
cSurface :: cSurface()
{
	m_lpDDS                 = NULL;
	m_Canvas.size.iWidth    = 0;
	m_Canvas.size.iHeight   = 0; 
	m_Canvas.pwAddress      = NULL;
	m_pGraphic              = NULL;
	m_ColorKey              = 0;
	m_dwFlag                = 0;
} 
/////////////////////////////////////////////////////////////////////////////////
// cScreen ü ο   ִ.
/////////////////////////////////////////////////////////////////////////////////
cSurface :: cSurface( int Width, int Height)
{
	assert( g_pScreen);

	m_lpDDS                = NULL;
    m_pGraphic             = NULL; 
	m_ColorKey             = 0;
	m_dwFlag               = 0;

	CreateSurface( Width, Height);
}
///////////////////////////////////////////////////////////////////////////////
cSurface :: ~cSurface( )
{
    Clear();
}
///////////////////////////////////////////////////////////////////////////////
void cSurface :: Clear()
{
   SAFE_RELEASE( m_lpDDS);
   SAFE_DELETE( m_pGraphic);
}
///////////////////////////////////////////////////////////////////////////////
// ̹ ε ǥ鸦 Ѵ.
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: CreateSurface( int w, int h)
{
	assert( g_pScreen);
    DDSURFACEDESC2 ddsd;

	memset( &ddsd, 0, sizeof( ddsd));
    ddsd.dwSize         = sizeof( ddsd);
	ddsd.dwFlags        = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;		                 
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth        = w;
	ddsd.dwHeight       = h;

	if( FAILED( g_pScreen->GetDirectDraw()->CreateSurface( &ddsd, &m_lpDDS, NULL)))
		return Fail( this, "SUR_DDERR_CREATEOFFSCRSUR");
	
	if( !SetCanvas( w, h))
		return Fail( this, "SUR_ERR_SETCANVASADDRESS");

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: LoadGraphic( string sFilePath, DWORD dwFlag)
{
	assert( g_pScreen);
    
	if( m_pGraphic) SAFE_DELETE( m_pGraphic);
	m_pGraphic = new cGraphic();

	if( !m_pGraphic->LoadGraphic( sFilePath, dwFlag))
		return Fail( this, "SUR_ERR_LOADGRAPHIC");

	int w = m_pGraphic->GetWidth();
    int h = m_pGraphic->GetHeight();
	m_dwFlag = m_pGraphic->GetFlag();
	
    if( !CreateSurface( w, h)) return false;
	if( !CopyGraphicByAsm()) return false;
	if( dwFlag & GRP_CLRKEY_HAS)
	{
		m_ColorKey = m_pGraphic->GetColorKey( m_pGraphic->GetImagePtr());
		SetColorKey();
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: Load( cFile& file)
{
	assert( g_pScreen);
	assert(  file.Status() != 0);

	if( file.Status() != 0) return false;
	if( m_pGraphic) SAFE_DELETE( m_pGraphic);
	
	file.Read( &m_ColorKey, sizeof( WORD));
	m_pGraphic = new cGraphic();
	if( !m_pGraphic->Load( file))
	    return Fail( this, "SURFACE_ERR_LOAD_SAVEDFILE");
		
	int w = m_pGraphic->GetWidth();
	int h = m_pGraphic->GetHeight();
	m_dwFlag = m_pGraphic->GetFlag();
	
    if( !CreateSurface( w, h)) return false;
	if( !CopyGraphicByAsm()) return false;
	if( m_dwFlag & GRP_CLRKEY_HAS)	SetColorKey();
	
	SAFE_DELETE( m_pGraphic); //  ׷ ʿ.
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: Save( cFile& file)
{
	assert( file.Status() == 0 );
	assert( m_pGraphic);

	if( file.Status() != 0) return false;
	if( !m_pGraphic) return false;
	
	file.Write( &m_ColorKey, sizeof( WORD));
	return m_pGraphic->Save( file);
}
///////////////////////////////////////////////////////////////////////////////
//  ȭ Լ .
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: CopyGraphicByAsm()
{
	assert( m_Canvas.pwAddress);
	if( !m_Canvas.pwAddress) return false;

	int height    = m_Canvas.size.iHeight;
	int width     = m_Canvas.size.iWidth;
	int realwidth = m_Canvas.size.iRealWidth;
	WORD* pDest   = ( WORD* ) m_Canvas.pwAddress;
	WORD* pSrc    = ( WORD* ) m_pGraphic->GetImagePtr();
	
	for( int i = 0 ; i < height ; i++)
	{   
		Memcpy16Bit( pDest, pSrc, width); //  ڵ ȭ Լ
		pDest += realwidth;
		pSrc  += width;
	}

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: Draw( int x, int y, DWORD dwDrawingFlag)
{
	assert( g_pScreen);

	if( !g_pScreen) return false;
	int isClipping = Clipping( &g_pScreen->GetCanvas(), x, y);

	DWORD dwFlag = DDBLTFAST_WAIT;
	if( m_dwFlag & GRP_CLRKEY_HAS)
		dwFlag |= DDBLTFAST_SRCCOLORKEY;

	if( isClipping == - 1) return true;
	else if( isClipping == 1)
	{
		LPDIRECTDRAWSURFACE7 lpDDS = g_pScreen->GetBackBuffer();
		lpDDS->BltFast( x, y, m_lpDDS, NULL, dwFlag);
	}
	else DrawAtClipped( x, y, dwFlag);

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: DrawInRect( RECT* pDestRect, RECT* pSrcRect)
{	
	assert( g_pScreen);

	DWORD dwFlag = DDBLT_WAIT;
	if( m_dwFlag & GRP_CLRKEY_HAS) dwFlag |= DDBLT_KEYSRC;

	LPDIRECTDRAWSURFACE7 lpDDS = g_pScreen->GetBackBuffer();
	lpDDS->Blt( pDestRect, m_lpDDS, pSrcRect, dwFlag, NULL);
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: DrawAtClipped( int x, int y, DWORD dwFlag)
{		
	assert( g_pScreen);

	int X  = x, Y = y;
	int W  = g_pScreen->GetWidth();
	int H  = g_pScreen->GetHeight();
    int w  = m_Canvas.size.iWidth;
	int h  = m_Canvas.size.iHeight;
	RECT rect;
	SetRect( &rect, 0, 0, w, h);

	if( x < 0) { rect.left -=  x; X = 0;}
	if( y < 0) { rect.top  -=  y; Y = 0;}
	if( x + w > W) rect.right  = W - x;
	if( y + h > H) rect.bottom = H - y;

	LPDIRECTDRAWSURFACE7 lpDDS = g_pScreen->GetBackBuffer();//GetScreenSurface()->GetDDSurface();
	lpDDS->BltFast( X, Y, m_lpDDS, &rect, dwFlag);
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
int cSurface :: Clipping( CANVASPtr pDestCan, int x, int y)
{	
	assert( pDestCan);

	int left   = 0;
	int right  = pDestCan->size.iWidth;
	int top    = 0;
	int bottom = pDestCan->size.iHeight;
	int w      = m_Canvas.size.iWidth;
	int h      = m_Canvas.size.iHeight;
	//  Ŭ.. ׸ʿ䰡 .
    if( left   >  x + w) return - 1; 
    if( right  <  x    ) return - 1;
	if( top    >  y + h) return - 1;
	if( bottom <  y    ) return - 1;

	// Ŭ ʿ...
    if( ( left <= x) && ( right >= x + w) && ( top <= y ) && ( bottom >= y + h))
		return 1;

	// κ Ŭ .. Ϻκи ׷ Ѵ.
	return 0;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: SetColorKey()
{
	assert( m_lpDDS);

	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue  = m_ColorKey;// 0xff;
	ddck.dwColorSpaceHighValue = m_ColorKey;// 0xff;
	
	if( FAILED( m_lpDDS->SetColorKey( DDCKEY_SRCBLT, &ddck)))
		return Fail( this, "SURFACE_DDERR_SETCOLORKEY");

	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: IsColorKey( int x, int y)
{
	assert( m_Canvas.pwAddress);
	WORD wcolor = *( m_Canvas.pwAddress + x + m_Canvas.size.iRealWidth * y);

	if( wcolor == m_ColorKey) return true;
	else return false;
}
///////////////////////////////////////////////////////////////////////////////
bool cSurface :: SetCanvas( int w, int h)
{
	assert( m_lpDDS);

	DDSURFACEDESC2 ddsd;
	memset( &ddsd, 0, sizeof( ddsd));
    ddsd.dwSize   = sizeof( ddsd);

	if( SUCCEEDED( m_lpDDS->Lock( NULL, &ddsd, DDLOCK_WAIT 
		         | DDLOCK_SURFACEMEMORYPTR, NULL)))
	{   // Color Blending  ޸ ġ Ѵ.
		m_Canvas.pwAddress         = ( WORD* ) ddsd.lpSurface;
	    m_Canvas.size.iRealWidth   = ddsd.lPitch / 2; // WORD 
		m_Canvas.size.iWidth       = w;
		m_Canvas.size.iHeight      = h;

    	m_lpDDS->Unlock( NULL);

    	return true;
	}
	return false;
}

//----------------------------------------------------------------------------------
// Function name	: cSurface::FindAndSetColorKey
// Return type		: void 
// Description	    :  ޼ Surface (0,0) ġ ִ   Ѵ
//----------------------------------------------------------------------------------
void cSurface::FindAndSetColorKey()
{
	m_ColorKey = *(m_Canvas.pwAddress);
	SetColorKey();
}

