     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// Texture.cpp:
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "texture.h"
#include "asm.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
cTexture :: cTexture()
{
	m_lpDDS               = NULL;
	m_Canvas.pwAddress    = NULL;
	m_pGraphic            = NULL;
	m_Canvas.size.iWidth  = 0;
	m_Canvas.size.iHeight = 0; 
    
	m_fR                  = 1.0f;
	m_fG                  = 1.0f;
	m_fB                  = 1.0f;

    SetTextureScale( 1.0, 1.0);
} 
/////////////////////////////////////////////////////////////////////////
cTexture :: ~cTexture( )
{
    Clear();
}
//////////////////////////////////////////////////////////////////////////
bool cTexture :: LoadGraphic( string FilePath, DWORD dwFlag)
{
	assert( g_pScreen);
	if( m_pGraphic) SAFE_DELETE( m_pGraphic);

	m_pGraphic = new cGraphic();
	if( !m_pGraphic->LoadGraphic( FilePath, dwFlag))
		return Fail( this, "SUR_ERR_LOADGRAPHIC");

	m_Canvas.size.iWidth  = m_pGraphic->GetWidth();
	m_Canvas.size.iHeight = m_pGraphic->GetHeight();
	
    if( !CreateTexture()) 
		return Fail( this, "TEXTURE_ERR_CREATETEXTURE");

	if( !CopyGraphicByAsm()) 
		return Fail( this, "TEXTURE_ERR_COPYGRAPHICBYASM");

// #ifndef _TOOL_
//	SAFE_DELETE( m_pGraphic);
// #endif

	return true;
}

/////////////////////////////////////////////////////////////////////////
bool cTexture :: Load( cFile& file)
{
	assert( g_pScreen);
	assert( file.Status() == 0 );

	if( file.Status() != 0) return Fail( this, "TEXTURE_ERR_LOAD_SAVEDFILE");	
	if( m_pGraphic) SAFE_DELETE( m_pGraphic);

	//file.Read( &m_dwStage, sizeof( DWORD));
	//file.Read( &m_fR, sizeof( float));
    //file.Read( &m_fG, sizeof( float));
	//file.Read( &m_fB, sizeof( float));

	m_pGraphic = new cGraphic();
	if( !m_pGraphic->Load( file))
		return Fail( this, "SUR_ERR_LOADGRAPHIC");

	m_Canvas.size.iWidth  = m_pGraphic->GetWidth();
	m_Canvas.size.iHeight = m_pGraphic->GetHeight();
	
    if( !CreateTexture()) 
		return Fail( this, "TEXTURE_ERR_CREATETEXTURE");
	if( !CopyGraphicByAsm()) 
		return Fail( this, "TEXTURE_ERR_COPYGRAPHICBYASM");

// #ifndef _TOOL_
//	SAFE_DELETE( m_pGraphic);
// #endif

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool cTexture :: Save( cFile& file)
{
	assert( file.Status() == 0 );

	if( file.Status() != 0) return false;
	if( !m_pGraphic) return false;

    //file.Write( &m_dwStage, sizeof( DWORD));
	//file.Write( &m_fR, sizeof( float));
    //file.Write( &m_fG, sizeof( float));
	//file.Write( &m_fB, sizeof( float));

	return m_pGraphic->Save( file);
}

/////////////////////////////////////////////////////////////////////////
// ̹ ε ǥ鸦 Ѵ.
/////////////////////////////////////////////////////////////////////////
bool cTexture :: CreateTexture()
{
	assert( g_pScreen);

    DDSURFACEDESC2       ddsd;
    D3DDEVICEDESC7       ddDesc;

    if( FAILED( g_pScreen->GetDirect3DDevice()->GetCaps( &ddDesc)))
		return Fail( this, "TEXTURE_D3DDERR_GETCAPS");

    memset( &ddsd, 0, sizeof( ddsd));
	ddsd.dwSize         = sizeof( ddsd);
	ddsd.dwFlags        = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;	
	                      DDSD_PIXELFORMAT | DDSD_TEXTURESTAGE;
	ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE;
    ddsd.dwWidth        = m_Canvas.size.iWidth;
	ddsd.dwHeight       = m_Canvas.size.iHeight;
	ddsd.dwTextureStage = 0;//m_dwStage;
	ddsd.ddpfPixelFormat.dwSize = sizeof( DDPIXELFORMAT);
    
	if( ddDesc.deviceGUID == IID_IDirect3DHALDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else if( ddDesc.deviceGUID == IID_IDirect3DTnLHalDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    //   ǥ   ̸  2, 4, 8, 16, 32, 64 ϴ 쵵 ִ. 
    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_POW2 )
    {
        for( ddsd.dwWidth  = 1; m_Canvas.size.iWidth >  ( int ) ddsd.dwWidth;   ddsd.dwWidth  <<= 1 );
        for( ddsd.dwHeight = 1; m_Canvas.size.iHeight > ( int ) ddsd.dwHeight;  ddsd.dwHeight <<= 1 );
    }

    DWORD dwMaxWidth      = ddDesc.dwMaxTextureWidth;
    DWORD dwMaxHeight     = ddDesc.dwMaxTextureHeight;
    m_Canvas.size.iWidth  = ddsd.dwWidth  = MIN( ddsd.dwWidth,  ( dwMaxWidth  ? dwMaxWidth  : 256 ) );
    m_Canvas.size.iHeight = ddsd.dwHeight = MIN( ddsd.dwHeight, ( dwMaxHeight ? dwMaxHeight : 256 ) );

    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_SQUAREONLY )
    {
        if( ddsd.dwWidth > ddsd.dwHeight ) ddsd.dwHeight = ddsd.dwWidth;
        else                               ddsd.dwWidth  = ddsd.dwHeight;
    }

    // ˸´ ؽ  ã´.
    TEXTUREINFO ti;
    ti.bFoundGoodFormat = false;
    ti.pddpf            = &ddsd.ddpfPixelFormat;
    ti.dwDesiredBPP     = 16;
    ti.bUsePalette      = false;
    ti.bUseAlpha        = false;
   
    if( m_pGraphic && ( m_pGraphic->GetFlag() & GRP_CLRKEY_HAS) )
    {
        if( ti.bUsePalette )
        {
            if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_ALPHAPALETTE )
            {
                ti.bUseAlpha   = true;
                ti.bUsePalette = true;
            }
            else
            {
                ti.bUseAlpha   = true;
                ti.bUsePalette = false;
            }
        }
    }

    g_pScreen->GetDirect3DDevice()->EnumTextureFormats( TextureSearchCallback, &ti );    
    if( !ti.bFoundGoodFormat) return Fail( this, "TEXTURE_DDERR_CANNOT_FIND_TEXTUREFORMAT"); 
       
	if( FAILED( g_pScreen->GetDirectDraw()->CreateSurface( &ddsd, &m_lpDDS, NULL)))
		return Fail( this, "TEXTURE_DDERR_CREATESURFACE");
	
	return true;
}
//////////////////////////////////////////////////////////////////////////
//  ޸ ̹    ǥ Ѵ.
//////////////////////////////////////////////////////////////////////////
bool cTexture :: CopyGraphic()
{
	assert( g_pScreen);

	LPDIRECTDRAWSURFACE7 lpDDSTemp;
    DDSURFACEDESC2       ddsd;
	int                  Pitch;
	int                  BytePerLine;
	int                  height = m_pGraphic->GetHeight();
	int                  width  = m_pGraphic->GetWidth();

	// ӽ ǥ .
	memset( &ddsd, 0, sizeof( ddsd));
    ddsd.dwSize          = sizeof( ddsd);
	m_lpDDS->GetSurfaceDesc( &ddsd);
	ddsd.dwFlags         = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH |
		                   DDSD_PIXELFORMAT | DDSD_TEXTURESTAGE;
	ddsd.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    ddsd.dwWidth         = width;
	ddsd.dwHeight        = height;

	if( FAILED( g_pScreen->GetDirectDraw()->CreateSurface( &ddsd, &lpDDSTemp, NULL)))
		return Fail( this, "TEXTURE_DDERR_CREATESURFACE_TEMP");

	ZeroMemory( &ddsd, sizeof( ddsd));
    ddsd.dwSize   = sizeof( ddsd);
	
	if( SUCCEEDED( lpDDSTemp->Lock( NULL, &ddsd, DDLOCK_WAIT 
		         | DDLOCK_SURFACEMEMORYPTR, NULL)))
	{
		BYTE* pDest         = ( BYTE* ) ddsd.lpSurface;
		BYTE* pSrc          = ( BYTE* ) m_pGraphic->GetImagePtr();	
	    Pitch               = ddsd.lPitch;
		BytePerLine         = width * sizeof( WORD);

		for( int i = 0 ; i < height ; i++)
		{
			memcpy( pDest, pSrc, BytePerLine);
			pDest += Pitch;       // BYTE  
			pSrc  += BytePerLine; 
		}
    	lpDDSTemp->Unlock( NULL);

		if( FAILED( m_lpDDS->Blt( NULL, lpDDSTemp, NULL, DDBLT_WAIT, NULL)))
			return Fail( this, "TEXTURE_DDSERR_BLT_TEMP_TOTEXTURE");
       
		SAFE_RELEASE( lpDDSTemp);
    	return true;

	}else return false;
}
////////////////////////////////////////////////////////////////////////
//  ȭ Լ .
////////////////////////////////////////////////////////////////////////
bool cTexture :: CopyGraphicByAsm()
{
	assert( g_pScreen);

	LPDIRECTDRAWSURFACE7 lpDDSTemp;
    DDSURFACEDESC2       ddsd;
	int                  height = m_pGraphic->GetHeight();
	int                  width  = m_pGraphic->GetWidth();
	int                  realwidth;

	memset( &ddsd, 0, sizeof( ddsd));
    ddsd.dwSize         = sizeof( ddsd);
	m_lpDDS->GetSurfaceDesc( &ddsd);
	ddsd.dwFlags        = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH |
		                  DDSD_PIXELFORMAT | DDSD_TEXTURESTAGE;
	ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE;
    ddsd.dwWidth        = width;
	ddsd.dwHeight       = height;

	if( FAILED( g_pScreen->GetDirectDraw()->CreateSurface( &ddsd, &lpDDSTemp, NULL)))
		return Fail( this, "TEXTURE_DDERR_CREATESURFACE_TEMP");

	ZeroMemory( &ddsd, sizeof( ddsd));
    ddsd.dwSize   = sizeof( ddsd);
	
	if( SUCCEEDED( lpDDSTemp->Lock( NULL, &ddsd, DDLOCK_WAIT 
		         | DDLOCK_SURFACEMEMORYPTR, NULL)))
	{   // Color Blending  ޸ ġ Ѵ.
		WORD* pDest           = ( WORD* ) ddsd.lpSurface;
		WORD* pSrc            = m_pGraphic->GetImagePtr();
	    realwidth             = ddsd.lPitch / 2; // WORD 

		for( int i = 0 ; i < height ; i++)
		{   
			Memcpy16Bit( pDest, pSrc, width); //  ڵ ȭ Լ
			pDest += realwidth;
			pSrc  += width;
		}
    	lpDDSTemp->Unlock( NULL);

	    if( FAILED( m_lpDDS->Blt( NULL, lpDDSTemp, NULL, DDBLT_WAIT, NULL)))
			return Fail( this, "TEXTURE_DDSERR_BLT_TEMP_TOTEXTURE");

        SAFE_RELEASE( lpDDSTemp);
    	return true;

	}else return false;
}
////////////////////////////////////////////////////////////////////////
bool cTexture :: Draw( int x, int y, DWORD dwFlag)
{
	assert( g_pScreen);
   
	D3DMATRIX mat;
    float xtex = ( float ) x;
	float ytex = ( float ) y;

    ConvertScreenIntoTextureCoor( xtex, ytex); 
	D3DUtil_SetIdentityMatrix( mat);
	D3DUtil_SetTranslateMatrix( mat, xtex, ytex, 0.0f);
    D3DUtil_SetScaleMatrix( mat, m_ScaleX , m_ScaleY, 0.0f);
	
	if( FAILED( g_pScreen->GetDirect3DDevice()->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat )))
		return Fail( this, "TEXTURE_D3DDERR_SETTRANSFORM_WORLD"); 
     
	if( !g_pScreen->RenderBegin()) return Fail( this, "TEXTURE_ERR_Draw_RENDERBEGIN");
	if( !DrawAlpha()) return Fail( this, "TEXTURE_ERR_DRAW");
    
	return g_pScreen->RenderEnd();
}

//////////////////////////////////////////////////////////////////////////
bool cTexture :: DrawAlpha()
{	
	assert( g_pScreen);
	LPDIRECT3DDEVICE7 lpd3ddevice = g_pScreen->GetDirect3DDevice();

	if( !SetMaterial( m_fR, m_fG, m_fB))
		return Fail( this, " TEXTURE_ERR_SETMATERIAL");
	
    if( FAILED( lpd3ddevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, true )))
		return Fail( this, "SCREEN_D3DDERR_SETRENDERSTATE");

	if( FAILED( lpd3ddevice->SetTexture( 0, m_lpDDS)))
		return Fail( this, "TEXTURE_D3DDERR_SETTEXTURE");

    if( FAILED( lpd3ddevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 
		        D3DFVF_VERTEX, g_pScreen->GetVertexs(), 4, NULL )))
		return Fail( this, "TEXTURE_D3DDERR_DRAWPRIMITIVE");

	// if( !SetMaterial( g_pScreen, 1.0f, 1.0f, 1.0f))
    //	return Fail( this, "TEXTURE_ERR_SETMATERIAL");

	if( FAILED( lpd3ddevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, false )))
        return Fail( this, "SCREEN_D3DDERR_SETRENDERSTATE");
	
	return true;
}

////////////////////////////////////////////////////////////////////////
bool cTexture :: SetMaterial( float r, float g, float b, float a )
{
	assert( g_pScreen);
	D3DMATERIAL7 mtrl;
	
	D3DUtil_InitMaterial( mtrl);
    mtrl.emissive.r = r;
    mtrl.emissive.g = g;
    mtrl.emissive.b = b;
    mtrl.emissive.a = a;
	
	if( FAILED( g_pScreen->GetDirect3DDevice()->SetMaterial( &mtrl )))
		return Fail( this, "SCREEN_D3DDERR_SETMATERIAL");
	
	return true;
}
////////////////////////////////////////////////////////////////////////
void cTexture :: ConvertScreenIntoTextureCoor( float& x, float& y)
{
	assert( g_pScreen);

	float scw = ( float ) g_pScreen->GetWidth() / 2;
	float sch = ( float ) g_pScreen->GetHeight() / 2;

	x = ( x - scw ) / ( scw / 10) ;
	y = ( sch - y ) / ( sch / 10);
}

/////////////////////////////////////////////////////////////////////////
void cTexture :: Clear()
{
   SAFE_RELEASE( m_lpDDS);
   SAFE_DELETE( m_pGraphic);
}
/////////////////////////////////////////////////////////////////////////
// Callback Function
/////////////////////////////////////////////////////////////////////////
HRESULT	WINAPI TextureSearchCallback( DDPIXELFORMAT* pddpf, LPVOID lpContext)
{
    if( NULL == pddpf || NULL == lpContext )
        return DDENUMRET_OK;

    TEXTUREINFOPtr ptsi = ( TEXTUREINFOPtr ) lpContext;

    // Skip any funky modes
    if( pddpf->dwFlags & ( DDPF_LUMINANCE | DDPF_BUMPLUMINANCE | DDPF_BUMPDUDV) )
        return DDENUMRET_OK;

    // Check for palettized formats
    if( ptsi->bUsePalette )
    {
        if( !( pddpf->dwFlags & DDPF_PALETTEINDEXED8 ) )
            return DDENUMRET_OK;

        // Accept the first 8-bit palettized format we get
        memcpy( ptsi->pddpf, pddpf, sizeof(DDPIXELFORMAT) );
        ptsi->bFoundGoodFormat = TRUE;
        return DDENUMRET_CANCEL;
    }

    // Else, skip any paletized formats (all modes under 16bpp)
    if( pddpf->dwRGBBitCount < 16 )
        return DDENUMRET_OK;

    // Skip any FourCC formats
    if( pddpf->dwFourCC != 0 )
        return DDENUMRET_OK;

    // Skip any ARGB 4444 formats (which are best used for pre-authored
    // content designed speciafically for an ARGB 4444 format).
    if( pddpf->dwRGBAlphaBitMask == 0x0000f000 )
        return DDENUMRET_OK;

    // Make sure current alpha format agrees with requested format type
    if(( ptsi->bUseAlpha == TRUE) && !( pddpf->dwFlags & DDPF_ALPHAPIXELS))
        return DDENUMRET_OK;
    if(( ptsi->bUseAlpha == false) && ( pddpf->dwFlags & DDPF_ALPHAPIXELS))
        return DDENUMRET_OK;

    // Check if we found a good match
    if( pddpf->dwRGBBitCount == ptsi->dwDesiredBPP )
    {
        memcpy( ptsi->pddpf, pddpf, sizeof( DDPIXELFORMAT) );
        ptsi->bFoundGoodFormat = TRUE;
        return DDENUMRET_CANCEL;
    }

    return DDENUMRET_OK;
}
 