     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
/////////////////////////////////////////////////////////////////////
#ifndef _TEXTURE_H_
#define _TEXTURE_H_

#ifndef  _GRAPHIC_H_
#include "Graphic.h"
#endif

#ifndef  _D3DUTIL_H_
#include "d3dutil.h"
#endif


HRESULT WINAPI TextureSearchCallback( DDPIXELFORMAT* pddpf, LPVOID lpContext);
/////////////////////////////////////////////////////////////////////
// cTexture
/////////////////////////////////////////////////////////////////////
typedef class cTexture 
{

public:
	cTexture();
	virtual ~cTexture();
   
    //////////////////////////////////////////////
  
    void     Clear();
	bool     Draw( int x, int y, DWORD dwFlag = 0);

	//////////////////////////////////////////////

    bool     LoadGraphic( string FilePath, DWORD dwFlag);
    bool     Load( cFile& file);
	bool     Save( cFile& file);

	bool     DrawAlpha();
	bool     DrawTexture();

	int      GetWidth() { return m_Canvas.size.iWidth;}
	int      GetHeight(){ return m_Canvas.size.iHeight;}
	void     SetTextureScale( float x, float y) { m_ScaleX = x, m_ScaleY= y;}
	void     SetEmissiveRGB( float r, float g, float b) { m_fR = r, m_fG = g, m_fB = b;}
 
	/////////////////////////////////////////////
private:
    bool     CreateTexture();
	bool     CopyGraphic(); 
    bool     CopyGraphicByAsm();

	bool     SetMaterial( float r = 0.0f, float g = 0.0f, float b = 0.0f, float a = 1.0f);
    void     ConvertScreenIntoTextureCoor( float& x, float& y);
 
	//////////////////////////////////////////////

public:
	LPDIRECTDRAWSURFACE7 m_lpDDS;   
    CANVAS               m_Canvas;
	int                  m_ImageSize;
	cGraphicPtr          m_pGraphic;

	float                m_ScaleX;
	float                m_ScaleY;
	float                m_fR, m_fG, m_fB;

}cTexture, * cTexturePtr, ** cTextureList ;

#endif // __SURFACE_H__
