     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// variant.cpp
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "variant.h"

///////////////////////////////////////////////////////////////////////////////
int cVariant :: GetSize()
{
	if( m_VarType == VT_void)    return 0;
	if( m_VarType == VT_int)     return sizeof( int);
	if( m_VarType == VT_char)    return sizeof( char);
	if( m_VarType == VT_bool)    return sizeof( bool);
	if( m_VarType == VT_float)   return sizeof( float);
	if( m_VarType == VT_string)  return sizeof( char*);

	return 0;
}
//////////////////////////////////////////////////////////////////////////////
void* cVariant :: CreateVariant()
{
    if( m_VarType == VT_void)    return NULL;
	if( m_VarType == VT_int)     return new int;
	if( m_VarType == VT_char)    return new char;
	if( m_VarType == VT_bool)    return new bool;
	if( m_VarType == VT_float)   return new float;

	return NULL;
}
///////////////////////////////////////////////////////////////////////////////
bool cVariant :: Load( cFile& file)
{	
	assert( file.Status() == 0 );
	if( !file.Status()) Fail( this, "VARIANT_ERR_LOAD");
     
	file.Read( &m_byTokenType, sizeof( BYTE)); 
	file.Read( &m_VarType, sizeof( VARIANT_TYPE));
    int size = GetSize();

	if( m_VarType == VT_string)
	{
		BYTE size;
        file.Read( &size, sizeof( BYTE));

		char* pch = new char [ size];
		memset( pch, 0, size);

		file.Read( pch, size);
		m_pValue = new string( pch);

		SAFE_DELETE_ARRAY( pch);
	}
	else
	{
		m_pValue = CreateVariant();
		file.Read( m_pValue, size);
	}
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
bool cVariant :: Save( cFile& file)
{
	assert( file.Status() == 0 );
	assert( m_pValue);

	if( !file.Status()) Fail( this, "VARIANT_ERR_SAVE");

	file.Write( &m_byTokenType, sizeof( BYTE));
	file.Write( &m_VarType, sizeof( VARIANT_TYPE));
	int size = GetSize();

    if( m_VarType == VT_string)
	{
	    string* pStr = ( string* ) m_pValue;
	    int size     = pStr->length() + 1;
		file.Write( &size, sizeof( BYTE)); 
		file.Write( ( void* ) pStr->c_str(), size);
	}
    
	else file.Write( m_pValue, size);
	
	return true;
}
///////////////////////////////////////////////////////////////////////////////
