     //////  /////// //     Game Engine Framework Class Library
   //       //      //      Copyright (c) 2001 () ̾ θƮ & I powersoft
  ///////  /////// //       Author : ֿ 
 //    // //      //        email  : beau007@hitel.net
 //////  /////// ////////   Build Version 0000

// World_Coodinate.h
////////////////////////////////////////////////////////////////////////
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
////////////////////////////////////////////////////////////////////////
#ifndef _WORLDCOODINATE_H_
#define _WORLDCOODINATE_H_
////////////////////////////////////////////////////////////////////////
#ifndef  _STRUCT_H_
#include "struct.h"
#endif

////////////////////////////////////////////////////////////////////////
typedef class cWorld_Coordinate
{
public:
	cWorld_Coordinate() { m_shwx = m_shwy = 0;}
	virtual ~cWorld_Coordinate(){};
    
	/////////////////////////////////

	cWorld_Coordinate& operator  = (const cWorld_Coordinate& obj);
	cWorld_Coordinate& operator += (const cWorld_Coordinate& obj);
	cWorld_Coordinate& operator -= (const cWorld_Coordinate& obj);

	cWorld_Coordinate& operator += (const POINT& pt);
	cWorld_Coordinate& operator -= (const POINT& pt);
	cWorld_Coordinate& operator  = (const POINT& pt); 

	bool operator == (const cWorld_Coordinate& obj) const;

	////////////////////////////////

	void     SetWorldCoordinates( int x, int y) { m_shwx = ( short) x, m_shwy = ( short) y;}
	void     SetWorldCoordinates( float x, float y) { m_shwx = ( short) x, m_shwy = ( short) y;}
	void     SetWorldX( int x) { m_shwx = ( short) x;} 
    void     SetWorldY( int y) { m_shwy = ( short) y;}
	 
	void     GetWorldCoordinates( int* x, int* y) { *x = ( short) m_shwx, *y = ( short) m_shwy;}
	int      GetWorldX() const { return m_shwx;} 
    int      GetWorldY() const { return m_shwy;}
	
	void     SetWorldSize( int x, int y) { sm_wWorldWidth = x, sm_wWorldHeight = y;}
	void     GetWorldSize( int* x, int* y) { *x = sm_wWorldWidth, *y = sm_wWorldHeight;} 

	////////////////////////////////////
	void     SetPosition (int x, int y)
	{ m_shwx = ( short) x, m_shwy = ( short) y;}

	void     AddPosition (int x, int y) 
	{
		m_shwx = ( short )( m_shwx + x), m_shwy = ( short )( m_shwy + y);
	}
	void     AddX (int x) { m_shwx = ( short )( m_shwx + x);}
	void     AddY (int y) { m_shwy = ( short )( m_shwy + y);}

	///////////////////////////////

protected:
	short         m_shwx, m_shwy;
	static WORD  sm_wWorldWidth;
	static WORD  sm_wWorldHeight;

} cWorld_Coordinate, *cWorld_CoordinatePtr;
////////////////////////////////////////////////////////////////////////
#endif // _WORLDCOORDINATE_H_