// DXDDraw.h: interface for the CDXDDraw class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DXDDRAW_H__0CF93A0F_94A1_43DA_A87D_44B740330F4B__INCLUDED_)
#define AFX_DXDDRAW_H__0CF93A0F_94A1_43DA_A87D_44B740330F4B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include <ddraw.h>
#include "mydef.h"

#define FPS_SHOW_ON
#define SURFACE_MAX_NUM		512

struct SSurface
{
	char FileName[256];
	LPDIRECTDRAWSURFACE7	pSurface;
	long Width;
	long Height;
	SSurface(){ pSurface=NULL; Release();}
	~SSurface(){ Release(); }
	void Release(){ SAFE_RELEASE(pSurface); ZeroMemory(FileName, 256); Width=0; Height=0; }
};

class CDXDDraw  
{
public:
	CDXDDraw();
	virtual ~CDXDDraw();
	void	ClassInit();
	void	ClassRelease();

	LPDIRECTDRAW7               m_pDDraw;			// ̷Ʈ ο..
	LPDIRECTDRAWSURFACE7        m_pDDSPrimary;		// ǥ.
	LPDIRECTDRAWSURFACE7        m_pDDSBack;			// ǥ.
	LPDIRECTDRAWCLIPPER         m_pClipper;			// Ŭ.
	DDPIXELFORMAT				m_DDPixelFormat;	// ȼ  ˾Ƴ  .
	SSurface					m_Surface[SURFACE_MAX_NUM];	// ǽ Ʈ.

	SIZE						m_MaxScrSz;			// ȭ ػ
	RECT						m_MaxScrRt;			//  ػ
	HWND						m_hWnd;				//  ڵ
	
	bool						m_bFullModeOn;		// Ǯ带  .
	BOOL						m_bDrawOn;			// ȭ ŵ  üũ.
	DWORD						m_FrmCur, m_Fps, m_TimeCur, m_TimeOld;	//  ð õ ...
	char						m_TimeStr[64];
	long						m_BitPerPixel;

	void FpsShow();

	// ũ  Լ....
	bool DDrawCreate(HWND hwnd, long width, long height, long bitPerPixel, bool fullModeOn);

	// MySurface  Լ..
	bool SurfaceCreate(long nSurface, long width, long height);
	bool SurfaceCreate(long nSurface, char * pFileName);
	bool SurfaceCreate(long nSurface, char * pFileName, COLORREF col);
	bool ColorKeySet(long nSurface, COLORREF colKey);

	bool SurfaceRelease(long nSurface);
	void SurfaceRestoreAll();
	void SurfaceToBack(long nSurface, long x, long y, RECT rt);
	void SurfaceToBackTrans(long nSurface, long x, long y, RECT rt);
	void SurfaceToSurface(long nSource, long nTarget, long x, long y, RECT rt);

	// GDI Լ....
	void PutString(long x, long y, char * pSstr, COLORREF tempCol);
	void PutString(long x, long y, char * pStr);
	void PutCheckString(long x, long y, char * pStr);
	void Rect(RECT rt, COLORREF col, bool filOn);
	void FillColor(RECT rt, COLORREF col);
	long PixelFormatCheck();
	
	// DirectDraw Լ.
	HRESULT	Blt(long nSource, RECT rtSource, long ntarget, RECT rtTarget);

	// ø Լ.
	void Flip();
	void DrawOn(BOOL drawOn);		// ׸ ȱ׸ üũ.
	void RestoreAll();

	// Ʈ  Լ...
	LPDIRECTDRAWSURFACE7 BmpLoad(LPCSTR szBitmap, long dx, long dy);
	HRESULT BmpReload(LPDIRECTDRAWSURFACE7 pdds, LPCSTR szBitmap);
	HRESULT BmpToSurface(LPDIRECTDRAWSURFACE7 pdds, HBITMAP hbm, long x, long y, long dx, long dy);
	SIZE	BmpSizeGet(char *pFileName);
};

#endif // !defined(AFX_DXDDRAW_H__0CF93A0F_94A1_43DA_A87D_44B740330F4B__INCLUDED_)
