// DXDSound.cpp: implementation of the CDXDSound class.
//
//////////////////////////////////////////////////////////////////////


#include <dsound.h>
#include <mmsystem.h>
#include "DXDSound.h"
#include "mydef.h"

#define DSVOLUME_TO_DB(volume)		((DWORD) (-30*(100-(volume))))

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDXDSound::CDXDSound()
{
	ClassInit();
}

CDXDSound::~CDXDSound()
{
	ClassRelease();
}

////////////////////////////////////////////////////
// ũ ʱȭ.........
////////////////////////////////////////////////////

void CDXDSound::ClassInit()
{
	m_pDSound=NULL;		// ̷Ʈ  ŭ .
	m_Volume=100;		//  100   ´.

	for(long i=0;i<EFFECT_MAX_NUM;i++)	
		m_pEffect[i]=NULL;
}


void CDXDSound::ClassRelease()
{
	if(m_pDSound)
	{		
		for(long i=0;i<SBUFFER_MAX_NUM;i++)	
			SBufferRelease(i);

		for(i=0;i<EFFECT_MAX_NUM;i++)
			SAFE_RELEASE(m_pEffect[i]);
	}
	SAFE_RELEASE(m_pDSound);
}

	

bool CDXDSound::DSoundCreate(HWND hwnd)
{
    if(DS_OK!=CoInitialize(NULL))	return false;
    if(DS_OK!=DirectSoundCreate(NULL, &m_pDSound, NULL))	return false;
    if(DS_OK!=m_pDSound->SetCooperativeLevel(hwnd, DSSCL_PRIORITY))     return false;

	//  ۸ Ѵ.(ǻ ׽Ʈ )
 	LPDIRECTSOUNDBUFFER pDSBPrimary = NULL;
	DSBUFFERDESC dsbd;
    ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
    dsbd.dwSize        = sizeof(DSBUFFERDESC);
    dsbd.dwFlags       = DSBCAPS_PRIMARYBUFFER;
    dsbd.dwBufferBytes = 0;
    dsbd.lpwfxFormat   = NULL;
       
    if(DS_OK!=m_pDSound->CreateSoundBuffer(&dsbd, &pDSBPrimary, NULL)) return false;

    WAVEFORMATEX wfx;
    ZeroMemory( &wfx, sizeof(WAVEFORMATEX) ); 
    wfx.wFormatTag      = WAVE_FORMAT_PCM; 
	wfx.nChannels=2;										// ° ..(׷ ƴ)
	wfx.nSamplesPerSec=22050;								// Sample Rate  11KHZ ...
	wfx.wBitsPerSample=16;									// 8Ʈ..
	wfx.nBlockAlign=wfx.wBitsPerSample/8*wfx.nChannels;		// 뿡 8Ʈ.׷ 2... 16Ʈ 4..
	wfx.nAvgBytesPerSec=wfx.nSamplesPerSec*wfx.nBlockAlign;

    if(DS_OK!=pDSBPrimary->SetFormat(&wfx))	return false;
    SAFE_RELEASE( pDSBPrimary );
	return true;	
}


bool CDXDSound::Restore(long nBuffer)
{
	if(m_pDSound==NULL)	return false;
	if((NULL==m_SSBuffer[nBuffer].pSBuffer)||(strlen(m_SSBuffer[nBuffer].FileName)<=0))
	{
		char str[256];
		wsprintf(str, "%d ۿ 尡 ϴ.", nBuffer);
		AfxErrMsg(str);
		return false;
	}

	long ret=0;
    DWORD flag;
    if(FAILED(ret=m_SSBuffer[nBuffer].pSBuffer->GetStatus(&flag)))
        return false;

    if(flag&DSBSTATUS_BUFFERLOST )
    {
		// ̷Ʈ 尡 Ʈ    ..
        do 
        {
            ret=m_SSBuffer[nBuffer].pSBuffer->Restore();
            if( ret == DSERR_BUFFERLOST )
                Sleep( 10 );
			else break;
        }
        while(ret=m_SSBuffer[nBuffer].pSBuffer->Restore());

		// Ʈ  ƿ ϰ  ٽ εѴ.
		m_SSBuffer[nBuffer].pSBuffer->Restore();
		char fileName[256];
		wsprintf(fileName, "%s", m_SSBuffer[nBuffer].FileName);
		return FileLoad(nBuffer, fileName);
    }
	return true;
}



bool CDXDSound::FileLoad(long nBuffer, char *pFileName)
{
	if(m_pDSound==NULL)	return false;

	HMMIO hwav;
	MMCKINFO	parent;
	MMCKINFO	child;
	UCHAR *snd_buffer=NULL;
	UCHAR *audio_ptr_1=NULL;
	UCHAR *audio_ptr_2=NULL;

	DWORD audio_length_1=0;
	DWORD audio_length_2=0;

	WAVEFORMATEX wfmtx;
	
	parent.ckid = (FOURCC) 0;
	parent.cksize = 0;
	parent.fccType = (FOURCC) 0;
	parent.dwDataOffset = 0;
	parent.dwFlags = 0;
	child = parent;

	// ̺  .........
	if((hwav=mmioOpen(pFileName, NULL, MMIO_READ|MMIO_ALLOCBUF)) == NULL)
	{
		AfxErrMsg("LoadWav() -> mmioOpen() Error !! \n");
		return false;
	}

	parent.fccType = mmioFOURCC('W','A','V','E');

	if(mmioDescend(hwav, &parent, NULL, MMIO_FINDRIFF))
	{
		mmioClose(hwav, 0);
		AfxErrMsg("LoadWav() -> mmioDescend() Error !! \n");
		return false;
	}

	child.ckid = mmioFOURCC('f','m','t',' ');
	if(mmioDescend(hwav, &child, &parent, 0))
	{
		mmioClose(hwav,0);
		AfxErrMsg("LoadWav() -> mmioDescend() Error !! \n");
	}

	if(mmioRead(hwav, (char *) &wfmtx, sizeof(wfmtx) ) != sizeof(wfmtx))
	{
		mmioClose(hwav,0);
		AfxErrMsg("LoadWav() -> mmioRead() Error !! \n");
	}

	if(wfmtx.wFormatTag != WAVE_FORMAT_PCM)
	{
		mmioClose(hwav,0);
		AfxErrMsg("WAVE_FORMAT_PCM ERROR !! \n");
	}

	if(mmioAscend(hwav, &child, 0))
	{
		mmioClose(hwav,0);
		AfxErrMsg("LoadWav() -> mmioAscend() Error !! !! \n");
	}

	child.ckid = mmioFOURCC('d', 'a', 't', 'a');

	if( mmioDescend(hwav, &child, &parent, MMIO_FINDCHUNK) )
	{
		mmioClose(hwav,0);
		AfxErrMsg("LoadWav() -> mmioDscend() Error !! !! \n");
	}

	// ε  ..
	snd_buffer = (UCHAR *) malloc(child.cksize);
	if(snd_buffer == NULL)
	{
		mmioClose(hwav,0);
		AfxErrMsg("LoadWav() -> malloc() Error !! !! \n");
	}

	//  ۿ ..
	mmioRead(hwav, (char *)snd_buffer, child.cksize);

	// Ͽ  ڵ ݱ.......
	mmioClose(hwav,0);


	if(SBufferCreate(nBuffer, child.cksize, &wfmtx) == NULL)
	{
		AfxErrMsg("LoadWav() -> malloc() Error !! !! \n");
		SAFE_FREE(snd_buffer);
		return false;
	}

	if(DS_OK!=m_SSBuffer[nBuffer].pSBuffer->Lock(0, child.cksize, 
												 (void **) &audio_ptr_1,
												 &audio_length_1,
												 (void **) &audio_ptr_2,
												 &audio_length_2,
												 DSBLOCK_FROMWRITECURSOR))		
												 return false;

	memcpy(audio_ptr_1, snd_buffer, audio_length_1);
	memcpy(audio_ptr_2, (snd_buffer+audio_length_1+1), audio_length_2);

	if(DS_OK!=m_SSBuffer[nBuffer].pSBuffer->Unlock(audio_ptr_1,
												   audio_length_1,
												   audio_ptr_2,
												   audio_length_2))										
												   return false;
	SAFE_FREE(snd_buffer);
	return true;
}


void CDXDSound::SBufferRelease(long nBuffer)
{
	if(m_pDSound)
	{
		m_SSBuffer[nBuffer].Release();
	}
}

bool CDXDSound::SBufferCreate(long nBuffer, DWORD bufferSize, WAVEFORMATEX *pWfx)
{
	if(m_pDSound==NULL)	return false;

	SBufferRelease(nBuffer);	// ϴ .	
	DSBUFFERDESC dsbd;		// ̷Ʈ  ۿ  
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC) );
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_STATIC | DSBCAPS_LOCSOFTWARE;
	dsbd.dwBufferBytes = bufferSize;		// 2ʰ  ....
	dsbd.lpwfxFormat = pWfx;				// ̺  .......
	
	if(DS_OK!=m_pDSound->CreateSoundBuffer(&dsbd, &m_SSBuffer[nBuffer].pSBuffer, NULL))
	{
		AfxErrMsg("InitBuffer() -> CreateSoundBuffer() Error !! \n");
		return false;
	}

	return TRUE;
}


void CDXDSound::Play(long nBuffer, bool bLoofOn)				// .
{
	if(m_pDSound==NULL)	return;
	if(!m_SSBuffer[nBuffer].pSBuffer)
	{
		char str[256];
		wsprintf(str, "%d ۿ 尡 ϴ.", nBuffer);
		AfxErrMsg(str);
		return;
	}

	long ret=false;
	if(bLoofOn)	ret=m_SSBuffer[nBuffer].pSBuffer->Play(0,0,DSBPLAY_LOOPING);
	else		ret=m_SSBuffer[nBuffer].pSBuffer->Play(0,0,0);					

	if(ret!=DS_OK)
	{
		DWORD flag=NULL;
		ret=m_SSBuffer[nBuffer].pSBuffer->GetStatus(&flag);
		if((flag&DSBSTATUS_PLAYING)||(flag&DSBSTATUS_LOOPING))	return;	//  ̸ .

		if(flag&DSBSTATUS_BUFFERLOST)
		{
			if(!Restore(nBuffer))
			{
				char str[256];
				wsprintf(str, "%d  .", nBuffer);
				AfxErrMsg(str);
				return;
			}

			// ٽý.
			if(bLoofOn)	ret=m_SSBuffer[nBuffer].pSBuffer->Play(0,0,DSBPLAY_LOOPING);
			else		ret=m_SSBuffer[nBuffer].pSBuffer->Play(0,0,0);					
		}
	}
}

void CDXDSound::Effect(long nBuffer, long volume, long pan)				// Ʈ . ѹ ϰ .
{
	if(m_pDSound==NULL)	return;
	if(!m_SSBuffer[nBuffer].pSBuffer)
	{
		char str[256];
		wsprintf(str, "%d ۿ 尡 ϴ.", nBuffer);
		AfxErrMsg(str);
		return;
	}

	//  ...
	DWORD flag=false;
	if(FAILED(m_SSBuffer[nBuffer].pSBuffer->GetStatus(&flag)))
	{
		if((flag&DSBSTATUS_PLAYING)||(flag&DSBSTATUS_LOOPING))	return;	//  ̸ .
	}
	if(flag&DSBSTATUS_BUFFERLOST)									// νƮ 쿡 .
	if(!Restore(nBuffer))
	{
		char str[256];
		wsprintf(str, "%d  .", nBuffer);
		AfxErrMsg(str);
		return;
	}

	for(long i=0;i<EFFECT_MAX_NUM;i++)
	{			
		if(NULL==m_pEffect[i])		break;	// ۰  Ѿ.
		if(FAILED(m_pEffect[i]->GetStatus(&flag)))
		{
			//  ̰ų   쿡  Ŀ ̰ ۸ .
			if(flag==DSBSTATUS_BUFFERLOST)
			{
				m_pEffect[i]->Restore();
				SAFE_RELEASE(m_pEffect[i]);
				break;
			}
		}
		if(!((flag&DSBSTATUS_PLAYING)||(flag&DSBSTATUS_LOOPING)))
		{
			SAFE_RELEASE(m_pEffect[i]);
			break;
		}
		flag=NULL;
	}

	if(i>=EFFECT_MAX_NUM)
	{
		char str[256];
		wsprintf(str, "÷ ۰  .", nBuffer);
		AfxErrMsg(str);
		return;
	}

	if(DS_OK==m_pDSound->DuplicateSoundBuffer(m_SSBuffer[nBuffer].pSBuffer, &m_pEffect[i]))
	{
		//  д .
		m_pEffect[i]->SetVolume(DSVOLUME_TO_DB(m_Volume*volume/100));	//  ° .
		m_pEffect[i]->SetPan(pan*100);									// .
		if(DS_OK==m_pEffect[i]->Play(0,0,0))
		{
			return;
		}
		else
		{
			char str[256];
			wsprintf(str, "%d PlayBuffer  .", nBuffer);
			AfxErrMsg(str);
		}
	}
	else
	{
		char str[256];
		wsprintf(str, "%d    .", nBuffer);
		AfxErrMsg(str);
	}
}


void CDXDSound::VolumeSet(long nPercent)
{
	if(m_pDSound==NULL)	return;
	if(nPercent<0)		nPercent=0;
	if(nPercent>100)	nPercent=100;

	m_Volume=nPercent;	//   .
	
	for(long i=0;i<SBUFFER_MAX_NUM;i++)	
	{
		if(m_SSBuffer[i].pSBuffer)		
			m_SSBuffer[i].pSBuffer->SetVolume(DSVOLUME_TO_DB(nPercent));	//  ° .
	}
}


void CDXDSound::Stop(long nBuffer)
{
	if(m_pDSound==NULL)	return;
	if(!m_SSBuffer[nBuffer].pSBuffer)
	{
		char str[256];
		wsprintf(str, "%d ۿ 尡 ϴ.", nBuffer);
		AfxErrMsg(str);
		return;
	}

	DWORD flag;
    m_SSBuffer[nBuffer].pSBuffer->GetStatus(&flag);

	// ۵ ̸ .
	if((flag&DSBSTATUS_PLAYING)||(flag&DSBSTATUS_LOOPING))
	{
		if(DS_OK!=m_SSBuffer[nBuffer].pSBuffer->Stop())
		{
			char str[256];
			wsprintf(str, "%d   .", nBuffer);
			AfxErrMsg(str);
		}
		m_SSBuffer[nBuffer].pSBuffer->SetCurrentPosition(0L);	//  ó .
	}
}

