// DXDSound.h: interface for the CDXDSound class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DXDSOUND_H__2A938E2F_9E84_43A9_BA50_97C213559BC3__INCLUDED_)
#define AFX_DXDSOUND_H__2A938E2F_9E84_43A9_BA50_97C213559BC3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mydef.h"
#include "dsound.h"

//  ʿ ִ  (    )..........
#define SBUFFER_MAX_NUM				100
#define EFFECT_MAX_NUM				50

struct SSBuffer
{
	char FileName[256];
	LPDIRECTSOUNDBUFFER pSBuffer;
	SSBuffer(){ pSBuffer=NULL; Release();}
	~SSBuffer(){ Release(); }
	void Release(){ SAFE_RELEASE(pSBuffer); ZeroMemory(FileName, 256); }
};

//DuplicateSoundBuffer
class CDXDSound  
{
public:
	CDXDSound();
	virtual ~CDXDSound();

	void ClassInit();
	void ClassRelease();

	LPDIRECTSOUND			m_pDSound;						// ̷Ʈ .
	SSBuffer				m_SSBuffer[SBUFFER_MAX_NUM];	// Ϲ.
	LPDIRECTSOUNDBUFFER		m_pEffect[EFFECT_MAX_NUM];
	
	long		m_Volume;		// ü .
	
	// ̷Ʈ  ʱȭ........
	bool DSoundCreate(HWND hwnd);

	//  .
	bool FileLoad(long nBuffer, char *pFileName);
	bool SBufferCreate(long nBuffer, DWORD bufferSize, WAVEFORMATEX *pWfx);
	void SBufferRelease(long nBuffer);

	bool Restore(long nBuffer);

	//  Ʈ...
	void Play(long nBuffer, bool bLoofOn);				//  . (  )
	void Effect(long nBuffer, long volume, long pan);	// Ʈ . ѹ ϰ .
	void VolumeSet(long nPercent);
	void Stop(long nBuffer);
};
#endif // !defined(AFX_DXDSOUND_H__2A938E2F_9E84_43A9_BA50_97C213559BC3__INCLUDED_)
