#ifndef MY_DEFINE
#define MY_DEFINE

#define SAFE_RELEASE(p)	{ if(p)	(p)->Release(); (p)=NULL;	}
#define SAFE_DELETE(p)	{ if(p)	delete(p); (p)=NULL;	}
#define SAFE_FREE(p)	{ if(p)	free(p); (p)=NULL;	}

#define SAFE_INIT(val, form)	{ memset(&val, 0, sizeof(form));	val.dwSize=sizeof(form);}
#define	RT_WIDTH(rt)	(rt.right-rt.left)
#define	RT_HEIGHT(rt)	(rt.bottom-rt.top)

#define XY_IN_RT(x,y,rt)							((x>=rt.left)&&(x<rt.right)&&(y>=rt.top)&&(y<rt.bottom))
#define PT_IN_RT(pt, rt)							XY_IN_RT(pt.x, pt.y, rt)
#define RT_IN_RT(x, y, x1, y1, rt)					(((x)<rt.right)&&((y)<rt.bottom)&&((x1)>=rt.left)&&((y1)>=rt.top))
#define RT_CROSS(rt1, rt2)							(((rt1.left)<rt2.right)&&((rt1.top)<rt2.bottom)&&((rt1.right)>=rt2.left)&&((rt1.bottom)>=rt2.top))

#define PT_ADD_PT(pt1, pt2)							(pt1.x+=pt2.x, pt1.y+=pt2.y)
#define RT_ADD_RT(t1, rt2)							(rt1.left+=rt2.left, rt1.top+=rt2.top, rt1.right+=rt2.right, rt1.bottom+=rt2.bottom)
#define RT_ADD_PT(rt, pt)							(rt.left+=pt.x, rt.top+=pt.y, rt.right+=pt.x, rt.bottom+=pt.y)
#define RT_ADD_XY(rt, x, y)							(rt.left+=x, rt.top+=y, rt.right+=x, rt.bottom+=y)
#define RT_SUB_PT(rt, pt)							(rt.left-=pt.x, rt.top-=pt.y, rt.right-=pt.x, rt.bottom-=pt.y)
#define RT_SUB_XY(rt, x, y)							(rt.left-=x, rt.top-=y, rt.right-=x, rt.bottom-=y)

// RGB Į 15, 16, 24Ʈ  ...
#define RGB_SET(colBit, col)		{ if(colBit==15) col=(((col<<7)&0x7C00)|((col>>6)&0x03E0)|((col>>19)&0x001F)); else if(colBit==16) col=(((col<<8)&0xF800)|((col>>5)&0x07E0)|((col>>19)&0x001F)); else col=(((col<<16)&0xff0000)|((col)&0xff00)|((col>>16)&0xff)); }

//  ڿ .
#define PutErrString(str, fileName, lineNum)	{ char buf[256]; wsprintf(buf, "error : %s (%d) - %s\n", fileName, lineNum, str); OutputDebugString(buf); }
#define PutErrMsg(str, fileName, lineNum)		{ PutErrString(str, fileName, lineNum);	}
#define AfxErrMsg(str)							{ PutErrMsg(str, __FILE__, __LINE__); }

struct SDraw
{
	long nSurface;	// ũ ȣ........
	long ImgBottom;	// ̹  bottom . (  .......
	POINT Pt;	// ׸ ǥ.
	RECT  Rt;	// ׸ .

    operator<(const SDraw &draw)
    {	
		return ImgBottom<draw.ImgBottom;		// ⼭  ........
    }                 
};

#endif