// ClearSourceControl.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#pragma warning(disable:4786)

#include <deque>
#include <string>

#include <stdio.h>
#include <windows.h>
#include <conio.h>

#include <direct.h>

void SaveFile(const char* c_szPath, const std::deque<std::string> c_stDeque)
{
	SetFileAttributes(c_szPath, FILE_ATTRIBUTE_NORMAL);

	FILE* fp=fopen(c_szPath, "w");
	if (!fp) return;
	for (std::deque<std::string>::const_iterator i=c_stDeque.begin(); i!=c_stDeque.end(); ++i)
		fprintf(fp, "%s", i->c_str());	
	fclose(fp);	
}

void ClearSourceControlInProject(const char* c_szPath)
{
	std::deque<std::string> stDeque;
	
	FILE* fp=fopen(c_szPath, "r");
	if (!fp) 
	{
		printf("%s open error\n", c_szPath);
		return;
	}
	
	char szLine[256];

	while (1)
	{
		szLine[0]=0;
		if (!fgets(szLine, sizeof(szLine), fp)) break;

		const char* c_szScc_ProjName="# PROP Scc_ProjName";
		const char* c_szScc_LocalPath="# PROP Scc_LocalPath";
		if (!strncmp(szLine, c_szScc_ProjName, strlen(c_szScc_ProjName)))
			stDeque.push_back("# PROP Scc_ProjName \"\"\r\n");
		else if (!strncmp(szLine, c_szScc_LocalPath, strlen(c_szScc_LocalPath)))
			stDeque.push_back("# PROP Scc_LocalPath \"\"\r\n");
		else
			stDeque.push_back(szLine);
	}	

	fclose(fp);

	SaveFile(c_szPath, stDeque);

	printf("%s complete\n", c_szPath);
}

void Delete(const char* c_szDir, const char* c_szFile)
{
	std::string stName;
	stName+=c_szDir;
	stName+="\\";
	stName+=c_szFile;

	SetFileAttributes(stName.c_str(), FILE_ATTRIBUTE_NORMAL);
	unlink(stName.c_str());

	printf("delete [%s]\n", stName.c_str());
	
}

void ChangeFileAttribute(const char* c_szDir, const char* c_szFile)
{
	std::string stName;
	stName+=c_szDir;
	stName+="\\";
	stName+=c_szFile;
	SetFileAttributes(stName.c_str(), FILE_ATTRIBUTE_NORMAL);
}

void ChangeFolderAttribute(const char* c_szPath)
{
	char szFilter[256];
	sprintf(szFilter, "%s\\*.*", c_szPath);
	WIN32_FIND_DATA wfd;
	memset(&wfd,0,sizeof(WIN32_FIND_DATA));
	HANDLE hFind=FindFirstFile(szFilter,&wfd);
	if(hFind==INVALID_HANDLE_VALUE) 
	{
		FindClose(hFind);
		return;
	}
	if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) 
	{	
		ChangeFileAttribute(c_szPath, wfd.cFileName);		
	}

	while (FindNextFile(hFind,&wfd)) 
	{
		if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
		{
			ChangeFileAttribute(c_szPath, wfd.cFileName);			
		}			
	}
	FindClose(hFind);
}

std::string ChangeExt(const char* c_szFile, const char* c_szExt)
{
	std::string stFile=c_szFile;
	int pos=stFile.find_last_of('.');
	if (pos>=0) 
		stFile=stFile.substr(0, pos);
	
	stFile+='.';
	stFile+=c_szExt;
	return stFile;
}

std::string GetFolder(const char* c_szName)
{
	std::string stName=c_szName;
	int pos=stName.find_last_of('\\');
	if (pos<0) return ".";

	return stName.substr(0, pos);
}

std::string GetFileName(const char* c_szName)
{
	std::string stName=c_szName;
	int pos=stName.find_last_of('\\');
	if (pos<0) return c_szName;

	++pos;
	return stName.substr(pos, stName.length()-pos);
}

int main(int argc, char* argv[])
{
	if (argc!=2)
	{
		printf("ClearSourceControl name.dsw\n");
		puts("press any key for exit...");
		getch();
		return 0;
	}

	std::string stFileName=GetFileName(argv[1]);
	
	_chdir(GetFolder(argv[1]).c_str());

	FILE* fp=fopen(stFileName.c_str(), "r");	
	if (!fp) 
	{
		printf("%s file open error", stFileName.c_str());
		puts("press any key for exit...");
		getch();
		return 0;
	}

	std::deque<std::string> stDeque;
	char szLine[256];	
	bool isSourceControlBlock=false;
	while (1)
	{
		szLine[0]=0;
		if (!fgets(szLine, sizeof(szLine), fp)) break;
		
		const char* c_szProject="Project:";													
		const char* c_szBeginSourceCodeControl="    begin source code control";
		const char* c_szEndSourceCodeControl="    end source code control";

		if (!strncmp(szLine, c_szProject, strlen(c_szProject)))
		{
			char* pszLine=strchr(szLine, '=');
			if (pszLine)
			{			
				char szPath[256];
				sscanf(pszLine+1, "%s", szPath);
				
				ClearSourceControlInProject(szPath);

				char* pszEnd=strrchr(szPath, '\\');
				*pszEnd=0;

				ChangeFolderAttribute(szPath);

				Delete(szPath, "mssccprj.scc");
				Delete(szPath, "vssver.scc");				
				
			}
		}
		if (!strncmp(szLine, c_szEndSourceCodeControl, strlen(c_szEndSourceCodeControl)))
		{
			isSourceControlBlock=false;
			continue;
		}
		if (!strncmp(szLine, c_szBeginSourceCodeControl, strlen(c_szBeginSourceCodeControl)))
		{
			isSourceControlBlock=true;
			continue;
		}
		if (isSourceControlBlock) continue;

		stDeque.push_back(szLine);
	}
	fclose(fp);
	
	ChangeFolderAttribute(".");
	
	Delete(".", ChangeExt(stFileName.c_str(), "ncb").c_str());
	Delete(".", ChangeExt(stFileName.c_str(), "opt").c_str());
	
	Delete(".", "mssccprj.scc");
	Delete(".", "vssver.scc");

	SaveFile(stFileName.c_str(), stDeque);

	printf("%s complete\n\n", argv[1]);

	puts("press any key for exit...");
	getch();
	return 0;
}
