#include "BMP.h"


/*  ޼ҵ  */
BMP::BMP(LPCSTR fileName)
{
	hbm = NULL;
	memset(&bm, 0, sizeof(BITMAP));
	lpDDSBitmap = NULL;
	if(fileName) load(fileName);
}


BMP::~BMP()
{
	release();
}


void BMP::release() // Ʈ ǥ 
{
	SAFE_RELEASE(lpDDSBitmap);
}


LPDIRECTDRAWSURFACE7 BMP::getBuffer() // ܺο Ʈ ǥ   ְ...
{
	return lpDDSBitmap;
}


LPDIRECTDRAWSURFACE7 BMP::createOffScreen() // Ʈ  ũ !
{
	LPDIRECTDRAWSURFACE7 lpOffScreen; // ũ 
	DD_INIT_STRUCT(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth = bm.bmWidth;
	ddsd.dwHeight = bm.bmHeight;
	if(FAILED(lpDD->CreateSurface(&ddsd, &lpOffScreen, NULL))) return NULL;
	// set color key to color 0
	colorKey.dwColorSpaceLowValue  = 0;
	colorKey.dwColorSpaceHighValue = 0;
	// now set the color key for source blitting
	lpOffScreen->SetColorKey(DDCKEY_SRCBLT, &colorKey);
	return lpOffScreen;
}


BOOL BMP::load(LPCSTR fileName) // Ʈ  ε
{
	//  ũ ǥ ..
	release();
	
	// Ʈ  б
	hbm = (HBITMAP)LoadImage(NULL, fileName, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	if (hbm == NULL) return FALSE;
	
	GetObject(hbm, sizeof(bm), &bm); // get size of bitmap

	// ũ 
	lpDDSBitmap = createOffScreen();
	if(lpDDSBitmap == NULL) return FALSE; // Ʈ ũ  !

	// о Ʈ  ũ ~
	HDC hdcImage;
	HDC hdc;

	// select bitmap into a memoryDC so we can use it.
	hdcImage = CreateCompatibleDC(NULL);
	SelectObject(hdcImage, hbm);
	
	if(FAILED(lpDDSBitmap->GetDC(&hdc))) return FALSE;
	BitBlt(hdc, 0, 0, bm.bmWidth, bm.bmHeight, hdcImage, 0, 0, SRCCOPY);

	lpDDSBitmap->ReleaseDC(hdc);
	DeleteDC(hdcImage);

	return TRUE;
}


void BMP::draw(int x, int y) // Ʈ ۿ ׸
{
	RECT sourceRect = {0, 0, bm.bmWidth, bm.bmHeight};
	lpDDSBack->BltFast(x, y, lpDDSBitmap, &sourceRect, DDBLTFAST_WAIT);
}
