#include "DDraw.h"

//extern int screenWidth;
//extern int screenHeight;
//extern int screenBpp;


// ̷Ʈ ο  
LPDIRECTDRAW7 lpDD = NULL;
LPDIRECTDRAWSURFACE7 lpDDSPrimary = NULL;
LPDIRECTDRAWSURFACE7 lpDDSBack = NULL;
LPDIRECTDRAWPALETTE lpDDPal = NULL;
LPDIRECTDRAWCLIPPER lpDDClipper = NULL;
DDSURFACEDESC2 ddsd;
DDSCAPS2 ddscaps;
DDBLTFX ddbltfx;
DDCOLORKEY colorKey;
int sx_clip, sy_clip, ex_clip, ey_clip; // Ŭ  

// ƽ 
static unsigned int clockCount;
static PALETTEENTRY palette[256];
static PALETTEENTRY save_palette[256];


/* ̷Ʈ ο  ޼ҵ */
DDraw::DDraw(HWND hWnd)
{
	lpDD = NULL;
	lpDDSPrimary = NULL;
	lpDDSBack = NULL;
	lpDDPal = NULL;
	lpDDClipper = NULL;
	memset(&ddsd, 0, sizeof(ddsd)); //ZeroMemory(&ddsd, sizeof(ddsd));
	memset(&ddscaps, 0, sizeof(ddscaps));
	memset(&ddbltfx, 0, sizeof(ddbltfx));
	memset(&palette, 0, sizeof(palette));
	memset(&colorKey, 0, sizeof(colorKey));
	this->hWnd = hWnd;
	videoBuffer = NULL;
	screenWidth = SCREEN_WIDTH;
	screenHeight = SCREEN_HEIGHT;
	screenBpp = SCREEN_BPP;
	isWindowed = FALSE;
	greyscaleON = FALSE;
	hr = NULL;
}


DDraw::~DDraw()
{
	releaseAll();
}


void DDraw::releaseAll()
{
	SAFE_RELEASE(lpDDPal);
	SAFE_RELEASE(lpDDSBack);
	SAFE_RELEASE(lpDDSPrimary);
	SAFE_RELEASE(lpDD);
}


BOOL DDraw::initFullScreenMode(int width, int height, int bpp)
{
	screenWidth = width;
	screenHeight = height;
	screenBpp = bpp;
	isWindowed = FALSE;

	releaseAll();

	// ̷Ʈ ο ü 
	hr = DirectDrawCreateEx(NULL, (LPVOID *)&lpDD, IID_IDirectDraw7, NULL);
	if(FAILED(hr)) return FALSE;
	hr = lpDD->SetCooperativeLevel(hWnd, DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT);
	if(FAILED(hr)) return FALSE;
	if(FAILED(lpDD->SetDisplayMode(screenWidth, screenHeight, screenBpp, 0, 0)))
		return FALSE;

	// 1ǥ(⺻ǥ) 
	ZeroMemory(&ddsd, sizeof(ddsd)); // memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX; // | DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = 1;
    if(FAILED(lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL)))
		return FALSE;

	// 2ǥ() 
	ZeroMemory(&ddscaps, sizeof(ddscaps));
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	if(FAILED(lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack)))
		return FALSE;

	//ǥ ֱ
	clearSurface(lpDDSPrimary);
	clearSurface(lpDDSBack);
	setClipRect(0, 0, screenWidth, screenHeight);
	return TRUE;
}


BOOL DDraw::initWindowMode(int width, int height)
{
	screenWidth = width;
	screenHeight = height;
	isWindowed = TRUE;

	releaseAll();
	// ̷Ʈ ο ü 
	if(FAILED(DirectDrawCreateEx(NULL, (LPVOID *)&lpDD, IID_IDirectDraw7, NULL)))
		return FALSE;
	if(FAILED(lpDD->SetCooperativeLevel(hWnd, DDSCL_NORMAL)))
		return FALSE;

	// 1ǥ(⺻ǥ) 
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	if(FAILED(lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL)))
		return FALSE;

	// 2ǥ() 
	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddscaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; // | DDSCAPS_3DDEVICE;
	ddsd.dwWidth = width;
	ddsd.dwHeight = height;
	if(FAILED(lpDD->CreateSurface(&ddsd, &lpDDSBack, NULL)))
		return FALSE;

	// Ŭ 
	if(FAILED(lpDD->CreateClipper(0, &lpDDClipper, NULL)))
		return FALSE;
	if(FAILED(lpDDClipper->SetHWnd(0, hWnd))){
		lpDDClipper->Release();
		return FALSE;
	}
	if(FAILED(lpDDSPrimary->SetClipper(lpDDClipper))){
		lpDDClipper->Release();
		return FALSE;
	}
	lpDDClipper->Release();

	updateBounds();

	// ȼ Ʈ ˾Ƴ
	DDPIXELFORMAT pixelFormat;
	DD_INIT_STRUCT(pixelFormat);
	lpDDSPrimary->GetPixelFormat(&pixelFormat);
	screenBpp = pixelFormat.dwRGBBitCount;

	// ǥ ֱ
	clearSurface(lpDDSPrimary);
	clearSurface(lpDDSBack);
	setClipRect(0, 0, screenWidth, screenHeight);
	return TRUE;
}


void DDraw::updateBounds()
{
    if( isWindowed )
    {
        GetClientRect( hWnd, &windowRect );
        ClientToScreen( hWnd, (POINT*)&windowRect );
        ClientToScreen( hWnd, (POINT*)&windowRect+1 );
    }
    else
    {
        SetRect( &windowRect, 0, 0, GetSystemMetrics(SM_CXSCREEN),
                 GetSystemMetrics(SM_CYSCREEN) );
    }
}


LPDIRECTDRAWCLIPPER DDraw::attachClipper(LPDIRECTDRAWSURFACE7 lpdds, int num_rects, LPRECT clip_list)
{
	int index;
	LPDIRECTDRAWCLIPPER lpddclipper;
	LPRGNDATA region_data; // pointer to the region data that contains the header and clip list
	
	// first create the direct draw clipper
	if (FAILED(lpDD->CreateClipper(0, &lpddclipper, NULL)))return(NULL);
	// now create the clip list from the sent data
	// first allocate memory for region data
	region_data = (LPRGNDATA)malloc(sizeof(RGNDATAHEADER)+num_rects*sizeof(RECT));
	// now copy the rects into region data
	memcpy(region_data->Buffer, clip_list, sizeof(RECT)*num_rects);
	// set up fields of header
	region_data->rdh.dwSize          = sizeof(RGNDATAHEADER);
	region_data->rdh.iType           = RDH_RECTANGLES;
	region_data->rdh.nCount          = num_rects;
	region_data->rdh.nRgnSize        = num_rects*sizeof(RECT);
	
	region_data->rdh.rcBound.left    =  64000;
	region_data->rdh.rcBound.top     =  64000;
	region_data->rdh.rcBound.right   = -64000;
	region_data->rdh.rcBound.bottom  = -64000;
	// find bounds of all clipping regions
	for (index=0; index<num_rects; index++)
	{
		// test if the next rectangle unioned with the current bound is larger
		if (clip_list[index].left < region_data->rdh.rcBound.left)
			region_data->rdh.rcBound.left = clip_list[index].left;
		
		if (clip_list[index].right > region_data->rdh.rcBound.right)
			region_data->rdh.rcBound.right = clip_list[index].right;
		
		if (clip_list[index].top < region_data->rdh.rcBound.top)
			region_data->rdh.rcBound.top = clip_list[index].top;
		if (clip_list[index].bottom > region_data->rdh.rcBound.bottom)
			region_data->rdh.rcBound.bottom = clip_list[index].bottom;
	}
	// now we have computed the bounding rectangle region and set up the data
	// now let's set the clipping list
	
	if (FAILED(lpddclipper->SetClipList(region_data, 0)))
	{
		// release memory and return error
		free(region_data);
		return(NULL);
	}
	
	// now attach the clipper to the surface
	if (FAILED(lpdds->SetClipper(lpddclipper)))
	{
		// release memory and return error
		free(region_data);
		return(NULL);
	}
	
	// all is well, so release memory and send back the pointer to the new clipper
	free(region_data);
	return(lpddclipper);
}


BOOL DDraw::flip()
{
	if(lpDDSPrimary->Flip(NULL, DDFLIP_WAIT) != DD_OK) return FALSE;
	return TRUE;
}




void DDraw::clearSurface(LPDIRECTDRAWSURFACE7 lpSurface)
{
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0;
	lpSurface->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );
}


void DDraw::clearBackSurface()
{
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0;
	lpDDSBack->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );
}


void DDraw::fillRect(RECT *rect, int color){
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = color;
	lpDDSBack->Blt(rect, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbltfx);
}


void DDraw::putString(int x, int y, char *Message)
{
	HDC hdc;
	lpDDSPrimary->GetDC(&hdc);
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB(255, 255, 255));
	TextOut(hdc, x, y, Message, strlen(Message));
	lpDDSPrimary->ReleaseDC(hdc);
}


// 8Ʈ ÷ 
void DDraw::getPalette8()
{
	lpDDPal->GetEntries(0, 0, 256, palette);
}


void DDraw::savePalette8()
{
	lpDDPal->GetEntries(0, 0, 256, save_palette);
}


void DDraw::restorePalette8()
{
	greyscaleON = FALSE;
	for(int index=0; index<256; index++){
		palette[index].peRed = save_palette[index].peRed;
		palette[index].peGreen = save_palette[index].peGreen;
		palette[index].peBlue = save_palette[index].peBlue;
	}
	lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
	lpDDPal->SetEntries(0, 0, 256, palette);
}
		

void DDraw::greyScale8()
{
	if(greyscaleON) return;
	greyscaleON = TRUE;
	lpDDPal->GetEntries(0, 0, 256, palette);
	for(int index=0; index<256; index++){
		save_palette[index].peRed = palette[index].peRed;
		save_palette[index].peGreen = palette[index].peGreen;
		save_palette[index].peBlue = palette[index].peBlue;
		palette[index].peRed = palette[index].peGreen = palette[index].peBlue =
			(palette[index].peRed+palette[index].peGreen+palette[index].peBlue)/3;
	}
	lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
	lpDDPal->SetEntries(0, 0, 256, palette);
}


void DDraw::fadeIn8(int step)
{
	if(screenBpp != 8) return;

    int i, j;
	PALETTEENTRY palen[256];

    for (j=0; j<step; j++)
    {
        for (i=0; i<256; i++)
        {
            palen[i].peRed = palette[i].peRed * j / step; 
            palen[i].peGreen = palette[i].peGreen * j / step;
            palen[i].peBlue = palette[i].peBlue * j / step;
        }
        lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
        lpDDPal->SetEntries(0, 0, 256, palen);
    }
}


void DDraw::fadeOut8(int step)
{
	if(screenBpp != 8) return;

    int i, j;
	PALETTEENTRY palen[256];

    for (j=step; j>0; j--)
    {
        for (i=0; i<256; i++)
        {
            palen[i].peRed = palette[i].peRed * j / step; 
            palen[i].peGreen = palette[i].peGreen * j / step;
            palen[i].peBlue = palette[i].peBlue * j / step;
        }
        lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL);
        lpDDPal->SetEntries(0, 0, 256, palen);
    }
}


int DDraw::putPixel8(int x, int y, int color)
{
	ddsd.dwSize = sizeof(ddsd);
	if(lpDDSBack->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL) != DD_OK)
		return 0;
	videoBuffer = (UCHAR *)ddsd.lpSurface;
	videoBuffer[y*ddsd.lPitch + x] = color;
	if(lpDDSBack->Unlock(NULL) != DD_OK)
		return 0;

	return 1;
}


void DDraw::hLine8(int x, int y, int width, int color)
{
	ddsd.dwSize = sizeof(ddsd);
	lpDDSBack->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
	int memPitch = (int)ddsd.lPitch;
	videoBuffer = (UCHAR *)ddsd.lpSurface;
	for(int index=x; index<x+width; index++){
		videoBuffer[y*memPitch + index] = color;
	}
    lpDDSBack->Unlock(NULL);
}


void DDraw::vLine8(int x, int y, int height, int color)
{
	ddsd.dwSize = sizeof(ddsd);
	lpDDSBack->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
	int memPitch = (int)ddsd.lPitch;
	videoBuffer = (UCHAR *)ddsd.lpSurface;
	for(int index=y; index<y+height; index++){
		videoBuffer[index*memPitch + x] = color;
	}
    lpDDSBack->Unlock(NULL);
}


void DDraw::circle8(int x, int y, int Radius, int color)
{
	int iX, iY;
	float angle;
	
	ddsd.dwSize = sizeof(ddsd);
	lpDDSBack->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
	int memPitch = (int)ddsd.lPitch;
	videoBuffer = (UCHAR *)ddsd.lpSurface;
	for(angle = 0; angle < (float)2*PI; angle+= (float)PI/180)
	{
		iX = (int)(x + ((float)Radius * cos(angle)));
		iY = (int)(y + ((float)Radius * sin(angle)));
		videoBuffer[iY*memPitch + iX] = (UCHAR)color;
	}
	lpDDSBack->Unlock(NULL);
}


void DDraw::rect8(int x, int y, int width, int height, int color)
{
	hLine8(x, y, width, color);
	hLine8(x, y+height, width, color);
	vLine8(x, y, height, color);
	vLine8(x+width, y, height, color);
}


/* Ÿ  Լ */
void startClock()
{
	clockCount = GetTickCount();
}


void waitClock(unsigned int count)
{
	while((GetTickCount() - clockCount) < count);
}


void setClipRect(int sx, int sy, int ex, int ey) // Ŭ  
{
	if(sx==ex || sy==ey) return;
	if(sx>ex){
		int temp = sx;
		sx = ex;
		ex = temp;
	}
	if(sy>ey){
		int temp = sy;
		sy = ey;
		ey = temp;
	}
	if(sx<0) sx = 0;
	if(sy<0) sy = 0;
	if(ex>screenWidth) ex = screenWidth;
	if(ey>screenHeight) ey = screenHeight;

	sx_clip = sx;
	sy_clip = sy;
	ex_clip = ex;
	ey_clip = ey;
}
