#ifndef __DDraw_h_included__
#define __DDraw_h_included__

#include "DX.h"
#include "c:\Dxsdk\include\ddraw.h"


//  
extern LPDIRECTDRAW7 lpDD;
extern LPDIRECTDRAWSURFACE7 lpDDSPrimary;
extern LPDIRECTDRAWSURFACE7 lpDDSBack;
extern LPDIRECTDRAWPALETTE lpDDPal;
extern LPDIRECTDRAWCLIPPER lpDDClipper;
extern DDSURFACEDESC2 ddsd;
extern DDSCAPS2 ddscaps;
extern DDBLTFX ddbltfx;
extern DDCOLORKEY colorKey;
extern int sx_clip, sy_clip, ex_clip, ey_clip; // Ŭ  


#define DD_INIT_STRUCT(ddstruct) { memset(&ddstruct,0,sizeof(ddstruct)); ddstruct.dwSize=sizeof(ddstruct); }

#define MAX_COLORS_PALETTE	256


/* ̷Ʈ ο Ŭ */
class DDraw
{
private:
	HWND hWnd; //  ڵ
	UCHAR *videoBuffer; // ޸𸮹
	BOOL isWindowed; // Ǯũ ?  ?
	RECT windowRect; //  
	BOOL greyscaleON;
	HRESULT hr; // ϰ

public:
	DDraw(HWND hWnd);
	~DDraw();
	void releaseAll();
	BOOL initFullScreenMode(int width = SCREEN_WIDTH, int height = SCREEN_HEIGHT, int bpp = SCREEN_BPP);
	BOOL initWindowMode(int width = SCREEN_WIDTH, int height = SCREEN_HEIGHT);
	void updateBounds();
	LPDIRECTDRAWCLIPPER attachClipper(LPDIRECTDRAWSURFACE7 lpdds, int num_rects, LPRECT clip_list);
	BOOL flip();
	void clearSurface(LPDIRECTDRAWSURFACE7 lpSurface);
	void clearBackSurface();
	void putString(int x, int y, char *Message);
	void fillRect(RECT *rect, int color);
	// 8Ʈ ÷ 
	void getPalette8();
	void savePalette8();
	void restorePalette8();
	void greyScale8();
	void fadeIn8(int step);
	void fadeOut8(int step);
	int putPixel8(int x, int y, int color);
	void hLine8(int x, int y, int width, int color);
	void vLine8(int x, int y, int height, int color);
	void circle8(int x, int y, int radius, int angle);
	void rect8(int x, int y, int width, int height, int color);
};


/* Ÿ  Լ */
void startClock();
void waitClock(unsigned int count);
void setClipRect(int sx, int sy, int ex, int ey);

#endif