#include "DInput.h"

/* ̷Ʈ ǲ  ޼ҵ */
DInput::DInput()
{
	lpDI = NULL;
	lpDIDKeyboard = NULL;
	lpDIDMouse = NULL;
	memset(&keyBuffer, 0, sizeof(keyBuffer));
	memset(&mouseState, 0, sizeof(mouseState));
	mouseLB = mouseMB = mouseRB = 0;
	mouseX = mouseOldX = 0;
	mouseY = mouseOldY = 0;
	m_bKeyboard = FALSE;
	m_bMouse = FALSE;
	mouseStateLB = 0;
	hr = NULL;
}


DInput::~DInput()
{
	if(lpDIDMouse){
		lpDIDMouse->Unacquire();
		lpDIDMouse->Release();
		lpDIDMouse = NULL;
	}
	if(lpDIDKeyboard){
		lpDIDKeyboard->Unacquire();
		lpDIDKeyboard->Release();
		lpDIDKeyboard = NULL;
	}
	if(lpDI){
		lpDI->Release();
		lpDI = NULL;
	}
}


BOOL DInput::init(HINSTANCE hInst, HWND hWnd, BOOL bKey, BOOL bMouse)
{
	hr = DirectInput8Create((HINSTANCE)hInst, DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&lpDI, NULL); 
	if(hr != DI_OK) return FALSE;
        
	// Create the keyboard device
	if(bKey)
	{
		hr = lpDI->CreateDevice(GUID_SysKeyboard, &lpDIDKeyboard, NULL);
		if(hr == DI_OK)
		{
			lpDIDKeyboard->SetDataFormat(&c_dfDIKeyboard);
			lpDIDKeyboard->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
			hr = lpDIDKeyboard->Acquire();
			if(hr != DI_OK) return FALSE;
			m_bKeyboard = TRUE;
		}
	}
	
	// Create the mouse device
	if(bMouse)
	{
		hr = lpDI->CreateDevice(GUID_SysMouse, &lpDIDMouse, NULL);
		if(hr == DI_OK)
		{
			lpDIDMouse->SetDataFormat(&c_dfDIMouse);
			lpDIDMouse->SetCooperativeLevel(hWnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND);
			hr = lpDIDMouse->Acquire();
			if(hr != DI_OK) return FALSE;
			m_bMouse = TRUE;
		}
	}
	
	return TRUE;
}


void DInput::update()
{
	if(m_bKeyboard)
	{
		if(lpDIDKeyboard->GetDeviceState(sizeof(keyBuffer), (LPVOID)&keyBuffer) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			lpDIDKeyboard->Acquire();
	}

	if(m_bMouse)
	{
		if(lpDIDMouse->GetDeviceState(sizeof(mouseState), &mouseState) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			lpDIDMouse->Acquire();
		mouseOldX = mouseX;
		mouseOldY = mouseY;
		mouseX += mouseState.lX;
		mouseY += mouseState.lY;
		
		mouseOldLB = mouseLB;
		mouseLB = mouseState.rgbButtons[0];
		mouseRB = mouseState.rgbButtons[1];
		mouseMB = mouseState.rgbButtons[2];

		mouseStateLB = 0;
		if(mouseOldLB) mouseStateLB = 0x02;
		if(mouseLB) mouseStateLB |= 0x01;
	}
}


BOOL DInput::keyDown(UCHAR key)
{
	return (keyBuffer[key] & 0x80);
}


BOOL DInput::mouseLEFT()
{
	return mouseLB;
}


BOOL DInput::mouseMIDDLE()
{
	return mouseMB;
}


BOOL DInput::mouseRIGHT()
{
	return mouseRB;
}


void DInput::setMousePos(int x, int y)
{
	mouseOldX = this->mouseX = x;
	mouseOldY = this->mouseY = y;
}


BOOL DInput::getMouseX()
{
	return mouseX;
}


BOOL DInput::getMouseY()
{
	return mouseY;
}
